/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.CtrlStrategy;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class TemplateDataListPlugin
extends AbstractListPlugin
implements BeforeFilterF7SelectListener {
    private static final Log log = LogFactory.getLog(TemplateDataListPlugin.class);
    private static final String SYSTEM_TYPE = "bos-noteprint";
    private static final String USE_ORG_FILED = "useorg.id";
    private static final String CUSTOM_FILTER = "customfilter";
    private static final String FAST_FILTER = "fastfilter";
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE_KEY = "Value";
    private static final String BILL_LIST = "billlistap";
    private static final String STRATEGY_CHANGE_CONFIRM = "ctrlStrategyChangeConfirm";
    private static final String STRATEGY_CHANGE_CALLBACK = "permChangeCallBack";
    private static final String ORG_CHANGE_CALLBACK = "permChangeCallBack";
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customFilter = null;
    private CommonFilterColumn filterColumn;
    private QFilter qfilter;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            List schemeColumnList;
            FilterContainerInitEvent event = args.getFilterContainerInitEvent();
            List filterColumnList = event.getCommonFilterColumns();
            if (!CollectionUtils.isEmpty((Collection)filterColumnList)) {
                filterColumnList.removeIf(column -> "ctrlstrategy".equals(column.getFieldName()) || "enable".equals(column.getFieldName()));
            }
            if (!CollectionUtils.isEmpty((Collection)(schemeColumnList = event.getSchemeFilterColumns()))) {
                schemeColumnList.removeIf(column -> "ctrlstrategy".equals(column.getFieldName()) || "enable".equals(column.getFieldName()));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtergridview", "schemefilterview"});
            return;
        }
        FormConfig formConfig = this.getView().getFormShowParameter().getFormConfig();
        if (formConfig != null && "bos_listf7".equals(formConfig.getEntityTypeId())) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        LocaleString orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7", (String)"TemplateDataListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(orgPropertyName);
        orgColumn.setFieldName(USE_ORG_FILED);
        orgColumn.setMustInput(true);
        orgColumn.setEntityField(false);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        DynamicObjectCollection col = PrintTemplateDataService.getAllUserPermOrg();
        String defaultOrg = String.valueOf(RequestContext.get().getOrgId());
        for (Object org : col) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            String ordId = String.valueOf(org.get("id"));
            item.setValue(ordId);
            if (defaultOrg.equals(ordId)) {
                combos.add(0, item);
                continue;
            }
            combos.add(item);
        }
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        String createOrg = this.getPageCache().get("createOrg");
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            orgColumn.setDefaultValue(defaultOrg);
        } else {
            orgColumn.setDefaultValue(createOrg);
        }
        filterColumnList.add(0, orgColumn);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put(FAST_FILTER, new ArrayList());
            this.filterValues.put(CUSTOM_FILTER, new ArrayList());
            for (FilterColumn column2 : filterColumnList) {
                HashMap<String, List> customFilterInner = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(column2.getFieldName());
                customFilterInner.put(FIELD_NAME, fieldName);
                if (USE_ORG_FILED.equals(column2.getFieldName())) {
                    ArrayList<String> value = new ArrayList<String>();
                    if (StringUtils.isBlank((CharSequence)createOrg)) {
                        value.add(defaultOrg);
                        this.getPageCache().put("createOrg", defaultOrg);
                        this.getPageCache().put("verifyOrg", defaultOrg);
                    } else {
                        value.add(createOrg);
                        this.getPageCache().put("createOrg", createOrg);
                        this.getPageCache().put("verifyOrg", createOrg);
                    }
                    customFilterInner.put(VALUE_KEY, value);
                } else if (column2.getDefaultValues() != null && !column2.getDefaultValues().isEmpty()) {
                    customFilterInner.put(VALUE_KEY, column2.getDefaultValues());
                }
                if (customFilterInner.get(VALUE_KEY) == null) continue;
                this.filterValues.get(CUSTOM_FILTER).add(customFilterInner);
            }
            this.customFilter = this.filterValues.get(CUSTOM_FILTER);
            this.filterColumn = orgColumn;
            String customFilterStr = SerializationUtils.toJsonString(this.customFilter);
            this.getPageCache().put(CUSTOM_FILTER, customFilterStr);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFilterList = this.filterValues.get(CUSTOM_FILTER);
        if (customFilterList == null) {
            return;
        }
        String customFilterStr = SerializationUtils.toJsonString(customFilterList);
        this.getPageCache().remove(CUSTOM_FILTER);
        this.getPageCache().put(CUSTOM_FILTER, customFilterStr);
        Iterator<Map<String, List<Object>>> iterator = customFilterList.iterator();
        while (iterator.hasNext()) {
            List<Object> orgIds;
            Map<String, List<Object>> customFilterInner = iterator.next();
            List<Object> fieldNames = customFilterInner.get(FIELD_NAME);
            if (fieldNames == null || fieldNames.isEmpty() || !USE_ORG_FILED.equals(fieldNames.get(0)) || (orgIds = customFilterInner.get(VALUE_KEY)) == null || orgIds.isEmpty()) continue;
            String orgId = String.valueOf(orgIds.get(0));
            iterator.remove();
            this.getPageCache().put("createOrg", orgId);
            this.getPageCache().put("verifyOrg", orgId);
            break;
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        String useOrg = this.getPageCache().get("createOrg");
        if (this.filterColumn != null) {
            this.filterColumn.setDefaultValue(useOrg);
        }
    }

    public void setFilter(SetFilterEvent e) {
        e.setMainOrgQFilter(null);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        String customFilterSer = this.getPageCache().get(CUSTOM_FILTER);
        if (customFilterSer != null) {
            this.customFilter = (List)SerializationUtils.fromJsonString((String)customFilterSer, ArrayList.class);
            for (Map<String, List<Object>> filter : this.customFilter) {
                List<Object> fieldNames = filter.get(FIELD_NAME);
                if (CollectionUtils.isEmpty(fieldNames) || !USE_ORG_FILED.equals(fieldNames.get(0))) continue;
                List<Object> orgFilterIds = filter.get(VALUE_KEY);
                if (!CollectionUtils.isEmpty(orgFilterIds)) {
                    Object orgId = orgFilterIds.get(0);
                    if (orgId == null || StringUtils.isBlank((Object)orgId)) {
                        this.qfilter = new QFilter("id", "=", (Object)-1L);
                        break;
                    }
                    String entity = ((AbstractListView)this.getView()).getEntityTypeId();
                    String entityID = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
                    BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityID);
                    String baseDataTableName = dt.getAlias() + "usage";
                    String sql = String.format(" (select fdataid from %s where fuseorgid = %d)", baseDataTableName, Long.parseLong(orgId.toString()));
                    QFilter useRangeFilter = QFilter.sqlExpress((String)"id", (String)"in", (String)sql);
                    Tuple<Boolean, List<String>> ctrlStrategy = this.isHaveCtrlStrategyCondition(this.customFilter);
                    if (((Boolean)ctrlStrategy.item1).booleanValue()) {
                        if (((List)ctrlStrategy.item2).contains(CtrlStrategy.GLOBAL.getValue())) {
                            this.qfilter = new QFilter("ctrlstrategy", "=", (Object)CtrlStrategy.GLOBAL.getValue());
                            ((List)ctrlStrategy.item2).remove(CtrlStrategy.GLOBAL.getValue());
                            if (((List)ctrlStrategy.item2).size() <= 0) break;
                            this.qfilter.or(new QFilter("ctrlstrategy", "in", ctrlStrategy.item2).and(useRangeFilter));
                            break;
                        }
                        this.qfilter = new QFilter("ctrlstrategy", "in", ctrlStrategy.item2).and(useRangeFilter);
                        break;
                    }
                    this.qfilter = new QFilter("ctrlstrategy", "=", (Object)CtrlStrategy.GLOBAL.getValue()).or(useRangeFilter);
                    break;
                }
                this.qfilter = new QFilter("id", "=", (Object)-1L);
                break;
            }
        }
        List filters = e.getQFilters();
        if (this.qfilter != null) {
            String billFormId;
            if (this.getView() instanceof ListView && "bos_manageprinttpl".equals(billFormId = ((ListView)this.getView()).getBillFormId())) {
                QFilter qFilter = new QFilter("type", "=", (Object)"B");
            }
            filters.add(this.qfilter);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        String fieldName = args.getFieldName();
        if (USE_ORG_FILED.equals(fieldName)) {
            long userId = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
            if (result != null) {
                List orgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"15") : result.getHasPermOrgs();
                QFilter idsFilter = new QFilter("id", "in", (Object)orgIds);
                args.getQfilters().add(idsFilter);
            }
            args.addCustomParam("islockfunc", (Object)true);
            args.addCustomParam("orgFuncId", (Object)"15");
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent evt) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"allocate", "allocatequery", "changestrategy", "changeorg"});
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns;
        if (!ParamUtils.isTemplateOrgIsolated() && !CollectionUtils.isEmpty((Collection)(listColumns = args.getListColumns()))) {
            Iterator iterator = listColumns.iterator();
            while (iterator.hasNext()) {
                IListColumn column = (IListColumn)iterator.next();
                if (!"ctrlstrategy".equals(column.getListFieldKey()) && !"createorg.name".equals(column.getListFieldKey())) continue;
                iterator.remove();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
            List<String> orgPermKeys = Arrays.asList("donothing_allocate", "donothing_query", "donothing_cstrategy", "donothing_corg", "donothing_query_bydata");
            if (!ParamUtils.isTemplateOrgIsolated() && orgPermKeys.contains(operateKey)) {
                return;
            }
            List<Long> ids = this.getSelectDataId();
            Tuple resultIsv = !"donothing_query".equals(operateKey) && !"donothing_query_bydata".equals(operateKey) ? this.checkIsPredefined(ids) : new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u5957\u6253\u6a21\u7248\u4f9b\u5e94\u5546\u6821\u9a8c\u5931\u8d25\u3002", (String)"TemplateDataListPlugin_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            switch (operateKey) {
                case "donothing_allocate": {
                    if (((Boolean)resultIsv.item1).booleanValue()) {
                        this.showAllocateForm(this.getSelectDataId());
                        break;
                    }
                    this.getView().showTipNotification((String)resultIsv.item2);
                    break;
                }
                case "donothing_query": {
                    this.showUnAllocateForm();
                    break;
                }
                case "donothing_cstrategy": {
                    if (((Boolean)resultIsv.item1).booleanValue()) {
                        Tuple<Boolean, String> result = this.changeCtrlStrategy(ids);
                        if (((Boolean)result.item1).booleanValue()) {
                            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u5c06\u4f1a\u5f71\u54cd\u5957\u6253\u6a21\u677f\u7684\u4f7f\u7528\uff0c\u8bf7\u8c28\u614e\u64cd\u4f5c\uff0c\u786e\u8ba4\u8981\u53d8\u66f4\u5417\uff1f", (String)"TemplateDataListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(STRATEGY_CHANGE_CONFIRM, (IFormPlugin)this));
                            break;
                        }
                        this.getView().showTipNotification((String)result.item2);
                        break;
                    }
                    this.getView().showTipNotification((String)resultIsv.item2);
                    break;
                }
                case "donothing_corg": {
                    if (((Boolean)resultIsv.item1).booleanValue()) {
                        Tuple<Boolean, String> data = this.changeCreateOrg(ids);
                        if (((Boolean)data.item1).booleanValue()) {
                            this.goToOrgChangeForm(ids);
                            break;
                        }
                        this.getView().showTipNotification((String)data.item2);
                        break;
                    }
                    this.getView().showTipNotification((String)resultIsv.item2);
                    break;
                }
                case "donothing_query_bydata": {
                    this.showAllocateQueryByDataForm();
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        String entityID = ((AbstractListView)this.getView()).getEntityTypeId();
        if (STRATEGY_CHANGE_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            List<Long> ids = this.getSelectDataId();
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String entityName = ((ListView)this.getView()).getBillFormId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)ids.get(0), (String)entityName, (String)"ctrlstrategy ,createorg");
            params.put("ids", ids);
            params.put("ctrlStrategy", dynamicObject.getString("ctrlstrategy"));
            params.put("entityName", entityName);
            DynamicObject createOrg = dynamicObject.getDynamicObject("createorg");
            if (createOrg != null) {
                params.put("createOrgId", createOrg.getPkValue());
            }
            CloseCallBack ccb = new CloseCallBack((IFormPlugin)this, "permChangeCallBack");
            this.showForm("bos_printtpl_changectrl", params, ccb, ShowType.Modal);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (!ParamUtils.isTemplateOrgIsolated()) {
            return;
        }
        String callBackId = closedCallBackEvent.getActionId();
        if ("permChangeCallBack".equals(callBackId)) {
            ((IListView)this.getView()).refresh();
            BillList billList = (BillList)this.getControl(BILL_LIST);
            billList.clearSelection();
            billList.refresh();
        }
    }

    private void goToOrgChangeForm(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String entityName = ((ListView)this.getView()).getBillFormId();
        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)ids.get(0), (String)entityName, (String)"createorg");
        DynamicObject createOrg = data.getDynamicObject("createorg");
        params.put("ids", ids);
        if (createOrg != null) {
            params.put("createOrg", createOrg.getPkValue());
        } else {
            params.put("createOrg", -1);
        }
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "permChangeCallBack");
        this.showForm("bos_printtpl_changeorg", params, callBack, ShowType.Modal);
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private List<Long> getSelectDataId() {
        BillList grid = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if (selectedRows != null && !selectedRows.isEmpty()) {
            ArrayList<Long> pkList = new ArrayList<Long>(10);
            for (ListSelectedRow row : selectedRows) {
                pkList.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
            }
            return pkList;
        }
        return Collections.emptyList();
    }

    private void showAllocateForm(List<Long> ids) {
        if (ids != null && !ids.isEmpty()) {
            Tuple<Boolean, String> result = this.checkAllocateData(ids);
            if (((Boolean)result.item1).booleanValue()) {
                FormShowParameter param = new FormShowParameter();
                HashMap<String, Object> params = new HashMap<String, Object>(16);
                params.put("ids", ids);
                params.put("numbers", null);
                params.put("query", Boolean.FALSE);
                params.put("entityNumber", ((ListView)this.getView()).getBillFormId());
                params.put("useOrgId", null);
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setFormId("bos_printtpl_assign");
                param.setCustomParams(params);
                this.getView().showForm(param);
            } else {
                this.getView().showTipNotification((String)result.item2);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6570\u636e\u3002", (String)"TemplateDataListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    private void showAllocateQueryByDataForm() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_printtpl_query_bydata");
        BillList grid = (BillList)this.getView().getControl(BILL_LIST);
        ListSelectedRowCollection selectedRows = grid.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            List pkIds = selectedRows.stream().map(selectedRow -> selectedRow.getPrimaryKeyValue()).collect(Collectors.toList());
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])pkIds.toArray(), (String)"bos_manageprinttpl");
            for (Object primaryKeyValue : pkIds) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectMap.get(primaryKeyValue);
                if (dynamicObject == null || !"2".equals(dynamicObject.getString("ctrlstrategy"))) continue;
                param.setCustomParam("TPL_ID", (Object)dynamicObject.getLong("id"));
                break;
            }
        }
        this.getView().showForm(param);
    }

    private void showUnAllocateForm() {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("bos_printtpl_assign_query");
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("entityNumber", ((ListView)this.getView()).getBillFormId());
        param.setCustomParams(params);
        this.getView().showForm(param);
    }

    private Tuple<Boolean, String> checkAllocateData(List<Long> ids) {
        Tuple<Set<String>, Map<Long, DynamicObject>> data = PrintTemplateDataService.getTemplateDataCtrlStrategyById(ids, ((ListView)this.getView()).getBillFormId());
        Set ctrlStrategy = (Set)data.item1;
        if (ctrlStrategy.size() > 1) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u5206\u914d\u3002", (String)"TemplateDataListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String strategy = (String)ctrlStrategy.iterator().next();
        if (!CtrlStrategy.FREE.getValue().equals(strategy)) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u4e3a\u201c\u5206\u914d\u201d\u7c7b\u578b\u7684\u6570\u636e\u624d\u80fd\u5206\u914d\u3002", (String)"TemplateDataListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        ArrayList<String> numbers = new ArrayList<String>(10);
        Long currentUserOrg = Long.parseLong(this.getPageCache().get("createOrg"));
        Map templateData = (Map)data.item2;
        for (Map.Entry entry : templateData.entrySet()) {
            DynamicObject object = (DynamicObject)entry.getValue();
            String number = object.getString("printtplid.number");
            Long createOrgId = object.getLong("createorg.id");
            if (currentUserOrg.equals(createOrgId)) continue;
            numbers.add(number);
        }
        if (!numbers.isEmpty()) {
            String numberStr = String.join((CharSequence)"\u3001", numbers);
            return new Tuple((Object)false, (Object)String.format(ResManager.loadKDString((String)"%s\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u6570\u636e\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5206\u914d\u3002", (String)"TemplateDataListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), numberStr));
        }
        return new Tuple((Object)true, null);
    }

    private Tuple<Boolean, String> changeCtrlStrategy(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u7684\u6570\u636e\u3002", (String)"TemplateDataListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Tuple<Set<String>, Map<Long, DynamicObject>> data = PrintTemplateDataService.getTemplateDataCtrlStrategyById(ids, ((ListView)this.getView()).getBillFormId());
        Set ctrlStrategy = (Set)data.item1;
        if (ctrlStrategy.size() > 1) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"TemplateDataListPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Map templateData = (Map)data.item2;
        List<Long> allocateData = PrintTemplateDataService.getAllocateDataIdByDataId(ids);
        if (allocateData.isEmpty()) {
            HashSet<Long> createOrgs = new HashSet<Long>(10);
            String useOrg = this.getPageCache().get("createOrg");
            for (Map.Entry entry : templateData.entrySet()) {
                DynamicObject object = (DynamicObject)entry.getValue();
                Object createOrgId = object.get("createorg.id");
                if (createOrgId == null || Long.parseLong(createOrgId.toString()) == 0L) continue;
                createOrgs.add(Long.parseLong(createOrgId.toString()));
            }
            if (createOrgs.isEmpty()) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u4e3a\u7a7a\u7684\u6570\u636e\u9700\u5148\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"TemplateDataListPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (createOrgs.size() > 1) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"TemplateDataListPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!String.valueOf(createOrgs.iterator().next()).equals(useOrg)) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u548c\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"TemplateDataListPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            return new Tuple((Object)true, null);
        }
        ArrayList<String> numbers = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            DynamicObject obj = (DynamicObject)templateData.get(id);
            String number = obj.getString("printtplid.number");
            if (!allocateData.contains(id)) continue;
            numbers.add(number);
        }
        String numberStr = String.join((CharSequence)"\u3001", numbers);
        return new Tuple((Object)false, (Object)String.format(ResManager.loadKDString((String)"%s\u672a\u5206\u914d\u7684\u5957\u6253\u6a21\u7248\u624d\u80fd\u53d8\u66f4\u63a7\u5236\u7b56\u7565\u3002", (String)"TemplateDataListPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), numberStr));
    }

    private Tuple<Boolean, String> changeCreateOrg(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u7684\u6570\u636e\u3002", (String)"TemplateDataListPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Tuple<Set<String>, Map<Long, DynamicObject>> data = PrintTemplateDataService.getTemplateDataCtrlStrategyById(ids, ((ListView)this.getView()).getBillFormId());
        Set ctrlStrategy = (Set)data.item1;
        if (ctrlStrategy.size() > 1) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u63a7\u5236\u7b56\u7565\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TemplateDataListPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        Map templateData = (Map)data.item2;
        List<Long> allocateData = PrintTemplateDataService.getAllocateDataIdByDataId(ids);
        if (allocateData.isEmpty()) {
            HashSet<Long> createOrgs = new HashSet<Long>(10);
            String useOrg = this.getPageCache().get("createOrg");
            for (Map.Entry entry : templateData.entrySet()) {
                DynamicObject object = (DynamicObject)entry.getValue();
                Object createOrgId = object.get("createorg.id");
                if (createOrgId == null || Long.parseLong(createOrgId.toString()) == 0L) continue;
                createOrgs.add(Long.parseLong(createOrgId.toString()));
            }
            if (createOrgs.size() > 1) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u6279\u91cf\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TemplateDataListPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!createOrgs.isEmpty() && !String.valueOf(createOrgs.iterator().next()).equals(useOrg)) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u548c\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u76f8\u540c\u7684\u6570\u636e\u624d\u80fd\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TemplateDataListPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            return new Tuple((Object)true, null);
        }
        ArrayList<String> numbers = new ArrayList<String>(ids.size());
        for (Long id : ids) {
            DynamicObject obj = (DynamicObject)templateData.get(id);
            String number = obj.getString("printtplid.number");
            if (!allocateData.contains(id)) continue;
            numbers.add(number);
        }
        String numberStr = String.join((CharSequence)"\u3001", numbers);
        return new Tuple((Object)false, (Object)String.format(ResManager.loadKDString((String)"%s\u672a\u5206\u914d\u7684\u5957\u6253\u6a21\u677f\u624d\u80fd\u53d8\u66f4\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"TemplateDataListPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), numberStr));
    }

    private Tuple<Boolean, List<String>> isHaveCtrlStrategyCondition(List<Map<String, List<Object>>> filters) {
        for (Map<String, List<Object>> filter : filters) {
            List<Object> conditions;
            List ctrlStrategys;
            List<Object> values = filter.get(FIELD_NAME);
            if (CollectionUtils.isEmpty(values) || !"ctrlstrategy".equals(values.get(0)) || (ctrlStrategys = (conditions = filter.get(VALUE_KEY)).stream().map(Object::toString).filter(StringUtils::isNotEmpty).collect(Collectors.toList())).size() <= 0) continue;
            return new Tuple((Object)true, ctrlStrategys);
        }
        return new Tuple((Object)false, new ArrayList(0));
    }

    private Tuple<Boolean, String> checkIsPredefined(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"TemplateDataListPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        List<Map<String, Object>> templates = PrintTemplateDataService.getPrintTemplateDataList(ids, this.checkIsNewTemplate());
        if (!CollectionUtils.isEmpty(templates)) {
            HashSet<String> isvSet = new HashSet<String>(10);
            for (Map<String, Object> template : templates) {
                Object isv = template.get("isv");
                if (isv == null) continue;
                isvSet.add(isv.toString());
            }
            if (isvSet.size() > 1) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u7248\u548c\u975e\u9884\u7f6e\u6a21\u7248\u4e0d\u80fd\u6279\u91cf\u64cd\u4f5c\u3002", (String)"TemplateDataListPlugin_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (!isvSet.isEmpty() && String.valueOf(isvSet.iterator().next()).equals("kingdee")) {
                return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u9884\u7f6e\u6a21\u7248\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"TemplateDataListPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            return new Tuple((Object)true, null);
        }
        return new Tuple((Object)false, (Object)ResManager.loadKDString((String)"\u5957\u6253\u6a21\u7248\u5143\u6570\u636e\u5df2\u88ab\u5220\u9664\u3002", (String)"TemplateDataListPlugin_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
    }

    private boolean checkIsNewTemplate() {
        String billFormId;
        return this.getView() instanceof ListView && "bos_manageprinttpl".equals(billFormId = ((ListView)this.getView()).getBillFormId());
    }
}

