/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.business.utils.PrintOpLogMsgEnum;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;

public class TemplateUnAllocateFormPlugin
extends AbstractListPlugin
implements SearchEnterListener,
EntryGridBindDataListener {
    private static Log logger = LogFactory.getLog(TemplateUnAllocateFormPlugin.class);
    private static final String NAME = "name";
    public static final String NUMBER = "number";
    public static final String ENTRY_ENTITY = "entryentity";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid billList = (EntryGrid)this.getControl(ENTRY_ENTITY);
        billList.addDataBindListener((EntryGridBindDataListener)this);
        this.addClickListeners(new String[]{"btn_query", "btn_assign_cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals("btn_query")) {
            String filedListStr = this.getPageCache().get("filedList");
            String filedValueStr = this.getPageCache().get("searchfiled");
            ArrayList<String> filedList = StringUtils.isNotBlank((CharSequence)filedListStr) ? (ArrayList<String>)SerializationUtils.fromJsonString((String)filedListStr, List.class) : new ArrayList<String>(10);
            ArrayList<String> filedValueList = StringUtils.isNotBlank((CharSequence)filedValueStr) ? (ArrayList<String>)SerializationUtils.fromJsonString((String)filedValueStr, List.class) : new ArrayList<String>(10);
            this.queryData(filedList, filedValueList);
            PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)"", (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_ALLOCATE_QUERY);
        } else if (control.getKey().equals("btn_assign_cancel")) {
            this.cancelAllocate();
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        List searchFields = searchEnterEvent.getSearchFields();
        if (searchFields == null) {
            this.getPageCache().put("filedList", null);
            this.getPageCache().put("searchfiled", null);
            this.queryData(Collections.emptyList(), Collections.emptyList());
        } else {
            List filedList = (List)((Map)searchFields.get(0)).get("fieldName");
            List text = (List)((Map)searchFields.get(0)).get("value");
            String fileListStr = SerializationUtils.toJsonString((Object)filedList);
            String textStr = SerializationUtils.toJsonString((Object)text);
            this.getPageCache().put("filedList", fileListStr);
            this.getPageCache().put("searchfiled", textStr);
            this.queryData(filedList, text);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        e.getStartIndex();
    }

    private void queryData(List<String> filedList, List<String> filedValueList) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List userOrgIDs = treeView.getTreeState().getCheckedNodeIds();
        if (CollectionUtils.isEmpty((Collection)userOrgIDs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u67e5\u8be2\u7ec4\u7ec7\u3002", (String)"TemplateUnAllocateFormPlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        List<Long> orgIds = userOrgIDs.stream().map(s -> Long.parseLong(s)).collect(Collectors.toList());
        List<Map<String, Object>> allocateData = PrintTemplateDataService.getAllocateDataByUseOrg(orgIds);
        if (!CollectionUtils.isEmpty(allocateData)) {
            HashSet<Long> dataIds = new HashSet<Long>(allocateData.size());
            for (Map<String, Object> temp : allocateData) {
                dataIds.add(Long.parseLong(String.valueOf(temp.get("dataId"))));
            }
            Map<Long, DynamicObject> templateData = PrintTemplateDataService.getPrintTemplateDataById(dataIds);
            Map<Long, DynamicObject> orgData = PrintTemplateDataService.getUsageOrgById(orgIds);
            this.buildBillListData(allocateData, templateData, orgData, filedList, filedValueList);
        } else {
            this.refreshBillList(Collections.emptyList());
        }
    }

    private void buildBillListData(List<Map<String, Object>> allocateData, Map<Long, DynamicObject> templateData, Map<Long, DynamicObject> orgData, List<String> filedList, List<String> filedValueList) {
        Iterator<Map<String, Object>> iterator = allocateData.iterator();
        ArrayList<Map<String, Object>> billListData = new ArrayList<Map<String, Object>>(10);
        while (iterator.hasNext()) {
            Map<String, Object> row = iterator.next();
            Long dataId = (Long)row.get("dataId");
            Long useOrgId = (Long)row.get("useOrgId");
            Object createOrgId = row.get("createOrgId");
            DynamicObject template = templateData.get(dataId);
            if (template == null) continue;
            String name = PrintTemplateDataService.getName(template, "printtplid.name");
            String number = template.getString("printtplid.number");
            String createOrgName = template.getString("createorg.name");
            DynamicObject usageOrg = orgData.get(useOrgId);
            String usageOrgName = usageOrg.getString("org.name");
            boolean isMatching = this.isMatching(filedList, filedValueList, name, number);
            if (isMatching) {
                HashMap<String, Object> bill = new HashMap<String, Object>(16);
                bill.put(NUMBER, number);
                bill.put(NAME, name);
                bill.put("createorg", createOrgName);
                bill.put("useorg", usageOrgName);
                bill.put("dataid", dataId);
                bill.put("useorgid", useOrgId);
                billListData.add(bill);
                continue;
            }
            iterator.remove();
        }
        this.refreshBillList(billListData);
    }

    private boolean isMatching(List<String> filedList, List<String> filedValueList, String name, String number) {
        boolean isMatching = true;
        if (!CollectionUtils.isEmpty(filedList) && !CollectionUtils.isEmpty(filedValueList)) {
            boolean refName = true;
            boolean refNumber = true;
            for (int i = 0; i < filedList.size(); ++i) {
                if (NAME.equals(filedList.get(i))) {
                    int notRefNameSize = 0;
                    for (String filedValue : filedValueList) {
                        if (name.contains(filedValue)) continue;
                        ++notRefNameSize;
                    }
                    if (notRefNameSize == filedValueList.size()) {
                        refName = false;
                    }
                }
                if (NUMBER.equals(filedList.get(i))) {
                    int notRefbdNumberSize = 0;
                    for (String filedValue : filedValueList) {
                        if (number.contains(filedValue)) continue;
                        ++notRefbdNumberSize;
                    }
                    if (notRefbdNumberSize == filedValueList.size()) {
                        refNumber = false;
                    }
                }
                if (filedList.size() == 2 && !refName && !refNumber) {
                    isMatching = false;
                }
                if (filedList.size() == 1 && NUMBER.equals(filedList.get(0)) && !refNumber) {
                    isMatching = false;
                }
                if (filedList.size() != 1 || !NAME.equals(filedList.get(0)) || refName) continue;
                isMatching = false;
            }
        }
        return isMatching;
    }

    private void cancelAllocate() {
        EntryGrid billList = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] rows = billList.getSelectRows();
        if (rows.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53d6\u6d88\u5206\u914d\u7684\u6570\u636e\u3002", (String)"TemplateUnAllocateFormPlugin_0", (String)"bos-noteprint", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] billListData = billList.getEntryData().getDataEntitys();
        ArrayList<Object[]> params = new ArrayList<Object[]>(rows.length);
        ArrayList<Integer> index = new ArrayList<Integer>(rows.length);
        ArrayList<DynamicObject> logDynamic = new ArrayList<DynamicObject>(10);
        for (int i : rows) {
            index.add(i);
            DynamicObject billListDatum = billListData[i];
            Object[] param = new Object[2];
            Object dataId = billListDatum.get("dataid");
            Object usageOrgId = billListDatum.get("useorgid");
            param[0] = dataId;
            param[1] = usageOrgId;
            params.add(param);
            logDynamic.add(billListDatum);
        }
        ArrayList<Map<String, Object>> retainData = new ArrayList<Map<String, Object>>(10);
        for (int j = 0; j < billListData.length; ++j) {
            if (index.contains(j)) continue;
            DynamicObject obj = billListData[j];
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put(NUMBER, obj.get(NUMBER));
            data.put(NAME, obj.get(NAME));
            data.put("createorg", obj.get("createorg"));
            data.put("useorg", obj.get("useorg"));
            data.put("dataid", obj.get("dataid"));
            data.put("useorgid", obj.get("useorgid"));
            retainData.add(data);
        }
        try {
            if (!CollectionUtils.isEmpty(params)) {
                PrintTemplateDataService.batchUnAllocate(params);
            }
            this.refreshBillList(retainData);
            this.addLog(logDynamic);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5df2\u53d6\u6d88\u3002", (String)"TemplateUnAllocateFormPlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("\u53d6\u6d88\u5206\u914d\u6570\u636e\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5206\u914d\u5931\u8d25\u3002", (String)"TemplateUnAllocateFormPlugin_2", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    private void addLog(List<DynamicObject> billListData) {
        for (DynamicObject dynamicObject : billListData) {
            String number = dynamicObject.getString(NUMBER);
            PrintOpLogUtils.addLog((IFormView)this.getView().getParentView(), (String)number, (PrintOpLogMsgEnum)PrintOpLogMsgEnum.TPL_CANSEL_ALLOCATE);
        }
    }

    private void refreshBillList(List<Map<String, Object>> billListData) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        if (!CollectionUtils.isEmpty(billListData)) {
            int index = 0;
            model.batchCreateNewEntryRow(ENTRY_ENTITY, billListData.size());
            DynamicObjectCollection doc = model.getEntryEntity(ENTRY_ENTITY);
            for (Map<String, Object> row : billListData) {
                ((DynamicObject)doc.get(index)).set(NUMBER, row.get(NUMBER));
                ((DynamicObject)doc.get(index)).set(NAME, row.get(NAME));
                ((DynamicObject)doc.get(index)).set("createorg", row.get("createorg"));
                ((DynamicObject)doc.get(index)).set("useorg", row.get("useorg"));
                ((DynamicObject)doc.get(index)).set("dataid", row.get("dataid"));
                ((DynamicObject)doc.get(index)).set("useorgid", row.get("useorgid"));
                ++index;
            }
            this.getModel().updateEntryCache(doc);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }
}

