/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.ORM;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.template.orgctrl.utils.CtrlStrategy;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintTemplateDataService {
    private static Log logger = LogFactory.getLog(PrintTemplateDataService.class);

    public static void updateByFormId(String formId, long createOrg, String ctrlStrategy) {
        String sql = "update t_bas_printtplinfo set fctrlstrategy=?,fcreateorg =? where  fprinttplid =?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fctrlstrategy", 12, (Object)ctrlStrategy));
        params.add(new SqlParameter("fcreateorg", -5, (Object)createOrg));
        params.add(new SqlParameter("fprinttplid", 12, (Object)formId));
        DB.update((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[0]));
    }

    public static void addAllocateData(String tplId, String ctrlStrategy, Long createOrgId) {
        String selectSql = "select fid from t_bas_printtplinfo where fprinttplid =?";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fprinttplid", 12, (Object)tplId));
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]));){
            if (!dataSet.isEmpty()) {
                long id = dataSet.next().getLong("fid");
                long pKey = ID.genLongId();
                String insertSql = " insert into t_bas_printtplinfousage (fid,fuseorgid, fdataid, fctrlstrategy,fisassign,fcreateorgid) values(?, ?, ?, ?,?,?) ";
                Object[] param = new Object[]{pKey, createOrgId, id, ctrlStrategy, "0", createOrgId};
                DB.execute((DBRoute)DBRoute.basedata, (String)insertSql, (Object[])param);
            }
        }
    }

    public static List<Map<String, Object>> getOrg(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String fields = "id,org,org.id,parent,parent.id,isleaf,org.number,org.name,longnumber";
        QFilter filter = new QFilter("org.id", "in", ids);
        QFilter filter1 = new QFilter("view.number", "=", (Object)"15");
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org_structure", (String)fields, (QFilter[])new QFilter[]{filter, filter1});
        Iterator iterator = org.iterator();
        ArrayList<Map<String, Object>> orgNodes = new ArrayList<Map<String, Object>>(10);
        while (iterator.hasNext()) {
            DynamicObject temp = (DynamicObject)iterator.next();
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("id", temp.getLong("org.id"));
            data.put("name", temp.getString("org.name"));
            data.put("number", temp.getString("org.number"));
            data.put("parentid", temp.getLong("parent.id"));
            data.put("isleaf", Character.valueOf(temp.getBoolean("isleaf") ? (char)'1' : '0'));
            data.put("longnumber", temp.getString("longnumber"));
            orgNodes.add(data);
        }
        return orgNodes;
    }

    public static List<TreeNode> getAllUserPermOrgTreeRootList() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (result == null) {
            return new ArrayList<TreeNode>(0);
        }
        List orgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"15") : result.getHasPermOrgs();
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgRangeList(orgIds);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        root.setParentid("");
        List<Map<String, Object>> org = PrintTemplateDataService.getOrg(orgIds);
        if (org.isEmpty()) {
            return new ArrayList<TreeNode>(0);
        }
        HashMap treeNodesMap = new HashMap(org.size());
        ArrayList<TreeNode> rootList = new ArrayList<TreeNode>(1);
        rootList.add(root);
        treeNodesMap.put("", rootList);
        for (Map<String, Object> map : org) {
            ArrayList<TreeNode> nodes;
            String nodeId = String.valueOf(map.get("id"));
            String parentId = String.valueOf(map.get("parentid"));
            String name = String.valueOf(map.get("name"));
            String number = String.valueOf(map.get("number"));
            String text = name;
            TreeNode treeNode = new TreeNode(parentId, nodeId, text, (Object)number);
            treeNode.setLongNumber(String.valueOf(map.get("longnumber")));
            treeNode.setLeaf(!"0".equals(String.valueOf(map.get("isleaf"))));
            if (treeNodesMap.containsKey(parentId)) {
                nodes = (ArrayList<TreeNode>)treeNodesMap.get(parentId);
                nodes.add(treeNode);
                treeNodesMap.put(parentId, nodes);
                continue;
            }
            nodes = new ArrayList<TreeNode>(10);
            nodes.add(treeNode);
            treeNodesMap.put(parentId, nodes);
        }
        for (Map.Entry entry : treeNodesMap.entrySet()) {
            for (TreeNode treeNode : (List)entry.getValue()) {
                String id = treeNode.getId();
                List children = (List)treeNodesMap.get(id);
                if (children == null || children.isEmpty()) continue;
                children.sort(Comparator.comparing(TreeNode::getText));
                treeNode.setChildren(children);
            }
        }
        return (List)treeNodesMap.get("");
    }

    public static Tuple<List<TreeNode>, Map<String, TreeNode>> getAllUserPermOrgTree() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        if (result != null) {
            List orgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"15") : result.getHasPermOrgs();
            OrgTreeParam param = new OrgTreeParam();
            param.setOrgRangeList(orgIds);
            TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
            root.setParentid("");
            String rootId = root.getId();
            boolean isHaveTopOrg = false;
            List<Map<String, Object>> org = PrintTemplateDataService.getOrg(orgIds);
            if (!org.isEmpty()) {
                ArrayList<Object> treeNodes = new ArrayList<Object>(org.size());
                ArrayList<TreeNode> unCheckTreeNodes = new ArrayList<TreeNode>(10);
                HashMap<String, TreeNode> treeNodeMap = new HashMap<String, TreeNode>(org.size());
                for (Map<String, Object> data : org) {
                    String nodeId = String.valueOf(data.get("id"));
                    String parentId = String.valueOf(data.get("parentid"));
                    TreeNode tn = new TreeNode(parentId, nodeId, String.valueOf(data.get("name")), (Object)String.valueOf(data.get("number")));
                    tn.setLongNumber(String.valueOf(data.get("longnumber")));
                    tn.setLeaf(!"0".equals(String.valueOf(data.get("isleaf"))));
                    if (rootId.equals(nodeId)) {
                        isHaveTopOrg = true;
                        root.setData((Object)String.valueOf(data.get("number")));
                        root.setLongNumber(String.valueOf(data.get("longnumber")));
                        treeNodeMap.put(nodeId, root);
                        continue;
                    }
                    treeNodeMap.put(nodeId, tn);
                    if (rootId.equals(parentId)) {
                        unCheckTreeNodes.add(tn);
                        continue;
                    }
                    if (!orgIds.contains(Long.parseLong(parentId))) {
                        tn.setParentid("");
                    }
                    treeNodes.add(tn);
                }
                if (!isHaveTopOrg) {
                    for (TreeNode temp : unCheckTreeNodes) {
                        temp.setParentid("");
                    }
                }
                for (int i = 0; i < unCheckTreeNodes.size(); ++i) {
                    treeNodes.add(i, unCheckTreeNodes.get(i));
                }
                if (isHaveTopOrg) {
                    treeNodes.add(0, root);
                }
                return new Tuple(treeNodes, treeNodeMap);
            }
        }
        return new Tuple(Collections.emptyList(), Collections.emptyMap());
    }

    public static void batchUnAllocate(List<Object[]> params) {
        String deleteSql = "delete from t_bas_printtplinfousage where fdataid= ? and fuseorgid = ?";
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)DBRoute.basedata, (String)deleteSql, params);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u53d6\u6d88\u5206\u914d\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDException(ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6d88\u5206\u914d\u6570\u636e\u5f02\u5e38\u3002", (String)"PrintTemplateDataService_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    public static void singleUnAllocate(long dataId, List<Object> orgIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_bas_printtplinfousage where fdataid= " + dataId, new Object[0]);
        sqlBuilder.append(" and ", new Object[0]);
        sqlBuilder.appendIn("fuseorgid", orgIds);
        try (TXHandle h = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
        }
        catch (Exception e) {
            logger.error("\u6279\u91cf\u53d6\u6d88\u5206\u914d\u6570\u636e\u5f02\u5e38\u3002", (Throwable)e);
            throw new KDException(ResManager.loadKDString((String)"\u6279\u91cf\u53d6\u6d88\u5206\u914d\u6570\u636e\u5f02\u5e38\u3002", (String)"PrintTemplateDataService_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
    }

    public static void batchAllocate(List<Long> dataIds, Set<Long> orgIds) {
        PrintTemplateDataService.batchAllocate(dataIds, orgIds, "1");
    }

    public static void batchAllocate(List<Long> dataIds, Set<Long> orgIds, String isAssign) {
        String insertSql = " insert into t_bas_printtplinfousage (fid,fuseorgid, fdataid, fctrlstrategy,fisassign,fcreateorgid) values(?,?, ?, ?, ?,?) ";
        QFilter[] qFilters = ConfigConstUtil.isNewTenantOfVersion((int)7) ? new QFilter[]{new QFilter("id", "in", dataIds), new QFilter("type", "!=", (Object)"A")} : new QFilter[]{new QFilter("id", "in", dataIds)};
        DynamicObjectCollection data = QueryServiceHelper.query((String)"bos_manageprinttpl", (String)"id,createorg.id,ctrlstrategy", (QFilter[])qFilters);
        Iterator iterator = data.iterator();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(data.size());
        while (iterator.hasNext()) {
            DynamicObject obj = (DynamicObject)iterator.next();
            dataMap.put(obj.getLong("id"), obj);
        }
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid,fuseorgid from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fuseorgid", new ArrayList<Long>(orgIds));
        useRegQuery.append("  and ", new Object[0]);
        useRegQuery.appendIn("fdataid", new ArrayList<Long>(dataIds));
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            HashSet<String> currentDataKey = new HashSet<String>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                currentDataKey.add(row.getLong("fdataid") + "_" + row.getLong("fuseorgid"));
            }
            long[] ids = ID.genLongIds((int)(dataIds.size() * orgIds.size()));
            LinkedList idsQueue = new LinkedList(CollectionUtils.arrayToList((Object)ids));
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(10);
            for (Long dataId : dataIds) {
                for (Long orgId : orgIds) {
                    String key = dataId + "_" + orgId;
                    if (currentDataKey.contains(key)) continue;
                    DynamicObject obj = (DynamicObject)dataMap.get(dataId);
                    String ctrlStrategy = obj.getString("ctrlstrategy");
                    if (StringUtils.isBlank((CharSequence)ctrlStrategy)) {
                        ctrlStrategy = CtrlStrategy.GLOBAL.getValue();
                    }
                    long createOrgId = obj.getLong("createorg.id");
                    Object[] params = new Object[]{idsQueue.poll(), orgId, dataId, ctrlStrategy, isAssign, createOrgId};
                    paramsList.add(params);
                }
            }
            try (TXHandle h = TX.requiresNew();){
                if (!CollectionUtils.isEmpty(paramsList)) {
                    DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql, paramsList);
                }
            }
            catch (Exception e) {
                logger.error("\u6279\u91cf\u5206\u914d\u6570\u636e\u5f02\u5e38", (Throwable)e);
                throw new KDException(ResManager.loadKDString((String)"\u6279\u91cf\u5206\u914d\u6570\u636e\u5f02\u5e38\u3002", (String)"PrintTemplateDataService_1", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_bas_printtplinfo");
            cacheManager.removeByPrimaryKey(dataIds.toArray());
        }
    }

    public static List<Map<String, Object>> getAllocateDataByUseOrg(List<Long> orgIds) {
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid,fuseorgid,fcreateorgid from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fuseorgid", new ArrayList<Long>(orgIds));
        useRegQuery.append("  and  fuseorgid <> fcreateorgid ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Long> data = new HashMap<String, Long>(4);
                data.put("dataId", row.getLong("fdataid"));
                data.put("useOrgId", row.getLong("fuseorgid"));
                data.put("createOrgId", row.getLong("fcreateorgid"));
                result.add(data);
            }
            ArrayList<Map<String, Object>> arrayList = result;
            return arrayList;
        }
    }

    public static Map<Long, DynamicObject> getPrintTemplateDataById(Set<Long> ids) {
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"id,createorg.name,createorg.id,ctrlstrategy,printtplid.number,printtplid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(data.length);
        if (data != null && data.length > 0) {
            for (DynamicObject obj : data) {
                dataMap.put(obj.getLong("id"), obj);
            }
        }
        return dataMap;
    }

    public static Map<Long, DynamicObject> getPrintTemplateDataById(Set<Long> ids, String entityNumber) {
        DynamicObject[] data;
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            entityNumber = "bas_manageprinttpl";
        }
        if ((data = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,type,createorg.name,createorg.id,ctrlstrategy,printtplid.number,printtplid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) != null && data.length > 0) {
            HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(data.length);
            for (DynamicObject obj : data) {
                if ("bos_manageprinttpl".equals(entityNumber) && "B".equals(obj.get("type"))) {
                    dataMap.put(obj.getLong("id"), obj);
                    continue;
                }
                if (!"bas_manageprinttpl".equals(entityNumber) || "B".equals(obj.get("type"))) continue;
                dataMap.put(obj.getLong("id"), obj);
            }
            return dataMap;
        }
        return Collections.emptyMap();
    }

    private static List<Map<String, Object>> getNewPrintTemplateByIdAndBillId(List<Long> ids, String billFormId) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter billFilter = new QFilter("billformid", "=", (Object)PrintServiceHelper.getRealBillFormId(billFormId));
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        String selectFields = "id,isdefault,printtplid.number,printtplid.name,printtplid.id,type";
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)selectFields, (QFilter[])new QFilter[]{idFilter, billFilter, statusFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(data.length);
        for (DynamicObject obj : data) {
            HashMap<String, Object> temp = new HashMap<String, Object>(16);
            temp.put("id", obj.getLong("id"));
            temp.put("number", obj.getString("printtplid.number"));
            temp.put("name", PrintTemplateDataService.getName(obj, "printtplid.name"));
            temp.put("metaId", obj.getString("printtplid.id"));
            temp.put("isDefault", obj.get("isdefault"));
            result.add(temp);
        }
        return result;
    }

    public static Map<Long, DynamicObject> getUsageOrgById(List<Long> orgIds) {
        String fields = "org.id,org.number,org.name";
        QFilter filter = new QFilter("org.id", "in", orgIds);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org_structure", (String)fields, (QFilter[])new QFilter[]{filter});
        Iterator iterator = org.iterator();
        HashMap<Long, DynamicObject> dataMap = new HashMap<Long, DynamicObject>(org.size());
        while (iterator.hasNext()) {
            DynamicObject obj = (DynamicObject)iterator.next();
            dataMap.put(obj.getLong("org.id"), obj);
        }
        return dataMap;
    }

    public static DynamicObjectCollection getAllUserPermOrg() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getUserHasPermOrgs((long)userId);
        return PrintTemplateDataService.getHasPermDynamicObjects(result);
    }

    private static HasPermOrgResult getAllUserPermOrg(String appId, String formId, String permItem) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult result = null;
        result = StringUtils.isBlank((CharSequence)appId) || BizAppServiceHelp.isAllUserApp((String)appId) ? PermissionServiceHelper.getUserHasPermOrgs((long)userId) : PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)appId, (String)formId, (String)permItem);
        return result;
    }

    private static DynamicObjectCollection getHasPermDynamicObjects(HasPermOrgResult result) {
        if (result != null) {
            List orgIds = result.hasAllOrgPerm() ? OrgUnitServiceHelper.getAllOrg((String)"15") : result.getHasPermOrgs();
            OrgTreeParam param = new OrgTreeParam();
            param.setOrgRangeList(orgIds);
            QFilter idsFilter = new QFilter("id", "in", (Object)orgIds);
            QFilter[] filters = new QFilter[]{idsFilter};
            return QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters, (String)"id");
        }
        return new DynamicObjectCollection();
    }

    public static Tuple<Set<String>, Map<Long, DynamicObject>> getTemplateDataCtrlStrategyById(List<Long> ids, String entityNumber) {
        HashSet<Long> dataIds = new HashSet<Long>(ids);
        Map<Long, DynamicObject> data = PrintTemplateDataService.getPrintTemplateDataById(dataIds);
        if (!data.isEmpty()) {
            HashSet<String> ctrlStrategy = new HashSet<String>(10);
            for (Map.Entry<Long, DynamicObject> entry : data.entrySet()) {
                DynamicObject obj = entry.getValue();
                String strategy = obj.getString("ctrlstrategy");
                if (StringUtils.isNotBlank((CharSequence)strategy)) {
                    ctrlStrategy.add(strategy);
                    continue;
                }
                ctrlStrategy.add(CtrlStrategy.GLOBAL.getValue());
            }
            return new Tuple(ctrlStrategy, data);
        }
        return new Tuple(Collections.emptySet(), Collections.emptyMap());
    }

    public static Map<Long, Map<String, Object>> getAllocateDataByDataId(List<Long> ids) {
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid,fuseorgid,fcreateorgid,fisassign from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fdataid", new ArrayList<Long>(ids));
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> data = new HashMap<String, Object>(4);
                Long dataId = row.getLong("fdataid");
                data.put("dataId", dataId);
                data.put("useOrgId", row.getLong("fuseorgid"));
                data.put("createOrgId", row.getLong("fcreateorgid"));
                data.put("isAssign", row.getString("fisassign"));
                result.put(dataId, data);
            }
            HashMap<Long, Map<String, Object>> hashMap = result;
            return hashMap;
        }
    }

    public static List<Long> getAllocateDataIdByDataId(List<Long> ids) {
        SqlParameter pkValueParameter = new SqlParameter("fisassign", 12, (Object)"1");
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fdataid", new ArrayList<Long>(ids));
        useRegQuery.append("  and  fisassign=? ", new Object[]{pkValueParameter});
        useRegQuery.append("group  by fdataid ", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            ArrayList<Long> result = new ArrayList<Long>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long dataId = row.getLong("fdataid");
                result.add(dataId);
            }
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public static void batchUpdateCtrlStrategy(List<Long> dataIds, String newStrategy) {
        SqlParameter parameter = new SqlParameter("fctrlstrategy", 12, (Object)newStrategy);
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append("update t_bas_printtplinfo set fctrlstrategy =?", new Object[]{parameter});
        updateSql.append(" where ", new Object[0]);
        updateSql.appendIn("fid", new ArrayList<Long>(dataIds));
        DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)updateSql);
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_bas_printtplinfo");
        cacheManager.removeByPrimaryKey(dataIds.toArray());
    }

    public static void batchUpdateCreateOrg(List<Long> dataIds, Long createOrg) {
        SqlParameter parameter = new SqlParameter("fcreateorg", -5, (Object)createOrg);
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append("update t_bas_printtplinfo set fcreateorg =?", new Object[]{parameter});
        updateSql.append(" where ", new Object[0]);
        updateSql.appendIn("fid", new ArrayList<Long>(dataIds));
        DB.update((DBRoute)DBRoute.basedata, (SqlBuilder)updateSql);
    }

    public static List<Map<String, Object>> getAllocateDataByOrgCreate() {
        Long loginOrgId = RequestContext.get().getOrgId();
        String selectSql = " select fdataid,fuseorgid,fcreateorgid from t_bas_printtplinfousage where fuseorgid= ? and fisassign= ? and  fuseorgid=fcreateorgid";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
        params.add(new SqlParameter("fuseorgid", -5, (Object)loginOrgId));
        params.add(new SqlParameter("fisassign", 12, (Object)"0"));
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (String)selectSql, (Object[])params.toArray(new SqlParameter[0]));){
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Long> data = new HashMap<String, Long>(4);
                data.put("dataId", row.getLong("fdataid"));
                data.put("useOrgId", row.getLong("fuseorgid"));
                data.put("createOrgId", row.getLong("fcreateorgid"));
                result.add(data);
            }
            ArrayList<Map<String, Object>> arrayList = result;
            return arrayList;
        }
    }

    public static List<Map<String, Object>> getAllAllocateDataByUseOrg(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Collections.emptyList();
        }
        SqlBuilder useRegQuery = new SqlBuilder();
        useRegQuery.append(" select fdataid,fuseorgid,fcreateorgid from ", new Object[0]);
        useRegQuery.append("t_bas_printtplinfousage", new Object[0]);
        useRegQuery.append("  where ", new Object[0]);
        useRegQuery.appendIn("fuseorgid", new ArrayList<Long>(orgIds));
        try (DataSet dataSet = DB.queryDataSet((String)PrintTemplateDataService.class.getName(), (DBRoute)DBRoute.basedata, (SqlBuilder)useRegQuery);){
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Long> data = new HashMap<String, Long>(4);
                data.put("dataId", row.getLong("fdataid"));
                data.put("useOrgId", row.getLong("fuseorgid"));
                data.put("createOrgId", row.getLong("fcreateorgid"));
                result.add(data);
            }
            ArrayList<Map<String, Object>> arrayList = result;
            return arrayList;
        }
    }

    private static List<Map<String, Object>> getUserPermPrintTemplate(String billFormId, String appId, boolean excludeNew) {
        return PrintTemplateDataService.getUserPermPrintTemplate(billFormId, appId, excludeNew, false);
    }

    private static List<Map<String, Object>> getUserPermPrintTemplate(String billFormId, String appId, boolean excludeNew, boolean includeBizType) {
        QFilter[] qFilterArray;
        String realBillFormId = PrintServiceHelper.getRealBillFormId(billFormId);
        QFilter billFilter = new QFilter("billformid", "=", (Object)realBillFormId);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        String selectFields = "id,isdefault,createorg.name,createorg.id,ctrlstrategy,printtplid.number,printtplid.name,printtplid.id,type";
        boolean isNetTeant = ConfigConstUtil.isNewTenantOfVersion((int)7);
        QFilter[] qFilters = isNetTeant ? new QFilter[]{billFilter, statusFilter, new QFilter("type", "!=", (Object)"A")} : new QFilter[]{billFilter, statusFilter};
        DynamicObject[] dataArray = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)selectFields, (QFilter[])qFilters);
        if (dataArray == null || dataArray.length == 0) {
            return new ArrayList<Map<String, Object>>(0);
        }
        Object[] tplIds = Arrays.stream(dataArray).map(DataEntityBase::getPkValue).toArray();
        List blueToothTplIds = null;
        if (includeBizType) {
            Object[] printTplId = Arrays.stream(dataArray).map(m -> m.get("printtplid.id")).filter(Objects::nonNull).toArray();
            DynamicObject[] filterData = BusinessDataServiceHelper.load((String)"bos_print_meta", (String)"id", (QFilter[])new QFilter[]{new QFilter("biztype", "=", (Object)"1"), new QFilter("id", "in", (Object)printTplId)});
            Object[] finalPrintTplId = printTplId = Arrays.stream(filterData).map(DataEntityBase::getPkValue).toArray();
            blueToothTplIds = Arrays.stream(dataArray).filter(f -> ArrayUtils.contains((Object[])finalPrintTplId, (Object)f.get("printtplid.id"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        HasPermOrgResult hasPermOrgResult = PrintTemplateDataService.getAllUserPermOrg(appId, realBillFormId, "4730fc9e000000ac");
        List orgIds = hasPermOrgResult.getHasPermOrgs();
        HashSet<Long> hasPermTplIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("fdataid", "in", (Object)tplIds);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            qFilter.and(new QFilter("fuseorgid", "in", (Object)orgIds));
        }
        if (hasPermOrgResult.hasAllOrgPerm() || !CollectionUtils.isEmpty((Collection)orgIds)) {
            DynamicObjectCollection useInfos = ORM.create().query("bos_svc_printtplinfousage", "id, fdataid,fuseorgid,fcreateorgid", new QFilter[]{qFilter});
            for (DynamicObject useInfo : useInfos) {
                hasPermTplIds.add(useInfo.getLong("fdataid"));
            }
        }
        QFilter billFilter1 = new QFilter("billformid", "=", (Object)realBillFormId);
        QFilter ctrlFilter1 = new QFilter("ctrlstrategy", "=", (Object)CtrlStrategy.GLOBAL.getValue());
        QFilter statusFilter1 = new QFilter("enable", "=", (Object)"1");
        if (isNetTeant) {
            QFilter[] qFilterArray2 = new QFilter[4];
            qFilterArray2[0] = ctrlFilter1;
            qFilterArray2[1] = billFilter1;
            qFilterArray2[2] = statusFilter1;
            qFilterArray = qFilterArray2;
            qFilterArray2[3] = new QFilter("type", "!=", (Object)"A");
        } else {
            QFilter[] qFilterArray3 = new QFilter[3];
            qFilterArray3[0] = ctrlFilter1;
            qFilterArray3[1] = billFilter1;
            qFilterArray = qFilterArray3;
            qFilterArray3[2] = statusFilter1;
        }
        DynamicObject[] globalTplArray = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"id", (QFilter[])qFilterArray);
        if (globalTplArray != null && globalTplArray.length != 0) {
            Object[] pkIds;
            for (Object object : pkIds = Arrays.stream(globalTplArray).map(DataEntityBase::getPkValue).toArray()) {
                if (!(object instanceof Long)) continue;
                hasPermTplIds.add((Long)object);
            }
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataArray.length);
        for (DynamicObject dynamicObject : dataArray) {
            if (!hasPermTplIds.contains(Long.parseLong(String.valueOf(dynamicObject.getPkValue())))) continue;
            HashMap<String, Object> temp = new HashMap<String, Object>(16);
            if ("B".equals(dynamicObject.getString("type")) && excludeNew) continue;
            temp.put("id", dynamicObject.getLong("id"));
            temp.put("number", dynamicObject.getString("printtplid.number"));
            temp.put("name", PrintTemplateDataService.getName(dynamicObject, "printtplid.name"));
            temp.put("metaId", dynamicObject.getString("printtplid.id"));
            temp.put("isDefault", dynamicObject.get("isdefault"));
            temp.put("type", dynamicObject.getString("type"));
            if (includeBizType) {
                temp.put("bizType", blueToothTplIds.contains(dynamicObject.getLong("id")) ? "1" : "0");
            }
            result.add(temp);
        }
        return result;
    }

    public static List<Map<String, Object>> getUserPermAllPrintTemplate(String billFormId) {
        return PrintTemplateDataService.getUserPermAllPrintTemplate(billFormId, null);
    }

    public static List<Map<String, Object>> getUserPermAllPrintTemplate(String billFormId, String appId) {
        return PrintTemplateDataService.getUserPermPrintTemplate(billFormId, appId, false);
    }

    public static List<Map<String, Object>> getUserPermAllPrintTemplate(String billFormId, String appId, boolean includeBizType) {
        return PrintTemplateDataService.getUserPermPrintTemplate(billFormId, appId, false, includeBizType);
    }

    public static List<Map<String, Object>> getUserPermOldPrintTemplate(String billFormId) {
        return PrintTemplateDataService.getUserPermPrintTemplate(billFormId, null, true);
    }

    public static List<Map<String, Object>> getUserPermOldPrintTemplate(String billFormId, String appId) {
        return PrintTemplateDataService.getUserPermPrintTemplate(billFormId, appId, true);
    }

    public static List<Map<String, Object>> getPrintTemplateDataList(List<Long> ids) {
        QFilter tplIdFilter = new QFilter("id", "in", ids);
        String selectFields = "id,isdefault,createorg.name,createorg.id,ctrlstrategy,printtplid.number,printtplid.name,printtplid.id";
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bas_manageprinttpl", (String)selectFields, (QFilter[])new QFilter[]{tplIdFilter});
        ArrayList<String> tplIds = new ArrayList<String>(10);
        HashMap<String, DynamicObject> rawData = new HashMap<String, DynamicObject>(16);
        if (data != null && data.length > 0) {
            for (DynamicObject obj : data) {
                String tplId = obj.getString("printtplid.id");
                tplIds.add(tplId);
                rawData.put(tplId, obj);
            }
        }
        if (!CollectionUtils.isEmpty(tplIds)) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
            QFilter idFilter = new QFilter("id", "in", tplIds);
            DynamicObjectCollection metas = OldPrintTemplateUtil.query((String)"id,isv", (QFilter[])new QFilter[]{idFilter});
            if (!CollectionUtils.isEmpty((Collection)metas)) {
                for (DynamicObject meta : metas) {
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    temp.put("id", meta.getString("id"));
                    temp.put("isv", meta.get("isv"));
                    DynamicObject obj = (DynamicObject)rawData.get(meta.getString("id"));
                    temp.put("name", PrintTemplateDataService.getName(obj, "printtplid.name"));
                    temp.put("number", obj.getString("printtplid.number"));
                    result.add(temp);
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static List<Map<String, Object>> getPrintTemplateDataList(List<Long> ids, boolean isNew) {
        if (!isNew) {
            return PrintTemplateDataService.getPrintTemplateDataList(ids);
        }
        QFilter tplIdFilter = new QFilter("id", "in", ids);
        String selectFields = "id,isdefault,createorg.name,createorg.id,ctrlstrategy,printtplid.number,printtplid.name,printtplid.id";
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)selectFields, (QFilter[])new QFilter[]{tplIdFilter});
        ArrayList<String> tplIds = new ArrayList<String>(10);
        HashMap<String, DynamicObject> rawData = new HashMap<String, DynamicObject>(16);
        if (data != null && data.length > 0) {
            for (DynamicObject obj : data) {
                String tplId = obj.getString("printtplid.id");
                tplIds.add(tplId);
                rawData.put(tplId, obj);
            }
        }
        if (!CollectionUtils.isEmpty(tplIds)) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
            QFilter idFilter = new QFilter("id", "in", tplIds);
            DynamicObjectCollection metas = QueryServiceHelper.query((String)"bos_print_meta", (String)"id,tpltype", (QFilter[])new QFilter[]{idFilter});
            if (!CollectionUtils.isEmpty((Collection)metas)) {
                for (DynamicObject meta : metas) {
                    HashMap<String, String> temp = new HashMap<String, String>(16);
                    temp.put("id", meta.getString("id"));
                    if ("1".equals(meta.get("tpltype"))) {
                        temp.put("isv", "kingdee");
                    } else {
                        temp.put("isv", "unkonwn");
                    }
                    DynamicObject obj = (DynamicObject)rawData.get(meta.getString("id"));
                    temp.put("name", PrintTemplateDataService.getName(obj, "printtplid.name"));
                    temp.put("number", obj.getString("printtplid.number"));
                    result.add(temp);
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    public static List<Map<String, Object>> getNewPrintTemplateByBillId(String billFormId) {
        List<Map<String, Object>> newTpl;
        DynamicObjectCollection data;
        HashSet<Long> dataIds = new HashSet<Long>(10);
        if (ParamUtils.isTemplateOrgIsolated()) {
            HashSet<Long> orgIds = new HashSet<Long>(10);
            DynamicObjectCollection org = PrintTemplateDataService.getAllUserPermOrg();
            for (Object obj : org) {
                Long l = obj.getLong("id");
                orgIds.add(l);
            }
            List<Map<String, Object>> allocateData = PrintTemplateDataService.getAllAllocateDataByUseOrg(new ArrayList<Long>(orgIds));
            if (!CollectionUtils.isEmpty(allocateData)) {
                for (Map map : allocateData) {
                    dataIds.add(Long.parseLong(map.get("dataId").toString()));
                }
            }
        }
        QFilter billFilter = new QFilter("billformid", "=", (Object)PrintServiceHelper.getRealBillFormId(billFormId));
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("type", "=", (Object)"B");
        if (ParamUtils.isTemplateOrgIsolated()) {
            QFilter qFilter = new QFilter("ctrlstrategy", "=", (Object)CtrlStrategy.GLOBAL.getValue());
            data = QueryServiceHelper.query((String)"bas_manageprinttpl", (String)"id", (QFilter[])new QFilter[]{qFilter, billFilter, statusFilter, typeFilter});
        } else {
            data = QueryServiceHelper.query((String)"bas_manageprinttpl", (String)"id", (QFilter[])new QFilter[]{billFilter, statusFilter, typeFilter});
        }
        if (!CollectionUtils.isEmpty((Collection)data)) {
            for (DynamicObject obj : data) {
                dataIds.add(obj.getLong("id"));
            }
        }
        QFilter qFilter = new QFilter("id", "in", dataIds);
        DynamicObjectCollection dataNew = QueryServiceHelper.query((String)"bas_manageprinttpl", (String)"id,type", (QFilter[])new QFilter[]{qFilter, billFilter, statusFilter, typeFilter});
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(dataNew.size());
        ArrayList<Long> newIds = new ArrayList<Long>(10);
        for (DynamicObject obj : dataNew) {
            if (!"B".equals(obj.getString("type"))) continue;
            newIds.add(obj.getLong("id"));
        }
        if (!CollectionUtils.isEmpty(newIds) && !CollectionUtils.isEmpty(newTpl = PrintTemplateDataService.getNewPrintTemplateByIdAndBillId(newIds, billFormId))) {
            result.addAll(newTpl);
        }
        return result;
    }

    public static void removeUsage(List<Long> ids, Long orgId, String assignFlag) {
        SqlParameter orgParameter = new SqlParameter("fuseorgid", -5, (Object)orgId);
        SqlParameter assignParameter = new SqlParameter("fisassign", 12, (Object)assignFlag);
        SqlBuilder sql = new SqlBuilder();
        sql.append(" delete from ", new Object[0]);
        sql.append("t_bas_printtplinfousage", new Object[0]);
        sql.append("  where ", new Object[0]);
        sql.appendIn("fdataid", new ArrayList<Long>(ids));
        sql.append(" and  fisassign=?", new Object[]{assignParameter});
        sql.append(" and fuseorgid=?", new Object[]{orgParameter});
        DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sql);
    }

    public static String getName(DynamicObject obj, String key) {
        ILocaleString localeString;
        String name = obj.getString(key);
        if (StringUtils.isBlank((CharSequence)name) && (localeString = obj.getLocaleString(key)) != null && StringUtils.isBlank((CharSequence)(name = localeString.getLocaleValue())) && StringUtils.isBlank((CharSequence)(name = (String)localeString.get((Object)"GLang")))) {
            name = localeString.getLocaleValue_zh_CN();
        }
        return name;
    }
}

