/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.template.orgctrl.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.utils.ConfigConstUtil;
import kd.bos.print.business.utils.OldPrintTemplateUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.template.orgctrl.model.PrintTemplateInfo;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.IPrintTemplateService;
import kd.bos.template.orgctrl.service.PrintTemplateDataService;
import kd.bos.template.orgctrl.utils.ParamUtils;

public class PrintTemplateServiceImpl
implements IPrintTemplateService {
    private static Log logger = LogFactory.getLog(PrintTemplateServiceImpl.class);

    @Override
    public List<Map<String, String>> getUserPermPrintTemplates(String billFormId) {
        List<Map<String, Object>> templates = PrintTemplateDataService.getUserPermOldPrintTemplate(billFormId);
        if (!CollectionUtils.isEmpty(templates)) {
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(templates.size());
            for (Map<String, Object> template : templates) {
                HashMap<String, String> temp = new HashMap<String, String>(4);
                temp.put("tempalteName", template.get("name") != null ? template.get("name").toString() : "");
                temp.put("templateNumber", template.get("metaId") != null ? template.get("metaId").toString() : "");
                temp.put("templateId", template.get("metaId") != null ? template.get("metaId").toString() : "");
                temp.put("templateNo", template.get("number") != null ? template.get("number").toString() : "");
                results.add(temp);
            }
            return results;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getUserPermPrintTemplateList(String billFormId) {
        return PrintTemplateDataService.getUserPermAllPrintTemplate(billFormId);
    }

    @Override
    public Map<String, String> getUserPermPrintTemplateMap(String billFormId) {
        return this.getUserPermPrintTemplateMap(billFormId, null);
    }

    private List<TemplateInfo> getUserPerPrintTemplateList(String billFormId, String appId) {
        List<Map<String, Object>> templates = PrintTemplateDataService.getUserPermAllPrintTemplate(billFormId, appId);
        if (CollectionUtils.isEmpty(templates)) {
            return Collections.emptyList();
        }
        ArrayList<TemplateInfo> tplList = new ArrayList<TemplateInfo>(templates.size());
        for (Map<String, Object> template : templates) {
            if (template.get("metaId") == null) continue;
            TemplateInfo info = new TemplateInfo();
            info.setId(String.valueOf(template.get("metaId")));
            info.setName(template.get("name") != null ? String.valueOf(template.get("name")) : "");
            info.setType(template.get("type") != null ? String.valueOf(template.get("type")) : "");
            tplList.add(info);
        }
        return tplList;
    }

    private List<TemplateInfo> getUserPerPrintTemplateList(String billFormId, String appId, boolean includeBizType) {
        List<Map<String, Object>> templates = PrintTemplateDataService.getUserPermAllPrintTemplate(billFormId, appId, includeBizType);
        if (CollectionUtils.isEmpty(templates)) {
            return Collections.emptyList();
        }
        ArrayList<TemplateInfo> tplList = new ArrayList<TemplateInfo>(templates.size());
        for (Map<String, Object> template : templates) {
            if (template.get("metaId") == null) continue;
            TemplateInfo info = new TemplateInfo();
            info.setId(String.valueOf(template.get("metaId")));
            info.setName(template.get("name") != null ? String.valueOf(template.get("name")) : "");
            info.setType(template.get("type") != null ? String.valueOf(template.get("type")) : "");
            info.setBizType(template.get("bizType") != null ? String.valueOf(template.get("bizType")) : "0");
            tplList.add(info);
        }
        return tplList;
    }

    @Override
    public Map<String, String> getUserPermPrintTemplateMap(String billFormId, String appId) {
        List<TemplateInfo> templateList = this.getUserPerPrintTemplateList(billFormId, appId);
        if (CollectionUtils.isEmpty(templateList)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> results = new HashMap<String, String>(templateList.size());
        for (TemplateInfo template : templateList) {
            if (template.getId() == null) continue;
            results.put(template.getId(), template.getName() != null ? template.getName() : "");
        }
        return results;
    }

    @Override
    public Tuple<Map<String, String>, Map<String, String>> getUserPermPrintTemplateMap(String billFormId, String appId, boolean includeBizType) {
        List<TemplateInfo> templateList = this.getUserPerPrintTemplateList(billFormId, appId, includeBizType);
        if (CollectionUtils.isEmpty(templateList)) {
            return Tuple.create(Collections.emptyMap(), Collections.emptyMap());
        }
        HashMap<String, String> bizType0 = new HashMap<String, String>(10);
        HashMap<String, String> bizType1 = new HashMap<String, String>(10);
        for (TemplateInfo template : templateList) {
            if (template.getId() == null) continue;
            if ("1".equals(template.getBizType())) {
                bizType1.put(template.getId(), template.getName() != null ? template.getName() : "");
                continue;
            }
            bizType0.put(template.getId(), template.getName() != null ? template.getName() : "");
        }
        return Tuple.create(bizType0, bizType1);
    }

    @Override
    public Map<String, String> getUserPermOldPrintTemplateMap(String billFormId) {
        return this.getUserPermOldPrintTemplateMap(billFormId, null);
    }

    @Override
    public Map<String, String> getUserPermOldPrintTemplateMap(String billFormId, String appId) {
        List<Map<String, Object>> templates = PrintTemplateDataService.getUserPermOldPrintTemplate(billFormId, appId);
        if (!CollectionUtils.isEmpty(templates)) {
            HashMap<String, String> results = new HashMap<String, String>(templates.size());
            for (Map<String, Object> template : templates) {
                if (template.get("metaId") == null) continue;
                results.put(template.get("metaId").toString(), template.get("name") != null ? template.get("name").toString() : "");
            }
            return results;
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, Object>> getUserPermNewPrintTemplates(String billFormId) {
        return PrintTemplateDataService.getNewPrintTemplateByBillId(billFormId);
    }

    @Override
    public Map<String, String> getUserPermNewPrintTemplateMap(String billFormId) {
        List<Map<String, Object>> templates = PrintTemplateDataService.getNewPrintTemplateByBillId(billFormId);
        if (!CollectionUtils.isEmpty(templates)) {
            HashMap<String, String> results = new HashMap<String, String>(templates.size());
            for (Map<String, Object> template : templates) {
                if (template.get("metaId") == null) continue;
                results.put(template.get("metaId").toString(), template.get("name") != null ? template.get("name").toString() : "");
            }
            return results;
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean checkUserHaveTemplate(String billFormId, String templateId) {
        Map<String, String> permTemplate = this.getUserPermPrintTemplateMap(billFormId);
        return !permTemplate.isEmpty() && permTemplate.containsKey(templateId);
    }

    @Override
    public PrintTemplateInfo getPrintTemplate(Long userId, String formId) {
        List<TemplateInfo> templates;
        Map jsonData;
        if (null == userId || null == formId) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237Id\u548c\u8868\u5355Id\u3002", (String)"PrintTplServiceInterface_0", (String)"bos-noteprint", (Object[])new Object[0]));
        }
        PrintTemplateInfo pTpl = new PrintTemplateInfo();
        pTpl.setFormId(formId);
        String key = formId + "_printsetting";
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)key);
        if (StringUtils.isNotBlank((CharSequence)settingData) && !CollectionUtils.isEmpty((Map)(jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class)))) {
            Object templateid;
            Object printerid;
            Object printlang = jsonData.get("printlang");
            if (null != printlang) {
                pTpl.setPrintLang(String.valueOf(printlang));
            }
            if (null != (printerid = jsonData.get("printerid"))) {
                pTpl.setPrinterId(Long.valueOf(printerid.toString()));
            }
            if (null != (templateid = jsonData.get("templateid"))) {
                pTpl.setUserSettingTplId(String.valueOf(templateid));
            }
        }
        List<TemplateInfo> list = templates = ParamUtils.isTemplateOrgIsolated() ? this.getUserPerPrintTemplateList(formId, null) : this.getTemplates(formId, true);
        if (!CollectionUtils.isEmpty(templates)) {
            pTpl.setTplList(templates);
        }
        return pTpl;
    }

    @Override
    public List<TemplateInfo> getTemplates(String formId, Boolean includeNew) {
        return this.getTemplates(formId, includeNew, false);
    }

    @Override
    public List<TemplateInfo> getTemplates(String formId, Boolean includeNew, boolean includeBizType) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form);
        FormMetadata fm = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        String oriFormId = MetadataDao.getNumberById((String)fm.getEntityId());
        ArrayList<TemplateInfo> tplList = new ArrayList<TemplateInfo>(10);
        QFilter[] qFilters = ConfigConstUtil.isNewTenantOfVersion((int)7) ? new QFilter[]{new QFilter("billformid", "=", (Object)oriFormId), new QFilter("type", "!=", (Object)"A")} : new QFilter[]{new QFilter("billformid", "=", (Object)oriFormId)};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"number, name, enable,type,printtplid", (QFilter[])qFilters);
        List blueToothTplIds = null;
        if (includeBizType) {
            Object[] printTplId = Arrays.stream(dynamicObjects).map(m -> m.get("printtplid.id")).filter(Objects::nonNull).toArray();
            DynamicObject[] filterData = BusinessDataServiceHelper.load((String)"bos_print_meta", (String)"id", (QFilter[])new QFilter[]{new QFilter("biztype", "=", (Object)"1"), new QFilter("id", "in", (Object)printTplId)});
            Object[] finalPrintTplId = printTplId = Arrays.stream(filterData).map(DataEntityBase::getPkValue).toArray();
            blueToothTplIds = Arrays.stream(dynamicObjects).filter(f -> ArrayUtils.contains((Object[])finalPrintTplId, (Object)f.get("printtplid_id"))).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        }
        ArrayList<Object> oldList = new ArrayList<Object>();
        for (DynamicObject obj : dynamicObjects) {
            ILocaleString localeString;
            DynamicObject printtpObj = obj.getDynamicObject("printtplid");
            Object tplId = obj.get("printtplid_id");
            String enable = obj.getString("enable");
            if ("0".equals(enable)) continue;
            if (printtpObj == null) {
                oldList.add(tplId);
                continue;
            }
            if (!"B".equals(printtpObj.get("type"))) {
                localeString = printtpObj.getLocaleString("name");
                if (null == localeString) {
                    oldList.add(tplId);
                    continue;
                }
                TemplateInfo tplInfo = new TemplateInfo();
                tplInfo.setId(String.valueOf(tplId));
                tplInfo.setName(localeString.getLocaleValue());
                tplInfo.setType("A");
                tplInfo.setBizType("0");
                tplList.add(tplInfo);
                continue;
            }
            localeString = printtpObj.getLocaleString("name");
            String name = localeString.getLocaleValue();
            if (StringUtils.isBlank((CharSequence)name) && StringUtils.isBlank((CharSequence)(name = (String)localeString.get((Object)"GLang")))) {
                name = localeString.getLocaleValue_zh_CN();
            }
            if (!includeNew.booleanValue()) continue;
            TemplateInfo tplInfo = new TemplateInfo();
            tplInfo.setId(String.valueOf(tplId));
            tplInfo.setType("B");
            tplInfo.setName(name);
            if (includeBizType) {
                tplInfo.setBizType(blueToothTplIds.contains(obj.getLong("id")) ? "1" : "0");
            }
            tplList.add(tplInfo);
        }
        if (oldList.isEmpty()) {
            return tplList;
        }
        QFilter qFilter = new QFilter("id", "in", oldList);
        Map formMetaMap = OldPrintTemplateUtil.loadFromCache((String)"id,number,bizappid,basedatafield,modifierid", (QFilter[])new QFilter[]{qFilter});
        for (Map.Entry entry : formMetaMap.entrySet()) {
            TemplateInfo tplInfo = new TemplateInfo();
            tplInfo.setId(String.valueOf(entry.getKey()));
            tplInfo.setName(((DynamicObject)entry.getValue()).getLocaleString("name").getLocaleValue());
            tplInfo.setType("A");
            tplInfo.setBizType("0");
            tplList.add(tplInfo);
        }
        return tplList;
    }
}

