/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CtrlPropertyConfig {
    private String url;
    private Properties properties;
    private static final Log log = LogFactory.getLog(CtrlPropertyConfig.class);

    public CtrlPropertyConfig(String url) {
        this.url = url;
        this.properties = this.loadProperties();
    }

    public void setPropertyFileLocation(String fileurl) {
        this.url = fileurl;
        this.properties = this.loadProperties();
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
        this.store();
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private void store() {
        File configFile = GlobalLocator.getInstance().locateResourceFile(this.url);
        if (configFile != null) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(configFile);){
                this.properties.store(fileOutputStream, "");
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private Properties loadProperties() {
        Properties proper = new Properties();
        proper.setProperty("Use_MediaSize_dll", "true");
        proper.setProperty("CustomArraycopy", "false");
        proper.setProperty("Use_OpenPrinter_dll", "true");
        return proper;
    }
}

