/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GlobalLocator {
    public static final Log logger = LogFactory.getLog(GlobalLocator.class);
    public static final char SPLIT_CHAR = '/';
    private static final GlobalLocator instance = new GlobalLocator();
    private final String CTRL_HOME = "ctrlhome";
    private final String USER_HOME = "user.home";
    private final String RESOURCE_HOME = "com/kingdee/bos/ctrl/ctrlhome";
    public static final String TEMP_DIR = "/temp";
    private String homeDir;

    public static GlobalLocator getInstance() {
        return instance;
    }

    private GlobalLocator() {
        this.makeHomeDir();
    }

    private void makeHomeDir() {
        this.homeDir = this.getSystemProperty("ctrlhome");
        if (this.homeDir == null) {
            URL url;
            ClassLoader clsLdr = this.getClass().getClassLoader();
            if (clsLdr == null) {
                clsLdr = ClassLoader.getSystemClassLoader();
            }
            if ((url = clsLdr.getResource("ctrlhome")) != null) {
                this.homeDir = url.getPath();
                logger.info("ctrlhome = {Class Path} : " + this.homeDir);
            }
            if (this.homeDir == null) {
                this.homeDir = this.getSystemProperty("user.home") + FileUtil.FILE_SEPARATOR + "ctrlhome";
            }
        } else {
            logger.info("ctrlhome = {CTRL_HOME} : " + this.homeDir);
        }
        int z = this.homeDir.length() - 1;
        char c = this.homeDir.charAt(z);
        if (c == File.separatorChar || c == '/') {
            this.homeDir = this.homeDir.substring(0, z);
        }
    }

    private String getSystemProperty(String key) {
        String value = System.getProperty(key);
        value = FileUtil.normalize(value);
        return value;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String makeFilePath(String pathText) {
        if (pathText == null || this.homeDir == null) {
            return null;
        }
        if (pathText.length() == 0) {
            return this.homeDir;
        }
        if (pathText.charAt(0) == '/') {
            if (File.separatorChar != '/') {
                pathText = pathText.replace('/', File.separatorChar);
            }
            return this.homeDir + pathText;
        }
        return pathText;
    }

    public String makeResourcePath(String pathText) {
        return "com/kingdee/bos/ctrl/ctrlhome" + pathText;
    }

    public File createResourceFile(String pathText) throws IOException {
        String resPath = this.makeResourcePath(pathText);
        URL resUrl = this.getClass().getClassLoader().getResource(resPath);
        if (resUrl == null) {
            logger.info("Cannot locate resource: " + resPath);
            return null;
        }
        String filePath = this.makeFilePath(pathText);
        File f = FileUtil.createFile(filePath);
        if (f == null) {
            return null;
        }
        try (InputStream res = resUrl.openStream();
             FileOutputStream fos = new FileOutputStream(f);){
            StreamUtil.copy(res, fos, 4096);
        }
        logger.info("File created successful : " + f.getCanonicalPath());
        return f;
    }

    public File createTempFile(String prefix, String suffix) {
        try {
            File temp = File.createTempFile(prefix, suffix, this.locateResourceFolder(TEMP_DIR));
            return temp;
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public File locateResourceFolder(String pathText) {
        String filePath = this.makeFilePath(pathText = FileUtil.normalize(pathText));
        File f = new File(filePath);
        if (!f.exists() && (f = FileUtil.createFolder(filePath)) == null) {
            return null;
        }
        if (f.isDirectory()) {
            return f;
        }
        return null;
    }

    public File locateResourceFile(String pathText) {
        File f = new File(this.makeFilePath(pathText));
        if (!f.exists()) {
            try {
                f = this.createResourceFile(pathText);
            }
            catch (Exception e) {
                return null;
            }
            if (f == null) {
                return null;
            }
        }
        if (f.isFile()) {
            return f;
        }
        return null;
    }

    public InputStream locateResourceFileStream(String pathText) {
        FileInputStream fis;
        File f = this.locateResourceFile(pathText);
        if (f == null) {
            return null;
        }
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            logger.error((Throwable)e);
            return null;
        }
        return fis;
    }
}

