/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class LanguageManager {
    private static final Log log = LogFactory.getLog(LanguageManager.class);

    public static String getLangMessage(String key, Class classInstance, String tempInfo) {
        return LanguageManager.getLangMessage(key, classInstance, Locale.getDefault(), tempInfo);
    }

    public static String getLangMessage(String key, String resPath, String tempInfo) {
        return LanguageManager.getLangMessage(key, resPath, Locale.getDefault(), tempInfo);
    }

    public static String getLangMessage(String key, String resPath, Locale locale, String tempInfo) {
        ResourceBundle bundle = null;
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = ResourceBundle.getBundle(resPath, locale);
        }
        catch (NullPointerException n1) {
            log.error(n1.getMessage());
        }
        catch (MissingResourceException m1) {
            log.error(m1.getMessage());
        }
        try {
            String keyInfo;
            if (bundle != null && (keyInfo = bundle.getString(key)) != null) {
                return keyInfo;
            }
        }
        catch (NullPointerException n2) {
            log.error(n2.getMessage());
        }
        catch (MissingResourceException m2) {
            log.error(m2.getMessage());
        }
        catch (ClassCastException cc) {
            log.error(cc.getMessage());
        }
        if (tempInfo != null) {
            return tempInfo;
        }
        throw new MissingResourceException("Do not find any mapping Language Info or Do not specified one temporary text.", null, key);
    }

    public static String getLangMessage(String key, Class classInstance, Locale locale, String tempInfo) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String resPath = LanguageManager.getBundlePath(classInstance);
        return LanguageManager.getLangMessage(key, resPath, locale, tempInfo);
    }

    public static String getBundlePath(Class cName) {
        if (cName != null) {
            return cName.getName();
        }
        return "";
    }

    public static final String getProperty(HashMap properties, String name) {
        return LanguageManager.getProperty(properties, name, Locale.getDefault());
    }

    public static final String getProperty(HashMap properties, String name, Locale locale) {
        if (locale == null) {
            return LanguageManager.getProperty(properties, name);
        }
        String key = (String)properties.get(name);
        if (key == null || "#1".equals(key)) {
            StringBuilder sb = new StringBuilder();
            sb.append(name);
            sb.append('.');
            sb.append(locale);
            key = (String)properties.get(sb.toString());
        }
        return key == null ? (String)properties.get(name) : key;
    }
}

