/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.currency;

import com.kingdee.bos.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatHKD
implements ICurrencyUpperFunction {
    private Format formatField;

    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        String result = null;
        if (locale == Locale.ENGLISH) {
            this.formatField = Formats.getFormat("[ENG-HKD]g/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            this.formatField = Formats.getFormat("[Rmb]G/\u901a\u7528\u683c\u5f0f;[Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            this.formatField = Formats.getFormat("[CHT-Rmb]G/\u901a\u7528\u683c\u5f0f;[CHT-Rmb](\u8d1f\u6570)G/\u901a\u7528\u683c\u5f0f");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = this.formatField.format4Print(variant).toString();
        if (isAddPrefix) {
            if (locale == Locale.ENGLISH) {
                return result;
            }
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = "\u6e2f\u5143" + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = "\u6e2f\u5143" + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

