/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle;

import com.kingdee.bos.ctrl.common.digitalstyle.DigitDecorateCondition;
import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.digitalstyle.LanguageCondition;
import com.kingdee.bos.ctrl.common.digitalstyle.SimpleFormat;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import java.math.BigDecimal;
import java.util.Calendar;

class DigitDecorateFormat
extends SimpleFormat {
    DigitDecorateCondition _nc;
    LanguageCondition _lc;
    private SimpleFormat _format;

    DigitDecorateFormat(SimpleFormat format) {
        this._format = format;
    }

    void setNumberCondition(DigitDecorateCondition nc) {
        this._nc = nc;
    }

    void setLanguageCondition(LanguageCondition lc) {
        this._lc = lc;
    }

    SimpleFormat getActualFormat() {
        return this._format;
    }

    private boolean inCondition(Variant obj, boolean parse) {
        if (null == obj) {
            return false;
        }
        try {
            BigDecimal bd = null;
            if (parse || obj.isNumber() || obj.isDate()) {
                bd = obj.toBigDecimal();
            }
            if (bd == null) {
                return false;
            }
            if (this._nc == null) {
                return true;
            }
            return this._nc.inCondition(bd);
        }
        catch (SyntaxErrorException e) {
            try {
                Calendar cal = null;
                if (parse) {
                    cal = obj.toCalendar();
                }
                if (cal == null) {
                    return false;
                }
                if (this._nc == null) {
                    return true;
                }
                return this._nc.inCondition(new Variant(cal).toBigDecimal());
            }
            catch (SyntaxErrorException e2) {
                return false;
            }
        }
    }

    @Override
    public FormatResult format(Variant obj, boolean parse) {
        FormatResult result = FormatResult.NullResult;
        if (this._format != null && (!this._format.isDigitCondition() || this.inCondition(obj, parse))) {
            result = this._format.format(obj, parse);
            if (this._lc != null) {
                result.setText(this._lc.translate2(result.getText()));
            }
        }
        return result;
    }

    @Override
    public boolean formatStyle(Variant var, StyleAttributes retSa, boolean parse) {
        if (this._format != null && (!this._format.isDigitCondition() || this.inCondition(var, parse))) {
            this._format.formatStyle(var, retSa, parse);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toStringFormat();
    }

    @Override
    public String toStringFormat() {
        StringBuilder sb = new StringBuilder();
        if (this._lc != null) {
            sb.append(this._lc);
        }
        if (this._nc != null) {
            sb.append(this._nc);
        }
        sb.append(this.getActualFormat());
        return sb.toString();
    }

    @Override
    public FormatResult format4Print(Variant obj, boolean parse) {
        FormatResult result = new FormatResult(null);
        if (this._format != null && (!this._format.isDigitCondition() || this.inCondition(obj, parse))) {
            if (this._lc == null) {
                result = this._format.format(obj, parse);
            } else {
                result.setText(this._lc.translate2(obj.toString()));
            }
        }
        return result;
    }
}

