/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle;

import com.kingdee.bos.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import java.util.Calendar;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class Format {
    private static final Log log = LogFactory.getLog(Format.class);
    static final int TYPE_CONSTANT = -1;
    static final int TYPE_NUMBER = 1;
    static final int TYPE_DATETIME = 2;
    static final int TYPE_TEXT = 3;
    static final int TYPE_GENERAL = 4;
    static final int TYPE_FRACTION = 5;
    static final int TYPE_SCIENCE = 6;

    public static Variant parseData(String data, boolean parseDate) {
        Variant var = new Variant(data, 11);
        String trimedData = data.trim();
        try {
            if (trimedData.length() != 0) {
                var = Variant.getBufferedDecimal(trimedData);
            }
            return var;
        }
        catch (SyntaxErrorException e) {
            log.error((Throwable)e);
            try {
                var.setObject(Util.stringToBoolean(trimedData), 8);
                return var;
            }
            catch (SyntaxErrorException e2) {
                log.error((Throwable)e2);
                if (parseDate) {
                    try {
                        Calendar cal = Variant.getBufferedCalendar(trimedData);
                        var = new Variant(cal, 13);
                    }
                    catch (SyntaxErrorException e3) {
                        log.error((Throwable)e3);
                    }
                }
                return var;
            }
        }
    }

    public boolean formatStyle(Variant obj, StyleAttributes retSa) {
        return this.formatStyle(obj, retSa, true);
    }

    public FormatResult format(Variant obj) {
        return this.format(obj, true);
    }

    public FormatResult format4Print(Variant obj) {
        return this.format4Print(obj, true);
    }

    public abstract boolean formatStyle(Variant var1, StyleAttributes var2, boolean var3);

    public abstract FormatResult format(Variant var1, boolean var2);

    public abstract FormatResult format4Print(Variant var1, boolean var2);

    public abstract String toStringFormat();
}

