/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle;

import com.kingdee.bos.ctrl.common.digitalstyle.NumMultiLanFormat;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.kdf.formatter.NumberTranslate;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseNumberResource;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class LanguageCondition {
    private static final Log log = LogFactory.getLog(LanguageCondition.class);
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private static final String LANGUAGE_CONDITION_3 = "LanguageCondition_3";
    private static final String LANGUAGE_CONDITION_4 = "LanguageCondition_4";
    private static final String S_CHINESE_LOWERCASE = "DBNum1";
    private static final String S_CHINESE_UPCASE = "DBNum2";
    private static final String S_CHINESE_LOWERCASE2 = "DBNum4";
    private static final String S_CHINESE_UPCASE2 = "DBNum5";
    private static final String S_CHINESE_LOWERCASE3 = "DBNum7";
    private static final String S_CHINESE_UPCASE3 = "DBNum8";
    private static final String[] MultiLanguages = new String[]{"ENG", "CHS", "CHT"};
    private static HashSet multiLangSet = new HashSet();
    private static final String RMB = "Rmb";
    private static final String DOLLAR = "Dollar";
    private static NumberTranslate _prcNumber = new NumberTranslate(PRCChineseNumberResource.getInstance());
    private static NumberTranslate _prcBigNumber = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
    private static NumMultiLanFormat _multiLanFormatter = new NumMultiLanFormat();
    private String _lanType;

    static boolean isLanguageCondition(String condition) {
        if (condition == null) {
            return false;
        }
        int i = condition.indexOf(45);
        return S_CHINESE_LOWERCASE.equalsIgnoreCase(condition) || S_CHINESE_UPCASE.equalsIgnoreCase(condition) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(condition) || S_CHINESE_UPCASE2.equalsIgnoreCase(condition) || S_CHINESE_LOWERCASE3.equalsIgnoreCase(condition) || S_CHINESE_UPCASE3.equalsIgnoreCase(condition) || RMB.equalsIgnoreCase(condition) || DOLLAR.equalsIgnoreCase(condition) || multiLangSet.contains(condition.toUpperCase()) || i != -1 && i + 1 < condition.length() && multiLangSet.contains(condition.substring(0, i).toUpperCase());
    }

    public LanguageCondition(String condition) throws IllegalArgumentException {
        if (!this.applyCondition(condition)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u521b\u5efa\u8bed\u8a00\u6761\u4ef6\uff1a ", (String)"LanguageCondition_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]), condition));
        }
    }

    private boolean applyCondition(String condition) {
        if (LanguageCondition.isLanguageCondition(condition)) {
            this._lanType = condition;
            return true;
        }
        return false;
    }

    public String getLanguageType() {
        return this._lanType;
    }

    public String translate3(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf(45);
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.getBufferedDecimal(resource), this._lanType);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.getBufferedDecimal(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else {
            resource = RMB.equalsIgnoreCase(this._lanType) ? this.transRmb(resource) : (DOLLAR.equalsIgnoreCase(this._lanType) ? this.transDollar(resource) : (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE3.equalsIgnoreCase(this._lanType) ? _prcNumber.toDirect(resource) : _prcBigNumber.toDirect(resource)));
        }
        return resource;
    }

    public String translate2(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf(45);
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.getBufferedDecimal(resource), this._lanType);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.getBufferedDecimal(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else {
            resource = RMB.equalsIgnoreCase(this._lanType) ? this.transRmb(resource) : (DOLLAR.equalsIgnoreCase(this._lanType) ? this.transDollar(resource) : (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType) ? _prcNumber.toNumber(resource) : (S_CHINESE_UPCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_UPCASE2.equalsIgnoreCase(this._lanType) ? _prcBigNumber.toNumber(resource) : (S_CHINESE_LOWERCASE3.equalsIgnoreCase(this._lanType) ? _prcNumber.toDirect(resource) : (S_CHINESE_UPCASE3.equalsIgnoreCase(this._lanType) ? _prcBigNumber.toDirect(resource) : _prcBigNumber.toDirect(resource))))));
        }
        return resource;
    }

    public String translate(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf(45);
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.getBufferedDecimal(resource), this._lanType);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.getBufferedDecimal(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException e) {
                log.error((Throwable)e);
            }
        } else if (S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType)) {
            _prcNumber.setLangHabit(true);
            resource = _prcNumber.toNumber(resource);
            _prcNumber.setLangHabit(false);
        } else if (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType)) {
            _prcNumber.setLangHabit(true);
            resource = _prcNumber.toNumber(resource);
        } else if (S_CHINESE_UPCASE2.equalsIgnoreCase(this._lanType)) {
            _prcBigNumber.setLangHabit(true);
            resource = _prcBigNumber.toNumber(resource);
            _prcBigNumber.setLangHabit(false);
        } else {
            _prcBigNumber.setLangHabit(false);
            resource = _prcBigNumber.toNumber(resource);
        }
        return resource;
    }

    private String[] split(String resource) {
        int radixCount;
        String trail;
        int headIndex = -1;
        int trailIndex = -1;
        boolean overHead = false;
        String strSeparator = ",";
        if (resource.indexOf(strSeparator) >= 0) {
            resource = resource.replaceAll(strSeparator, "");
        }
        int size = resource.length();
        for (int i = 0; i < size; ++i) {
            char c = resource.charAt(i);
            if (headIndex < 0 && (c >= '0' && c <= '9' || c == '.' || c == '-')) {
                headIndex = i;
                overHead = true;
            }
            if (trailIndex >= 0 || !overHead || c >= '0' && c <= '9' || c == '.' || c == '-') continue;
            trailIndex = i;
        }
        if (trailIndex == 0) {
            return null;
        }
        String head = headIndex > 0 ? resource.substring(0, headIndex) : "";
        String string = trail = trailIndex > 0 ? resource.substring(trailIndex) : "";
        resource = headIndex > 0 ? (trailIndex > 0 ? resource.substring(headIndex, trailIndex) : resource.substring(headIndex)) : (trailIndex > 0 ? resource.substring(0, trailIndex) : resource);
        int radixIndex = resource.indexOf(46);
        int n = radixCount = radixIndex > 0 ? resource.length() - 1 - radixIndex : 0;
        if (radixCount > 0) {
            int i;
            for (i = radixIndex + Math.min(2, radixCount); i > radixIndex && resource.charAt(i) == '0'; --i) {
            }
            resource = resource.substring(0, i == radixIndex ? i : i + 1);
        }
        String[] strs = new String[]{head, trail, resource};
        return strs;
    }

    private String transDollar(String resource) {
        String[] strs = this.split(resource);
        if (strs == null) {
            return resource;
        }
        String head = strs[0];
        String trail = strs[1];
        resource = strs[2];
        int radixIndex = resource.indexOf(46);
        String intStr = resource;
        String decStr = "";
        if (radixIndex > 0) {
            intStr = resource.substring(0, radixIndex);
            decStr = resource.substring(radixIndex + 1);
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(head);
        boolean hasInt = false;
        if (radixIndex < 0 && intStr.equals("0")) {
            sb.append(ResManager.loadKDString((String)"\u96f6\u7f8e\u5143", (String)"LanguageCondition_1", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
        } else if (!intStr.equals("0")) {
            sb.append(_prcBigNumber.toNumber(intStr));
            sb.append(ResManager.loadKDString((String)"\u7f8e\u5143", (String)"LanguageCondition_2", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            hasInt = true;
        }
        if (radixIndex > 0) {
            boolean bZero;
            boolean bl = bZero = intStr.length() > 1 && intStr.endsWith("0");
            if (bZero) {
                sb.append(ResManager.loadKDString((String)"\u96f6", (String)LANGUAGE_CONDITION_3, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            }
            if (decStr.length() > 1) {
                if (decStr.charAt(0) == '0' && (bZero || !hasInt)) {
                    sb.append(_prcBigNumber.toNumber(decStr.substring(1))).append(ResManager.loadKDString((String)"\u7f8e\u5206", (String)LANGUAGE_CONDITION_4, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
                } else {
                    sb.append(_prcBigNumber.toNumber(decStr)).append(ResManager.loadKDString((String)"\u7f8e\u5206", (String)LANGUAGE_CONDITION_4, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
                }
            } else {
                sb.append(_prcBigNumber.toNumber(decStr + '0')).append(ResManager.loadKDString((String)"\u7f8e\u5206", (String)LANGUAGE_CONDITION_4, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u6574", (String)"LanguageCondition_5", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
        }
        sb.append(trail);
        return sb.toString();
    }

    private String transRmb(String resource) {
        String[] strs = this.split(resource);
        if (strs == null) {
            return resource;
        }
        String head = strs[0];
        String trail = strs[1];
        resource = strs[2];
        int radixIndex = resource.indexOf(46);
        int radixCount = radixIndex > 0 ? resource.length() - 1 - radixIndex : 0;
        String integerStr = resource;
        String decStr = "";
        String decStr2 = "";
        if (radixIndex > 0) {
            integerStr = resource.substring(0, radixIndex);
            decStr = resource.substring(radixIndex + 1, radixIndex + 2);
        }
        if (radixCount >= 2) {
            decStr2 = resource.substring(radixIndex + 2);
        }
        StringBuilder sb = new StringBuilder(30);
        sb.append(head);
        boolean hasInt = false;
        if (radixIndex < 0 && integerStr.equals("0")) {
            sb.append(ResManager.loadKDString((String)"\u96f6\u5143", (String)"LanguageCondition_6", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
        } else if (!integerStr.equals("0")) {
            sb.append(_prcBigNumber.toNumber(integerStr));
            sb.append(ResManager.loadKDString((String)"\u5143", (String)"LanguageCondition_7", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            hasInt = true;
        }
        String zengStr = ResManager.loadKDString((String)"\u6574", (String)"LanguageCondition_5", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]);
        if (radixIndex > 0) {
            if (!decStr.equals("0")) {
                sb.append(_prcBigNumber.toNumber(decStr));
                sb.append(ResManager.loadKDString((String)"\u89d2", (String)"LanguageCondition_8", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            } else if (hasInt) {
                sb.append(ResManager.loadKDString((String)"\u96f6", (String)LANGUAGE_CONDITION_3, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            }
            if (radixCount == 1) {
                sb.append(zengStr);
            } else {
                if (decStr2.equals("0")) {
                    sb.append(ResManager.loadKDString((String)"\u96f6", (String)LANGUAGE_CONDITION_3, (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
                } else {
                    sb.append(_prcBigNumber.toNumber(decStr2));
                }
                sb.append(ResManager.loadKDString((String)"\u5206", (String)"LanguageCondition_9", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]));
            }
        } else {
            sb.append(zengStr);
        }
        sb.append(trail);
        return sb.toString();
    }

    public String toString() {
        return '[' + this._lanType + ']';
    }

    static {
        for (int i = 0; i < MultiLanguages.length; ++i) {
            multiLangSet.add(MultiLanguages[i]);
        }
    }
}

