/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.digitalstyle.i18n.eng;

import com.kingdee.bos.ctrl.common.digitalstyle.i18n.IMultiLanguageCurrencySay;
import com.kingdee.bos.ctrl.common.digitalstyle.i18n.IMultiLanguageSayBase;
import com.kingdee.bos.ctrl.common.digitalstyle.i18n.Util;
import com.kingdee.bos.ctrl.common.variant.Variant;

class EnglishCurrencyCommon
implements IMultiLanguageCurrencySay {
    EnglishCurrencyCommon() {
    }

    @Override
    public String sayCurrency(Variant value, String currencyIsoCode, IMultiLanguageSayBase baseImpl) {
        StringBuilder sbSaying = new StringBuilder("SAY");
        sbSaying.append(' ');
        sbSaying.append(currencyIsoCode.toUpperCase());
        sbSaying.append(' ');
        String strValue = Util.formatToStringByPattern(value, "#,##0.00");
        String[] intAndDec = Util.pickIntAndDec(strValue);
        for (int i = 0; i < intAndDec.length; ++i) {
            if (i == 0 && intAndDec[i] != null) {
                try {
                    sbSaying.append(baseImpl.sayInteger(intAndDec[i]));
                }
                catch (NumberFormatException ex) {
                    return value.toString();
                }
            }
            if (i != 1 || intAndDec[i] == null || "00".equals(intAndDec[i])) continue;
            sbSaying.append(' ');
            sbSaying.append("AND");
            sbSaying.append(' ');
            sbSaying.append(intAndDec[1]);
            sbSaying.append("/100");
        }
        sbSaying.append(' ');
        sbSaying.append("ONLY");
        return sbSaying.toString();
    }
}

