/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;

public class FileUtil {
    public static final Log log = LogFactory.getLog(FileUtil.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final int BUFFER_SIZE = 32768;

    public static String normalize(String fileUrl) {
        return StringUtils.isEmpty((String)fileUrl) ? fileUrl : FilenameUtils.normalize((String)fileUrl);
    }

    public static final File createFolder(String filePath) {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        return FileUtil.createFolder(filePath.split("\\" + FILE_SEPARATOR));
    }

    public static final File createFolder(String[] names) {
        String filePath = names[0];
        File f = null;
        for (int i = 1; i < names.length; ++i) {
            f = new File(filePath = filePath + FILE_SEPARATOR + names[i]);
            if (f.exists()) {
                if (!f.isFile()) continue;
                log.debug(":( The diretory may contains files!!! " + filePath);
                return null;
            }
            if (f.mkdir()) continue;
            log.error(":( Create directory failed!!! " + filePath);
            return null;
        }
        return f;
    }

    public static final File createFile(String filePath) throws IOException {
        File f = new File(filePath);
        if (f.exists()) {
            return f;
        }
        int i = filePath.lastIndexOf(FILE_SEPARATOR);
        if (i == -1) {
            log.error(":( Invalid file path!!! " + filePath);
            return null;
        }
        if (null == FileUtil.createFolder(filePath.substring(0, i))) {
            return null;
        }
        f = new File(filePath);
        if (!f.createNewFile()) {
            log.error(":( Create file failed!!! " + filePath);
            return null;
        }
        return f;
    }

    public static File deleteFile(File file) {
        if (file.isDirectory()) {
            String[] files = file.list();
            for (int i = 0; i < files.length; ++i) {
                File f = FileUtil.deleteFile(new File(file.getPath() + FILE_SEPARATOR + files[i]));
                if (f == null) continue;
                return f;
            }
        }
        if (file.delete()) {
            return null;
        }
        return file;
    }

    public static File deleteFile(String filePath) {
        return FileUtil.deleteFile(new File(filePath));
    }

    public static boolean deleteContent(String dir) {
        return FileUtil.deleteContent(dir, null);
    }

    public static final boolean deleteContent(String dir, final String prefix) {
        try {
            File file = new File(dir);
            if (file.isDirectory()) {
                String[] files = null;
                files = StringUtil.isEmptyString(prefix) ? file.list() : file.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix);
                    }
                });
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(dir + FILE_SEPARATOR + files[i]);
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getExtension(String filename) {
        int i;
        if (!StringUtil.isEmptyString(filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static String zipFileDir(String zipName, String zipDir) {
        String metaDir = zipDir.substring(zipDir.lastIndexOf(File.separator) + 1);
        JSONArray files = new JSONArray();
        File file = new File(zipDir);
        if (file.exists()) {
            files.add((Object)zipDir);
        }
        String zipFilePath = zipDir.substring(0, zipDir.lastIndexOf(File.separator) + 1);
        zipFilePath = zipFilePath + zipName;
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            FileUtil.zipFile(files, out, metaDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return zipFilePath;
    }

    private static void zipFile(JSONArray files, ZipOutputStream out, String metaDir) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File((String)files.get(i));
            if (file.isDirectory()) {
                File[] listFiles;
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles = file.listFiles()) {
                    try {
                        tempFiles.add((Object)tempFile.getCanonicalPath());
                    }
                    catch (IOException e) {
                        log.error((Throwable)e);
                    }
                }
                FileUtil.zipFile(tempFiles, out, metaDir);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            Path zipPath = Paths.get(path, new String[0]);
            int t = -1;
            if (path != null && path.contains(metaDir)) {
                t = path.indexOf(metaDir);
            }
            if (t == -1 || path == null) continue;
            if ((path = path.substring(t)).contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

