/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class FontUtil {
    private static final Log log = LogFactory.getLog(FontUtil.class);
    private static Font defaultFont = UIManager.getFont("FontFromFile");
    private static Font simsunServerFont;
    private static boolean simsunInited;

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultFont(Font defaultFont) {
        FontUtil.defaultFont = defaultFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getServerFontSupportedChinese() {
        if (!simsunInited) {
            String prop = System.getProperty("eas.properties.dir");
            if ((prop = FileUtil.normalize(prop)) != null) {
                try (FileInputStream fileInputStream = new FileInputStream(new File(prop + "/simsun.ttc"));){
                    simsunServerFont = Font.createFont(0, fileInputStream);
                }
                catch (FileNotFoundException e) {
                    log.error(e.getMessage());
                }
                catch (FontFormatException e) {
                    log.error(e.getMessage());
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
                finally {
                    simsunInited = true;
                }
            } else {
                simsunInited = true;
            }
        }
        return simsunServerFont;
    }

    public static AttributedString validateFont(AttributedString str) {
        if (str != null) {
            AttributedCharacterIterator.Attribute[] fatr = new AttributedCharacterIterator.Attribute[]{TextAttribute.FONT};
            AttributedCharacterIterator acitr = str.getIterator(fatr);
            Font ft = null;
            ArrayList<Integer> al = new ArrayList<Integer>();
            char c = acitr.first();
            while (c != '\uffff') {
                if (ft == null) {
                    ft = (Font)acitr.getAttribute(TextAttribute.FONT);
                }
                if (ft != null && !ft.canDisplay(c)) {
                    al.add(acitr.getIndex());
                }
                c = acitr.next();
            }
            if (al.size() > 0 && ft != null) {
                HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>();
                map.put(TextAttribute.FAMILY, "source han serif cn");
                Font nft = ft.deriveFont(map);
                Iterator itr = al.iterator();
                while (itr.hasNext()) {
                    int i = (Integer)itr.next();
                    str.addAttribute(TextAttribute.FONT, nft, i, i + 1);
                }
            }
        }
        return str;
    }

    public static Font validateFont(String source, Font font) {
        if (StringUtil.isEmptyString(source)) {
            return font;
        }
        boolean change = false;
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c > '\u007f' && c < '\u0100' || font.canDisplay(c)) continue;
            change = true;
            break;
        }
        if (change) {
            HashMap<TextAttribute, String> map = new HashMap<TextAttribute, String>();
            map.put(TextAttribute.FAMILY, "source han serif cn");
            return font.deriveFont(map);
        }
        return font;
    }

    public static Set<String> getCurTenantFonts() {
        HashSet<String> fontSet = new HashSet<String>(10);
        String tenantId = RequestContext.get().getTenantId();
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter, new QFilter("billstatus", "=", (Object)"B")};
        Map fonts = BusinessDataReader.loadFromCache((String)"bos_prt_font", (QFilter[])filters);
        Map<String, DynamicObject> rcIdMap = fonts.values().stream().collect(Collectors.toMap(item -> item.getString("rcid"), item -> item));
        ArrayList<Long> rcIds = new ArrayList<Long>(10);
        for (DynamicObject item2 : fonts.values()) {
            rcIds.add(Long.parseLong(item2.getString("rcid")));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rcIds)};
        Map rcList = BusinessDataReader.loadFromCache((String)"bos_print_resource", (QFilter[])qFilters);
        for (DynamicObject rcObj : rcList.values()) {
            long rcId = rcObj.getLong("id");
            String fontFileName = rcIdMap.get(String.valueOf(rcId)).getString("number");
            fontSet.add(fontFileName.toLowerCase());
        }
        return fontSet;
    }
}

