/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util;

import com.kingdee.bos.ctrl.common.util.PrtFont;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class PrintFontUtil {
    private static final Log log = LogFactory.getLog(PrintFontUtil.class);
    private static Map<String, List<PrtFont>> fontMapping = new HashMap<String, List<PrtFont>>();
    public static final String DEF_FONT_NAME = "\u601d\u6e90\u5b8b\u4f53 CN";
    private static PrtFont defaultFont = new PrtFont("\u601d\u6e90\u5b8b\u4f53 CN", "Source Han Serif CN", ".ttf");

    public static List<PrtFont> getFonts() {
        String tenantId = RequestContext.get().getTenantId();
        List<PrtFont> prtFonts = fontMapping.get(tenantId);
        if (prtFonts == null) {
            PrintFontUtil.initFonts();
            prtFonts = fontMapping.get(tenantId);
        }
        return prtFonts;
    }

    public static PrtFont getDefaultFont() {
        return defaultFont;
    }

    public static synchronized void initFonts() {
        String tenantId = RequestContext.get().getTenantId();
        ArrayList<PrtFont> fontList = new ArrayList<PrtFont>(10);
        QFilter qFilter = new QFilter("tenantid", "=", (Object)tenantId);
        qFilter.or(new QFilter("source", "=", (Object)"1"));
        QFilter[] filters = new QFilter[]{qFilter, new QFilter("billstatus", "=", (Object)"B")};
        Map fonts = BusinessDataReader.loadFromCache((String)"bos_prt_font", (QFilter[])filters);
        ArrayList<Long> rcIds = new ArrayList<Long>(10);
        for (DynamicObject item2 : fonts.values()) {
            rcIds.add(Long.parseLong(item2.getString("rcid")));
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", rcIds)};
        Map rcMap = BusinessDataReader.loadFromCache((String)"bos_print_resource", (QFilter[])qFilters);
        Map<String, DynamicObject> rcIdMap = fonts.values().stream().collect(Collectors.toMap(item -> item.getString("rcid"), item -> item));
        HashSet<String> fontSet = new HashSet<String>(10);
        for (DynamicObject rcObj : rcMap.values()) {
            long rcId = rcObj.getLong("id");
            String fontFileName = rcObj.getString("filename");
            String suffix = fontFileName.substring(fontFileName.lastIndexOf("."));
            DynamicObject fontObj = rcIdMap.get(String.valueOf(rcId));
            String name = fontObj.getString("name");
            if (fontSet.contains(name)) continue;
            fontSet.add(name);
            PrtFont prtFont = new PrtFont();
            prtFont.setFontName(name);
            prtFont.setFontCode(fontObj.getString("number"));
            prtFont.setFileSuffix(suffix);
            prtFont.setRcId(rcId);
            fontList.add(prtFont);
            if (DEF_FONT_NAME.equals(name)) continue;
            PrintFontUtil.downloadFont(prtFont);
        }
        fontMapping.put(tenantId, fontList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFont(PrtFont font) {
        InputStream inputStream;
        String fontFilesDir = KDFont.getFontFilesDir();
        String fileName = font.getFontFileName();
        String fileFullName = fontFilesDir + File.separatorChar + fileName;
        File fontFile = new File(fileFullName);
        if (fontFile.exists()) {
            return fontFile;
        }
        long rcId = font.getRcId();
        Map<String, Object> rcObj = PrintFontUtil.getRcObj(rcId);
        String url = (String)rcObj.get("url");
        Object data = rcObj.get("data");
        if (data != null) {
            inputStream = new ByteArrayInputStream((byte[])data);
        } else if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                inputStream = FileServiceFactory.getAttachmentFileService().getInputStream(url);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                return fontFile;
            }
        } else {
            log.debug(String.format(ResManager.loadKDString((String)"\u5b57\u4f53\u201c%s\u201d\u6587\u4ef6\u88ab\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u635f\u574f\uff0c\u8bf7\u91cd\u65b0\u5220\u9664\u5f53\u524d\u5b57\u4f53\u3002", (String)"PrintFontUtil_0", (String)"bos-print-engine", (Object[])new Object[0]), font.getFontName()));
            return fontFile;
        }
        try (FileOutputStream fos = new FileOutputStream(fontFile);){
            int index;
            byte[] bytes = new byte[1024];
            while ((index = inputStream.read(bytes)) != -1) {
                fos.write(bytes, 0, index);
                fos.flush();
            }
            Font.createFont(0, fontFile);
            log.debug("\u6253\u5370 \uff1a \u5df2\u6210\u529f\u5c06" + fileName + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + fileFullName);
        }
        catch (Exception e) {
            log.error("\u6253\u5370 \uff1a\u5c06" + fileName + "\u5199\u5165\u5b57\u4f53\u76ee\u5f55\u5931\u8d25:" + e.getMessage());
            if ((e instanceof FontFormatException || e instanceof IOException) && fontFile.exists()) {
                fontFile.delete();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("\u5b57\u4f53\u4e0b\u8f7d\u5230\u78c1\u76d8\u5173\u95ed\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return fontFile;
    }

    private static Map<String, Object> getRcObj(long rcId) {
        String sql = "select furl,fdata from %s where fid=?";
        sql = String.format(sql, "t_svc_printresource");
        Map res = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{rcId}, rSet -> {
            if (rSet.next()) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("url", rSet.getString(1));
                result.put("data", rSet.getBytes(2));
                return result;
            }
            return null;
        });
        return res;
    }
}

