/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.graph;

import com.kingdee.bos.ctrl.common.util.graph.DFSVisitor;
import com.kingdee.bos.ctrl.common.util.graph.Edge;
import com.kingdee.bos.ctrl.common.util.graph.Vertex;
import com.kingdee.bos.ctrl.common.util.graph.Visitor;
import com.kingdee.bos.ctrl.common.util.graph.VisitorEX;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class Graph<T> {
    public static final int VISIT_COLOR_WHITE = 1;
    public static final int VISIT_COLOR_GREY = 2;
    public static final int VISIT_COLOR_BLACK = 3;
    private List<Vertex<T>> verticies = new ArrayList<Vertex<T>>();
    private List<Edge<T>> edges = new ArrayList<Edge<T>>();
    private Vertex<T> rootVertex;

    public boolean isEmpty() {
        return this.verticies.size() == 0;
    }

    public boolean addVertex(Vertex<T> v) {
        boolean added = false;
        if (!this.verticies.contains(v)) {
            added = this.verticies.add(v);
        }
        return added;
    }

    public Vertex<T> getRootVertex() {
        return this.rootVertex;
    }

    public void setRootVertex(Vertex<T> root) {
        this.rootVertex = root;
        if (!this.verticies.contains(root)) {
            this.addVertex(root);
        }
    }

    public Vertex<T> getVertex(int n) {
        return this.verticies.get(n);
    }

    public List<Vertex<T>> getVerticies() {
        return this.verticies;
    }

    public boolean addEdge(Vertex<T> from, Vertex<T> to, int cost) throws IllegalArgumentException {
        if (!this.verticies.contains(from)) {
            throw new IllegalArgumentException("from is not in graph");
        }
        if (!this.verticies.contains(to)) {
            throw new IllegalArgumentException("to is not in graph");
        }
        Edge<T> e = new Edge<T>(from, to, cost);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(e);
        to.addEdge(e);
        this.edges.add(e);
        return true;
    }

    public boolean insertBiEdge(Vertex<T> from, Vertex<T> to, int cost) throws IllegalArgumentException {
        return this.addEdge(from, to, cost) && this.addEdge(to, from, cost);
    }

    public List<Edge<T>> getEdges() {
        return this.edges;
    }

    public boolean removeVertex(Vertex<T> v) {
        Edge<T> e;
        int n;
        if (!this.verticies.contains(v)) {
            return false;
        }
        this.verticies.remove(v);
        if (v == this.rootVertex) {
            this.rootVertex = null;
        }
        for (n = 0; n < v.getOutgoingEdgeCount(); ++n) {
            e = v.getOutgoingEdge(n);
            v.remove(e);
            Vertex<T> to = e.getTo();
            to.remove(e);
            this.edges.remove(e);
        }
        for (n = 0; n < v.getIncomingEdgeCount(); ++n) {
            e = v.getIncomingEdge(n);
            v.remove(e);
            Vertex<T> predecessor = e.getFrom();
            predecessor.remove(e);
        }
        return true;
    }

    public boolean removeEdge(Vertex<T> from, Vertex<T> to) {
        Edge<T> e = from.findEdge(to);
        if (e == null) {
            return false;
        }
        from.remove(e);
        to.remove(e);
        this.edges.remove(e);
        return true;
    }

    public void clearMark() {
        for (Vertex<T> w : this.verticies) {
            w.clearMark();
        }
    }

    public void clearEdges() {
        for (Edge<T> e : this.edges) {
            e.clearMark();
        }
    }

    public void depthFirstSearch(Vertex<T> v, final Visitor<T> visitor) {
        VisitorEX wrapper = new VisitorEX<T, RuntimeException>(){

            @Override
            public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException {
                if (visitor != null) {
                    visitor.visit(g, v);
                }
            }
        };
        this.depthFirstSearch(v, wrapper);
    }

    public <E extends Exception> void depthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor) throws E {
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge<T> e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            this.depthFirstSearch(e.getTo(), visitor);
        }
    }

    public void breadthFirstSearch(Vertex<T> v, final Visitor<T> visitor) {
        VisitorEX wrapper = new VisitorEX<T, RuntimeException>(){

            @Override
            public void visit(Graph<T> g, Vertex<T> v) throws RuntimeException {
                if (visitor != null) {
                    visitor.visit(g, v);
                }
            }
        };
        this.breadthFirstSearch(v, wrapper);
    }

    public <E extends Exception> void breadthFirstSearch(Vertex<T> v, VisitorEX<T, E> visitor) throws E {
        LinkedList q = new LinkedList();
        q.add(v);
        if (visitor != null) {
            visitor.visit(this, v);
        }
        v.visit();
        while (!q.isEmpty()) {
            v = (Vertex)q.removeFirst();
            for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
                Edge e = v.getOutgoingEdge(i);
                Vertex to = e.getTo();
                if (to.visited()) continue;
                q.add(to);
                if (visitor != null) {
                    visitor.visit(this, to);
                }
                to.visit();
            }
        }
    }

    public void dfsSpanningTree(Vertex<T> v, DFSVisitor<T> visitor) {
        v.visit();
        if (visitor != null) {
            visitor.visit(this, v);
        }
        for (int i = 0; i < v.getOutgoingEdgeCount(); ++i) {
            Edge<T> e = v.getOutgoingEdge(i);
            if (e.getTo().visited()) continue;
            if (visitor != null) {
                visitor.visit(this, v, e);
            }
            e.mark();
            this.dfsSpanningTree(e.getTo(), visitor);
        }
    }

    public Vertex<T> findVertexByName(String name) {
        Vertex<T> match = null;
        for (Vertex<T> v : this.verticies) {
            if (!name.equals(v.getName())) continue;
            match = v;
            break;
        }
        return match;
    }

    public Vertex<T> findVertexByData(T data, Comparator<T> compare) {
        Vertex<T> match = null;
        for (Vertex<T> v : this.verticies) {
            if (compare.compare(data, v.getData()) != 0) continue;
            match = v;
            break;
        }
        return match;
    }

    public Edge<T>[] findCycles() {
        Vertex<T> v;
        int n;
        ArrayList<Edge<Edge>> cycleEdges = new ArrayList<Edge<Edge>>();
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            v.setMarkState(1);
        }
        for (n = 0; n < this.verticies.size(); ++n) {
            v = this.getVertex(n);
            this.visit(v, cycleEdges);
        }
        Edge[] cycles = new Edge[cycleEdges.size()];
        cycleEdges.toArray(cycles);
        return cycles;
    }

    private void visit(Vertex<T> v, ArrayList<Edge<T>> cycleEdges) {
        v.setMarkState(2);
        int count = v.getOutgoingEdgeCount();
        for (int n = 0; n < count; ++n) {
            Edge<T> e = v.getOutgoingEdge(n);
            Vertex<T> u = e.getTo();
            if (u.getMarkState() == 2) {
                cycleEdges.add(e);
                continue;
            }
            if (u.getMarkState() != 1) continue;
            this.visit(u, cycleEdges);
        }
        v.setMarkState(3);
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder("Graph[");
        for (Vertex<T> v : this.verticies) {
            tmp.append(v);
        }
        tmp.append(']');
        return tmp.toString();
    }
}

