/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.graph;

import com.kingdee.bos.ctrl.common.util.graph.Edge;
import java.util.ArrayList;
import java.util.List;

public class Vertex<T> {
    private List<Edge<T>> incomingEdges = new ArrayList<Edge<T>>();
    private List<Edge<T>> outgoingEdges = new ArrayList<Edge<T>>();
    private String name;
    private boolean markField;
    private int markState;
    private T data;

    public Vertex() {
        this(null, null);
    }

    public Vertex(String n) {
        this(n, null);
    }

    public Vertex(String n, T data) {
        this.name = n;
        this.markField = false;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean addEdge(Edge<T> e) {
        if (e.getFrom() == this) {
            this.outgoingEdges.add(e);
        } else if (e.getTo() == this) {
            this.incomingEdges.add(e);
        } else {
            return false;
        }
        return true;
    }

    public void addOutgoingEdge(Vertex<T> to, int cost) {
        Edge<T> out = new Edge<T>(this, to, cost);
        this.outgoingEdges.add(out);
    }

    public void addIncomingEdge(Vertex<T> from, int cost) {
        Edge<T> out = new Edge<T>(this, from, cost);
        this.incomingEdges.add(out);
    }

    public boolean hasEdge(Edge<T> e) {
        if (e.getFrom() == this) {
            return this.incomingEdges.contains(e);
        }
        if (e.getTo() == this) {
            return this.outgoingEdges.contains(e);
        }
        return false;
    }

    public boolean remove(Edge<T> e) {
        if (e.getFrom() == this) {
            this.incomingEdges.remove(e);
        } else if (e.getTo() == this) {
            this.outgoingEdges.remove(e);
        } else {
            return false;
        }
        return true;
    }

    public int getIncomingEdgeCount() {
        return this.incomingEdges.size();
    }

    public Edge<T> getIncomingEdge(int i) {
        return this.incomingEdges.get(i);
    }

    public List getIncomingEdges() {
        return this.incomingEdges;
    }

    public int getOutgoingEdgeCount() {
        return this.outgoingEdges.size();
    }

    public Edge<T> getOutgoingEdge(int i) {
        return this.outgoingEdges.get(i);
    }

    public List getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public Edge<T> findEdge(Vertex<T> dest) {
        for (Edge<T> e : this.outgoingEdges) {
            if (e.getTo() != dest) continue;
            return e;
        }
        return null;
    }

    public Edge<T> findEdge(Edge<T> e) {
        if (this.outgoingEdges.contains(e)) {
            return e;
        }
        return null;
    }

    public int cost(Vertex<T> dest) {
        if (dest == this) {
            return 0;
        }
        Edge<T> e = this.findEdge(dest);
        int cost = Integer.MAX_VALUE;
        if (e != null) {
            cost = e.getCost();
        }
        return cost;
    }

    public boolean hasEdge(Vertex<T> dest) {
        return this.findEdge(dest) != null;
    }

    public boolean visited() {
        return this.markField;
    }

    public void mark() {
        this.markField = true;
    }

    public void setMarkState(int state) {
        this.markState = state;
    }

    public int getMarkState() {
        return this.markState;
    }

    public void visit() {
        this.mark();
    }

    public void clearMark() {
        this.markField = false;
    }

    public String toString() {
        Edge<T> e;
        int i;
        StringBuilder tmp = new StringBuilder("Vertex(");
        tmp.append(this.name);
        tmp.append(", data=");
        tmp.append(this.data);
        tmp.append("), in:[");
        for (i = 0; i < this.incomingEdges.size(); ++i) {
            e = this.incomingEdges.get(i);
            if (i > 0) {
                tmp.append(',');
            }
            tmp.append('{');
            tmp.append(e.getFrom().name);
            tmp.append(',');
            tmp.append(e.getCost());
            tmp.append('}');
        }
        tmp.append("], out:[");
        for (i = 0; i < this.outgoingEdges.size(); ++i) {
            e = this.outgoingEdges.get(i);
            if (i > 0) {
                tmp.append(',');
            }
            tmp.append('{');
            tmp.append(e.getTo().name);
            tmp.append(',');
            tmp.append(e.getCost());
            tmp.append('}');
        }
        tmp.append(']');
        return tmp.toString();
    }
}

