/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.list;

import com.kingdee.bos.ctrl.common.util.list.BlockTable;

public class Block {
    private BlockTable blocks;
    private int startPositionFiele;
    private int startIndexField;
    private int size;
    private int[] per_sizes;

    Block(BlockTable blocks, int start_position, int size) {
        this(blocks, start_position, size, -1, 0);
    }

    Block(BlockTable blocks, int start_position, int size, int logicalIndex, int objsCount) {
        this(blocks, start_position, size, logicalIndex, objsCount == 0 || blocks.isFxiedOjbectSize() ? null : new int[objsCount]);
    }

    Block(BlockTable blocks, int start_position, int size, int logicalIndex, int[] sizes) {
        this.blocks = blocks;
        this.startPositionFiele = start_position;
        this.size = size;
        this.startIndexField = logicalIndex;
        this.per_sizes = sizes;
    }

    final boolean isIdleBlock() {
        return this.startIndexField == -1;
    }

    final int tailIndex() {
        return this.startIndexField + this.objectsCount() - 1;
    }

    final boolean indexSequential(int logicalIndex) {
        return this.startIndexField + this.objectsCount() == logicalIndex;
    }

    final int objectsCount() {
        return this.blocks.isFxiedOjbectSize() ? this.size : this.per_sizes.length;
    }

    final int blockSize() {
        return this.size;
    }

    final int startPosition() {
        return this.startPositionFiele;
    }

    final int startIndex() {
        return this.startIndexField;
    }

    final int offsetStartIndex(int off) {
        return this.startIndexField += off;
    }

    final boolean has(int logicalIndex) {
        return this.startIndexField != -1 && this.startIndexField <= logicalIndex && this.tailIndex() >= logicalIndex;
    }

    final void increaseSize(int size_diff) {
        this.size += size_diff;
    }

    final void setAllocated(int logicalIndex, int objsCount) {
        if (this.startIndexField == -1) {
            this.startIndexField = logicalIndex;
            if (!this.blocks.isFxiedOjbectSize()) {
                this.per_sizes = new int[objsCount];
            }
        }
    }

    final void addObjects(int objsSize, int objsCount) {
        this.size += objsSize;
        if (!this.blocks.isFxiedOjbectSize()) {
            int[] tmp = new int[this.per_sizes.length + objsCount];
            System.arraycopy(this.per_sizes, 0, tmp, 0, this.per_sizes.length);
            this.per_sizes = tmp;
        }
    }

    final void cutFront(int cutSize) {
        this.startPositionFiele += cutSize;
        this.size -= cutSize;
    }

    final Block cutFrontAsBlock(int cutSize) {
        Block cut = null;
        if (cutSize < this.size) {
            if (cutSize != 0) {
                cut = new Block(this.blocks, this.startPositionFiele, cutSize);
                this.cutFront(cutSize);
            }
        } else {
            cut = this;
        }
        return cut;
    }

    final void cutTail(int cutSize) {
        this.size -= cutSize;
    }

    final Block[] splits(int logicalIndex) {
        Block[] splits = new Block[]{this.pickUp(this.startIndexField, logicalIndex - this.startIndexField), this.pickUp(logicalIndex, this.tailIndex() + 1 - logicalIndex)};
        return splits;
    }

    final Block[] freeObjects(int logicalIndex, int objsCount) {
        Block[] splits = new Block[3];
        splits[0] = this.pickUp(this.startIndexField, logicalIndex - this.startIndexField);
        splits[1] = this.pickUp(logicalIndex, objsCount);
        splits[1].startIndexField = -1;
        splits[1].per_sizes = null;
        splits[2] = this.pickUp(logicalIndex + objsCount, this.startIndexField + this.objectsCount() - (logicalIndex + objsCount));
        if (splits[2] != null) {
            splits[2].startIndexField -= objsCount;
        }
        return splits;
    }

    final boolean unit(Block blk) {
        if (blk == null) {
            return false;
        }
        if (this.startIndexField == -1 && blk.startIndexField == -1) {
            if (this.startPositionFiele + this.size == blk.startPosition()) {
                this.size += blk.blockSize();
                return true;
            }
        } else if (this.startIndexField != -1 && blk.startIndexField != -1 && this.startPositionFiele + this.size == blk.startPosition() && this.tailIndex() + 1 == blk.startIndexField) {
            int oldCount = this.objectsCount();
            this.addObjects(blk.blockSize(), blk.objectsCount());
            if (!this.blocks.isFxiedOjbectSize()) {
                System.arraycopy(blk.per_sizes, 0, this.per_sizes, oldCount, blk.objectsCount());
            }
            return true;
        }
        return false;
    }

    final Block pickUp(int index, int objsCount) {
        if (objsCount <= 0) {
            return null;
        }
        int[] tmp = null;
        int objsSize = 0;
        if (!this.blocks.isFxiedOjbectSize()) {
            tmp = new int[objsCount];
            System.arraycopy(this.per_sizes, index - this.startIndexField, tmp, 0, tmp.length);
            for (int i = 0; i < objsCount; ++i) {
                objsSize += this.per_sizes[i + index - this.startIndexField];
            }
        } else {
            objsSize = objsCount;
        }
        return new Block(this.blocks, this.objectPosition(index), objsSize, index, tmp);
    }

    final int objectSize(int logicalIndex) {
        return this.blocks.isFxiedOjbectSize() ? 1 : this.per_sizes[logicalIndex - this.startIndexField];
    }

    final void setObjectSize(int logicalIndex, int size) {
        if (!this.blocks.isFxiedOjbectSize()) {
            this.per_sizes[logicalIndex - this.startIndexField] = size;
        }
    }

    final int objectPosition(int logicalIndex) {
        int position = this.startPositionFiele;
        if (this.blocks.isFxiedOjbectSize()) {
            position += logicalIndex - this.startIndexField;
        } else {
            for (int i = this.startIndexField; i < logicalIndex; ++i) {
                position += this.per_sizes[i - this.startIndexField];
            }
        }
        return position;
    }

    public String toString() {
        String str = "position=" + this.startPositionFiele + ",size=" + this.size;
        if (this.startIndexField != -1) {
            str = str + ",index=" + this.startIndexField + ",objsCount=" + this.objectsCount();
        }
        return str + "\r\n";
    }
}

