/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.xml;

import com.kingdee.bos.ctrl.common.util.xml.IXmlIO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class XmlUtil {
    private static final Log log = LogFactory.getLog(XmlUtil.class);
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";

    public static Object loadChilds(Element elm, String childTag, IXmlIO io, ILoadHook hook) {
        List list = elm.elements(childTag);
        int len = list.size();
        Object obj = hook.newObject(len);
        for (int i = 0; i < len; ++i) {
            hook.loadChild(obj, (Element)list.get(i), i, io);
        }
        return obj;
    }

    public static void saveChilds(Object obj, Element elm, IXmlIO io, ISaveHook hook) {
        int len = hook.getChildCount(obj);
        for (int i = 0; i < len; ++i) {
            Element item = hook.saveChild(obj, i, io);
            if (item == null) continue;
            elm.add(item);
        }
    }

    public static Element loadXmlStream(InputStream is) throws IOException, DocumentException {
        SAXReader builder = new SAXReader();
        Document doc = null;
        try {
            doc = builder.read(is);
        }
        catch (DocumentException je) {
            log.error("JDOM Parser ERROR!");
            log.error("this classloader = " + XmlUtil.class.getClassLoader());
            log.error("thread classloader = " + Thread.currentThread().getContextClassLoader());
            log.error("system classloader = " + ClassLoader.getSystemClassLoader());
            throw je;
        }
        if (doc != null) {
            return doc.getRootElement();
        }
        return null;
    }

    public static Element loadXmlBytes(byte[] xmlBytes) throws IOException, DocumentException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);){
            for (int i = 0; i < xmlBytes.length && xmlBytes[i] <= 0; ++i) {
                inputStream.read();
            }
            Element element = XmlUtil.loadXmlStream(inputStream);
            return element;
        }
    }

    public static Element loadXmlFile(String filePath) throws IOException, DocumentException {
        return XmlUtil.loadXmlFile(new File(filePath));
    }

    public static Element loadXmlFile(File file) throws IOException, DocumentException {
        try (FileInputStream in = new FileInputStream(file);){
            Element element = XmlUtil.loadXmlStream(in);
            return element;
        }
    }

    public static Element loadXmlString(String s) throws IOException, DocumentException {
        return XmlUtil.loadXmlBytes(s.getBytes(StandardCharsets.UTF_8));
    }

    public static boolean saveXmlStream(OutputStream fos, Element elm) throws IOException {
        OutputFormat outputFormat = new OutputFormat("\t", true, "UTF-8");
        outputFormat.setTrimText(true);
        XMLWriter xmlWriter = new XMLWriter(fos, outputFormat);
        xmlWriter.write(elm);
        return true;
    }

    public static byte[] saveXmlBytes(Element elm) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            XmlUtil.saveXmlStream(baos, elm);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public static boolean saveXmlFile(String filePath, Element elm) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            boolean bl = XmlUtil.saveXmlStream(fos, elm);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveXmlFile(File file, Element elm) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);){
            boolean bl = XmlUtil.saveXmlStream(fos, elm);
            return bl;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    public static String outputString(Element elm) {
        OutputFormat format = new OutputFormat("\t", true, "GB2312");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter((OutputStream)os, format);
            xmlWriter.write(elm);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return os.toString();
    }

    public static void printElement(Element elm) {
        OutputFormat format = new OutputFormat("\t", true, "GB2312");
        XMLWriter xmlWriter = null;
        try {
            xmlWriter = new XMLWriter(format);
            xmlWriter.write(elm);
            log.debug(xmlWriter.toString());
        }
        catch (IOException ex) {
            log.error(ex.getMessage());
        }
    }

    public static final HashMap attributes2HashMap(List attrs) {
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    public static final List makeMapElements(Map map, String tagName) {
        ArrayList<DefaultElement> list = new ArrayList<DefaultElement>();
        if (map != null) {
            Iterator keys = map.keySet().iterator();
            Iterator vals = map.values().iterator();
            while (keys.hasNext()) {
                DefaultElement e = new DefaultElement(tagName);
                e.addAttribute(ATTR_NAME, (String)keys.next());
                Object value = vals.next();
                if (value != null) {
                    List<Element> itemsE;
                    if (value instanceof String) {
                        e.addAttribute(ATTR_VALUE, (String)value);
                    } else if (value instanceof Object[]) {
                        itemsE = null;
                        if (value instanceof String[]) {
                            e.addAttribute(ATTR_TYPE, "String[]");
                            itemsE = XmlUtil.makeStrArrayElements((String[])value, "Item");
                        } else if (value instanceof Map[]) {
                            e.addAttribute(ATTR_TYPE, "java.util.Map[]");
                            itemsE = XmlUtil.makeMapArrayElements((Map[])value, "Item");
                        } else {
                            throw new UnsupportedOperationException("Unkown value type:" + value);
                        }
                        e.setContent(itemsE);
                    } else if (value instanceof Map) {
                        e.addAttribute(ATTR_TYPE, "java.util.Map");
                        itemsE = XmlUtil.makeMapElements((HashMap)value, "Property");
                        e.setContent(itemsE);
                    }
                }
                list.add(e);
            }
        }
        return list;
    }

    public static List<Element> makeStrArrayElements(String[] values, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>(values.length);
        for (int i = 0; i < values.length; ++i) {
            DefaultElement e = new DefaultElement(tagName);
            e.addElement(values[i]);
            list.add((Element)e);
        }
        return list;
    }

    public static List<Element> makeMapArrayElements(Map[] value, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>(value.length);
        for (int i = 0; i < value.length; ++i) {
            DefaultElement e = new DefaultElement(tagName);
            e.setContent(XmlUtil.makeMapElements(value[i], "Property"));
            list.add((Element)e);
        }
        return list;
    }

    public static Map[] makeMapArray(List es, String tagName) {
        Map[] mapArray = new Map[es.size()];
        for (int i = 0; i < mapArray.length; ++i) {
            Element eChild = (Element)es.get(i);
            mapArray[i] = XmlUtil.makeMap(eChild.elements(tagName));
        }
        return mapArray;
    }

    public static String[] makeStrArray(List es) {
        String[] strArray = new String[es.size()];
        for (int i = 0; i < strArray.length; ++i) {
            Element eChild = (Element)es.get(i);
            strArray[i] = eChild.getText();
        }
        return strArray;
    }

    public static final HashMap makeMap(List es) {
        HashMap<String, String> properties = null;
        for (Element eChild : es) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            String name = eChild.attributeValue(ATTR_NAME);
            Object value = eChild.attributeValue(ATTR_VALUE);
            if (value == null) {
                String type = eChild.attributeValue(ATTR_TYPE);
                if ("java.util.Map".equals(type)) {
                    value = XmlUtil.makeMap(eChild.elements("Property"));
                } else if ("String[]".equals(type)) {
                    value = XmlUtil.makeStrArray(eChild.elements("Item"));
                } else if ("java.util.Map[]".equals(type)) {
                    value = XmlUtil.makeMapArray(eChild.elements("Item"), "Property");
                }
            }
            properties.put(name, (String)value);
        }
        return properties;
    }

    public static abstract class ASaveMap
    implements ISaveHook,
    ISaveMapHook {
        private Object[] entries;

        @Override
        public int getChildCount(Object obj) {
            this.entries = ((Map)obj).entrySet().toArray();
            return this.entries.length;
        }

        @Override
        public Element saveChild(Object obj, int index, IXmlIO io) {
            return this.saveEntry((Map.Entry)this.entries[index], io);
        }
    }

    @FunctionalInterface
    public static interface ISaveMapHook {
        public Element saveEntry(Map.Entry var1, IXmlIO var2);
    }

    public static interface ISaveHook {
        public int getChildCount(Object var1);

        public Element saveChild(Object var1, int var2, IXmlIO var3);
    }

    public static abstract class ALoadArrayList
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;

        @Override
        public void loadChild(Object obj, Element elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((ArrayList)obj).add(this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new ArrayList(childCount);
        }
    }

    public static abstract class ALoadHashMap
    implements ILoadHook,
    ILoadExHook {
        protected Object returnObj;
        protected Object returnKey;

        @Override
        public void loadChild(Object obj, Element elm, int index, IXmlIO io) {
            if (this.loadChild(elm, io)) {
                ((HashMap)obj).put(this.returnKey, this.returnObj);
            }
        }

        @Override
        public Object newObject(int childCount) {
            return new HashMap(childCount);
        }
    }

    @FunctionalInterface
    public static interface ILoadExHook {
        public boolean loadChild(Element var1, IXmlIO var2);
    }

    public static interface ILoadHook {
        public Object newObject(int var1);

        public void loadChild(Object var1, Element var2, int var3, IXmlIO var4);
    }
}

