/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;

class VarBigDecimal
extends VarBase {
    VarBigDecimal() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 11: {
                    Variant vleft = new Variant();
                    Variant vright = new Variant();
                    if (left.isNumeric(vleft) && right.isNumeric(vright)) {
                        result.setVariant(vleft.add(vright));
                        break;
                    }
                    result.setObject(left.toString().concat((String)right.getValue()), 11);
                    break;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"Operations on this data type are not supported ", (String)"Variant_2", (String)"bos-print-engine", (Object[])new Object[0]));
                    break;
                }
                default: {
                    result.setObject(((BigDecimal)left.getValue()).add(right.toBigDecimal()), 10);
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch ((byte)right.getVt()) {
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"Operations on this data type are not supported ", (String)"Variant_2", (String)"bos-print-engine", (Object[])new Object[0]));
                    return;
                }
            }
            BigDecimal r = right.toBigDecimal();
            if (r.signum() == 0) {
                ExprErr.goError(2L, null);
            }
            BigDecimal dividend = (BigDecimal)left.getValue();
            BigDecimal divisor = right.toBigDecimal();
            result.setObject(dividend.divide(divisor, 16, 4), 10);
            return;
        }
    }
}

