/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.dataentity.resource.ResManager;

class VarBigInteger
extends VarBase {
    VarBigInteger() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 5: {
                    Util.add(((BigInteger)left.getValue()).floatValue(), ((Float)right.getValue()).floatValue(), result);
                    return;
                }
                case 6: {
                    Util.add(((BigInteger)left.getValue()).doubleValue(), (Double)right.getValue(), result);
                    return;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).add((BigInteger)left.getValue()), 9);
                    return;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(new BigDecimal((BigInteger)left.getValue())), 10);
                    return;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"Operations on this data type are not supported ", (String)"Variant_2", (String)"bos-print-engine", (Object[])new Object[0]));
                    return;
                }
            }
            result.setObject(((BigInteger)left.getValue()).add(right.toBigInteger()), 9);
            return;
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 5: {
                    Util.divide(((BigInteger)left.getValue()).floatValue(), ((Float)right.getValue()).floatValue(), result);
                    return;
                }
                case 6: {
                    Util.divide(((BigInteger)left.getValue()).doubleValue(), (Double)right.getValue(), result);
                    return;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).divide((BigInteger)left.getValue()), 9);
                    return;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).divide(new BigDecimal((BigInteger)left.getValue()), 4), 10);
                    return;
                }
                case 14: 
                case 16: 
                case 17: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"Operations on this data type are not supported ", (String)"Variant_2", (String)"bos-print-engine", (Object[])new Object[0]));
                    return;
                }
            }
            result.setObject(((BigInteger)left.getValue()).divide(right.toBigInteger()), 9);
            return;
        }
    }
}

