/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.variant;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.VarBase;
import com.kingdee.bos.ctrl.common.variant.Variant;
import java.math.BigDecimal;
import java.util.Calendar;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        result.setObject(Util.addCalendar(cal, right.toBigDecimal()));
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double rightval = right.doubleValue();
        if (rightval == 0.0) {
            ExprErr.goError(2L, null);
        }
        BigDecimal days = left.toBigDecimal().divide(right.toBigDecimal(), 7, 4);
        long leftval = Util.getMillis2BaseDate(days);
        if (result.getVt() == 13) {
            ((Calendar)result.getValue()).setTimeInMillis(leftval);
        } else {
            Calendar cldr = Calendar.getInstance();
            cldr.setTimeInMillis(leftval);
            result.setObject(cldr, 13);
        }
    }
}

