/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.helper;

import com.kingdee.bos.ctrl.common.util.PrintConfigUtil;
import com.kingdee.bos.ctrl.print.ui.view.BasicPainterView;
import com.kingdee.bos.ctrl.print.ui.view.ImagePainter;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.ThreadLocals;

public class ExportContext {
    private static ThreadLocal<ExportContext> current = ThreadLocals.create();
    private String taskId;
    private String formId;
    private String appId;
    private boolean preview;
    private int pdfMaxPageSize = 10000;
    private int maxOnePdfSize = PrintConfigUtil.onePdfMaxPage();
    private boolean isPageSeparation;
    private String fileStorageType;
    private final Map<String, String> localLangMap = new HashMap<String, String>(4);
    private BasicPainterView imagePainter;

    public static void set(ExportContext rc) {
        current.set(rc);
    }

    public static ExportContext get() {
        ExportContext context = current.get();
        if (context == null) {
            ExportContext.set(new ExportContext());
        }
        return current.get();
    }

    public Map<String, String> getLocalLangMap() {
        return this.localLangMap;
    }

    public String getLocalLang(String formId) {
        if (formId != null) {
            return this.localLangMap.get(formId);
        }
        return RequestContext.get().getLang().toString();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public int getPdfMaxPageSize() {
        return this.pdfMaxPageSize;
    }

    public void setPdfMaxPageSize(int pdfMaxPageSize) {
        this.pdfMaxPageSize = pdfMaxPageSize;
    }

    public boolean isPageSeparation() {
        return this.isPageSeparation;
    }

    public void setPageSeparation(boolean isPageSeparation) {
        this.isPageSeparation = isPageSeparation;
    }

    public int getMaxOnePdfSize() {
        return this.maxOnePdfSize;
    }

    public void setMaxOnePdfSize(int maxOnePdfSize) {
        this.maxOnePdfSize = maxOnePdfSize;
    }

    public BasicPainterView getImagePainter() {
        String printModelFast;
        if (this.imagePainter == null && "true".equals(printModelFast = SystemPropertyUtils.getProptyByTenant((String)"OLD_PRT_FAST_MODEL", (String)RequestContext.get().getTenantId()))) {
            this.imagePainter = new ImagePainter();
        }
        return this.imagePainter;
    }

    public void setImagePainter(BasicPainterView imagePainter) {
        this.imagePainter = imagePainter;
    }

    public String getFileStorageType() {
        return this.fileStorageType;
    }

    public void setFileStorageType(String fileStorageType) {
        this.fileStorageType = fileStorageType;
    }
}

