/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.helper;

import com.kingdee.bos.ctrl.common.util.PrintFontUtil;
import com.kingdee.bos.ctrl.helper.ExportContext;
import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.kdf.form2.ui.NotePrinter;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ToolboxLoader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.DataXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintBrowser;
import com.kingdee.bos.ctrl.reportone.r1.print.config.R1PrintConfigReader;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.io.R1PrintXmlReader;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.RuntimeModel;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.mservice.svc.watermark.IWaterMarkProxy;
import kd.bos.service.ServiceFactory;

public class ExportService {
    private static final String EXPORT_SERVICE_0 = "ExportService_0";
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private String modelErrMsg = ResManager.loadKDString((String)"\u5957\u6253\u6a21\u578b\u751f\u6210\u9519\u8bef\u3002", (String)"ExportService_0", (String)"bos-print-engine", (Object[])new Object[0]);
    private Map<String, Object> para = new HashMap<String, Object>(16);
    private static final Log log = LogFactory.getLog(ExportService.class);
    private NotePrinter _notePrinter;

    public Map<String, Object> getPara() {
        return this.para;
    }

    public void setPara(Map<String, Object> para) {
        this.para = para;
    }

    protected NotePrinter getNotePrinter() {
        if (this._notePrinter == null) {
            this._notePrinter = new NotePrinter();
        }
        return this._notePrinter;
    }

    public boolean exportPdf(String templateFormId, IPrintDataProvider dataProvider, OutputStream outputStream) {
        PrintMetadata metadata = (PrintMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)templateFormId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        RuntimeModel rm = null;
        try {
            rm = this.loadR1Model(metadata, dataProvider);
        }
        catch (Exception e) {
            log.error(this.modelErrMsg, (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{this.modelErrMsg});
        }
        return this.exportPdf(rm, (Object)dataProvider, outputStream);
    }

    public boolean exportPdf(PrintMetadata metadata, IPrintDataProvider dataProvider, OutputStream outputStream) {
        RuntimeModel rm = null;
        try {
            rm = this.loadR1Model(metadata, dataProvider);
        }
        catch (Exception e) {
            log.error(this.modelErrMsg, (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{this.modelErrMsg});
        }
        return this.exportPdf(rm, (Object)dataProvider, outputStream);
    }

    public boolean exportPdf(RuntimeModel model, Object dataProvider, OutputStream outputStream) {
        NotePrinter printer = new NotePrinter();
        printer.getPrinter().setWaterMark(model.getWaterMark());
        INotePrintHelper printHelper = this.createPrintHelper(printer, dataProvider);
        printHelper.exportPDF((Object)model, outputStream);
        return true;
    }

    public List<BufferedImage> exportJpg(PrintMetadata metadata, IPrintDataProvider dataProvider) {
        RuntimeModel rm = null;
        try {
            rm = this.loadR1Model(metadata, dataProvider);
        }
        catch (Exception e) {
            log.error(this.modelErrMsg, (Throwable)e);
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[]{this.modelErrMsg});
        }
        return this.exportJpg(rm, (Object)dataProvider);
    }

    public List<BufferedImage> exportJpg(RuntimeModel model, Object dataProvider) {
        INotePrintHelper printHelper = this.createPrintHelper(new NotePrinter(), dataProvider);
        List<BufferedImage> ret = printHelper.exportJPG(model);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportPdf(List<PrintMetadata> templateMatadatas, List<IPrintDataProvider> dataProviders, OutputStream outputStream) {
        StringBuilder prompt = this.prepareCrossPrint(templateMatadatas, dataProviders);
        if (prompt != null) {
            log.error(prompt.toString());
            return false;
        }
        try {
            String name = "";
            if (!templateMatadatas.isEmpty()) {
                name = templateMatadatas.get(0).getName().getLocaleValue();
            }
            this.getNotePrinter().getPrinter().getIOManager().exportToPdf(name, outputStream);
        }
        finally {
            log.error(Thread.currentThread().getName());
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportXls(List<PrintMetadata> templateMatadatas, List<IPrintDataProvider> dataProviders, OutputStream outputStream) {
        StringBuilder prompt = this.prepareCrossPrint(templateMatadatas, dataProviders);
        if (prompt != null) {
            log.error(prompt.toString());
            return false;
        }
        try {
            String name = "";
            if (!templateMatadatas.isEmpty()) {
                name = templateMatadatas.get(0).getName().getLocaleValue();
            }
            this.getNotePrinter().getPrinter().getIOManager().exportToXls(name, outputStream, this.getPara());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }

    protected INotePrintHelper createPrintHelper(NotePrinter notePrinter, Object dataProvider) {
        R1PrintBrowser helper = new R1PrintBrowser();
        helper.setCrossPrint(true);
        helper.setPrinterCtrl(notePrinter.getPrinter());
        return helper;
    }

    private RuntimeModel loadR1Model(PrintMetadata metadata, IPrintDataProvider dataProvider) throws R1Exception {
        R1PrintXmlReader rd = new R1PrintXmlReader();
        try (InputStream nodeIs = R1PrintConfigReader.getNodes();){
            ArrayList xmlTransChain = ToolboxLoader.createXmlTransChain(nodeIs);
            rd.setXmlTransChain(xmlTransChain);
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException("create TransChain Error");
        }
        String formId = dataProvider.getMainEntityType().getName();
        ReportModel rm = rd.fromXml(metadata, new DataXmlTrans());
        if (this.para != null && this.para.get("removemargin") != null && ((Boolean)this.para.get("removemargin")).booleanValue()) {
            R1PrintModelHelper.getPrintInfo(rm).setMarginLeft(0);
            R1PrintModelHelper.getPrintInfo(rm).setMarginTop(0);
        }
        RuntimeModel runtimeModel = new RuntimeModel(rm);
        runtimeModel.setPdfName(metadata.getName().getLocaleValue());
        runtimeModel.setPluginProxy(dataProvider.getPluginProxy());
        runtimeModel.setPageId(dataProvider.getPageId());
        if (dataProvider.getPkIds() != null && !dataProvider.getPkIds().isEmpty() && dataProvider.getPkIds().get(0) != null) {
            runtimeModel.setPkId(dataProvider.getPkIds().get(0).toString());
        }
        runtimeModel.hookDataProvider(dataProvider, null);
        IWaterMarkProxy waterMarkProxy = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
        WaterMark wm = waterMarkProxy.loadFromCache(formId);
        runtimeModel.setWaterMark(wm);
        PrintFontUtil.initFonts();
        return runtimeModel;
    }

    protected StringBuilder prepareCrossPrint(List<PrintMetadata> templateMatadatas, List<IPrintDataProvider> dataProviders) {
        int len = templateMatadatas.size();
        this.getNotePrinter().getPrinter().clear();
        INotePrintHelper[] browsers = new INotePrintHelper[len];
        Object[] model = new Object[len];
        for (int i = 0; i < len; ++i) {
            try {
                String formId;
                model[i] = this.loadR1Model(templateMatadatas.get(i), dataProviders.get(i));
                MainEntityType entityType = dataProviders.get(i).getMainEntityType();
                if (entityType != null && (formId = entityType.getName()) != null && !ExportContext.get().getLocalLangMap().containsKey(formId)) {
                    ExportContext.get().getLocalLangMap().put(formId, dataProviders.get(i).getPrintLang(formId).toString());
                }
            }
            catch (R1Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            NotePrinter printer = this.getNotePrinter();
            printer.getPrinter().setWaterMark(((RuntimeModel)model[i]).getWaterMark());
            browsers[i] = this.createPrintHelper(this.getNotePrinter(), dataProviders.get(i));
            browsers[i].initPrintCtrl(model[i]);
            browsers[i].createPrintJob(model[i]);
            browsers[i].setCrossPrint(true);
            browsers[i].setCustomizePrintJobConfig(null);
        }
        return null;
    }
}

