/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.form2.ui;

import com.kingdee.bos.ctrl.kdf.form2.ui.INotePrintHelper;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.ui.IPaintFilter;

public class NotePrinter {
    private KDPrinter ctrlPrint;
    private INotePrintHelper.StateListener noteStateListener;
    private IConfigChangeListener configChangeListener;
    private boolean _isR1Preview;

    public KDPrinter getPrinter() {
        if (this.ctrlPrint == null) {
            this.ctrlPrint = new KDPrinter();
            HiddenLayerFilter filter = new HiddenLayerFilter();
            filter.setApply(true);
            filter.setPreviewApply(false);
            this.ctrlPrint.setPaintFilter(filter);
        }
        return this.ctrlPrint;
    }

    public void setCongifChangeListener(IConfigChangeListener ccl) {
        if (ccl != null && ccl != this.configChangeListener) {
            if (this.configChangeListener != null) {
                this.getPrinter().removeConfigChangeListener(this.configChangeListener);
            }
            this.getPrinter().addConfigChangeListener(ccl);
            this.configChangeListener = ccl;
        }
    }

    public INotePrintHelper.StateListener getNoteStateListener() {
        if (this.noteStateListener == null) {
            this.noteStateListener = new NoteStateListener();
        }
        return this.noteStateListener;
    }

    public void setExportXlsPermission(boolean canExport) {
        this._isR1Preview = canExport;
    }

    private boolean checkR1Preview() {
        return this._isR1Preview;
    }

    private static class NoteStateListener
    implements INotePrintHelper.StateListener {
        private NoteStateListener() {
        }

        @Override
        public void notifyState(int key, Object value) {
            if (key == 1) {
                // empty if block
            }
        }
    }

    private static class HiddenLayerFilter
    implements IPaintFilter {
        private boolean isApplyField = true;
        private boolean isPreviewApplyField;

        private HiddenLayerFilter() {
        }

        @Override
        public boolean accept(Integer layer, boolean isPreviewing) {
            if (layer == 1) {
                if (isPreviewing) {
                    return !this.isPreviewApply();
                }
                return false;
            }
            return true;
        }

        @Override
        public void setApply(boolean isApply) {
            this.isApplyField = isApply;
        }

        @Override
        public boolean isApply() {
            return this.isApplyField;
        }

        public boolean isPreviewApply() {
            return this.isPreviewApplyField;
        }

        public void setPreviewApply(boolean isPreviewApply) {
            this.isPreviewApplyField = isPreviewApply;
        }
    }
}

