/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.kdf.util.render.SynchronousHTMLEditorKit;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RichTextRender {
    private JEditorPane editorPane = this.createJEditorPane();
    static final Dimension DEFAULT_SIZE = new Dimension(800, 800);

    public ComponentOrientation getOrientation() {
        return this.editorPane.getComponentOrientation();
    }

    public void setOrientation(ComponentOrientation orientation) {
        this.editorPane.setComponentOrientation(orientation);
    }

    public Dimension getSize() {
        return this.editorPane.getSize();
    }

    public void setSize(Dimension dimension) {
        this.editorPane.setPreferredSize(dimension);
    }

    public void loadUrl(URL url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while loading %s", url), e);
        }
    }

    public void loadUrl(String url) {
        try {
            this.editorPane.setPage(url);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception while loading %s", url), e);
        }
    }

    public void loadHtml(String html) {
        this.editorPane.setEditable(false);
        this.editorPane.setText(html);
        this.editorPane.setContentType("text/html");
        this.onDocumentLoad();
    }

    protected void onDocumentLoad() {
    }

    public Dimension getDefaultSize() {
        return DEFAULT_SIZE;
    }

    public BufferedImage getBufferedImage() {
        JFrame frame = new JFrame();
        frame.setPreferredSize(this.editorPane.getPreferredSize());
        frame.setUndecorated(true);
        frame.add(this.editorPane);
        frame.pack();
        Dimension prefSize = frame.getPreferredSize();
        BufferedImage img = new BufferedImage(prefSize.width, prefSize.height, 2);
        Graphics graphics = img.getGraphics();
        frame.setVisible(true);
        frame.paint(graphics);
        frame.setVisible(false);
        frame.dispose();
        return img;
    }

    public void paint(Graphics graphics) {
        JFrame frame = new JFrame();
        frame.setPreferredSize(this.editorPane.getPreferredSize());
        frame.setUndecorated(true);
        frame.add(this.editorPane);
        frame.pack();
        frame.setVisible(true);
        frame.paint(graphics);
        frame.setVisible(false);
        frame.dispose();
    }

    protected JEditorPane createJEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setSize(this.getDefaultSize());
        editorPane.setEditable(false);
        SynchronousHTMLEditorKit kit = new SynchronousHTMLEditorKit();
        editorPane.setEditorKitForContentType("text/html", kit);
        editorPane.setContentType("text/html");
        editorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("page")) {
                    RichTextRender.this.onDocumentLoad();
                }
            }
        });
        return editorPane;
    }

    public void show() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame();
        frame.setTitle("My First Swing Application");
        frame.setDefaultCloseOperation(3);
        JLabel label = new JLabel();
        label.setText("Welcome");
        frame.add(label);
        frame.add(this.editorPane);
        frame.pack();
        frame.setVisible(true);
    }
}

