/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import javax.swing.SwingUtilities;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SimpleTextRender {
    private static final Log log = LogFactory.getLog(SimpleTextRender.class);
    private static SimpleTextRender instance;
    private Rectangle rView = new Rectangle();
    private Rectangle rText = new Rectangle(0, 0, 0, 0);
    protected boolean _isBlackWhite = false;
    protected boolean _isClipString = false;
    protected boolean _isKeepClip = false;

    public static synchronized SimpleTextRender sharedInstance() {
        if (instance == null) {
            instance = new SimpleTextRender();
        }
        return instance;
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this._isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this._isBlackWhite;
    }

    public void setKeepClip(boolean b) {
        this._isKeepClip = b;
    }

    public void setIsClipString(boolean isClipString) {
        this._isClipString = isClipString;
    }

    public void draw(Graphics g, Shape clip, String text, Style style) {
        if (StringUtil.isEmptyString(text)) {
            return;
        }
        SimpleTextRender.draw(this, g, clip, text, style);
        log.debug(" SimpleTextRender \u7ed8\u5236\u5b57\u7b26\uff1a" + text);
    }

    private Font readyFont(Graphics2D g, String text, Style style) {
        Font font = FontUtil.getDefaultFont();
        if (font == null) {
            font = style.getFont();
            font = FontUtil.validateFont(text, font);
        }
        Color fontColor = style.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            g.setColor(fontColor);
        } else {
            g.setColor(Color.BLACK);
        }
        g.setFont(font);
        return font;
    }

    private void drawNormal(Graphics2D g, Shape clip, String text, Style style) {
        float fontCenter;
        float clipCenter;
        if (!(clip instanceof Rectangle2D)) {
            return;
        }
        Rectangle2D rect = clip.getBounds2D();
        double rx = rect.getX();
        double ry = rect.getY();
        double rw = rect.getWidth();
        double rh = rect.getHeight();
        Font font = this.readyFont(g, text, style);
        LineMetrics lm = font.getLineMetrics(text, g.getFontRenderContext());
        float fontHeight = lm.getAscent() + lm.getDescent();
        this.rView.x = (int)rx;
        this.rView.y = (int)ry;
        this.rView.width = (int)rw;
        this.rView.height = (int)rh;
        Rectangle2D r = font.getStringBounds(text, g.getFontRenderContext());
        int tWidth = (int)(r.getWidth() + 0.5);
        boolean textChanged = false;
        if (tWidth > this.rView.width) {
            if (!this._isKeepClip) {
                rw = tWidth;
                this.rView.width = tWidth;
                if (clip instanceof Rectangle2D) {
                    ((Rectangle2D)clip).setRect(rx, ry, rw, rh);
                }
            } else if (this._isClipString) {
                text = SwingUtilities.layoutCompoundLabel(g.getFontMetrics(), text, null, 0, 0, 0, 0, this.rView, this.rText, this.rText, 0);
                textChanged = true;
            } else if (!SimpleTextRender.isTextStyle(style) && SimpleTextRender.isNumberString(text)) {
                char[] cs = new char[text.length()];
                for (int i = 0; i < text.length(); ++i) {
                    cs[i] = 35;
                }
                text = new String(cs);
                textChanged = true;
            }
        }
        double x = 0.0;
        double y = 0.0;
        Styles.HorizontalAlignment hAlign = style.getHorizontalAlign();
        Styles.VerticalAlignment vAlign = style.getVerticalAlign();
        if (vAlign == Styles.VerticalAlignment.TOP) {
            y = ry + (double)lm.getAscent();
        } else if (vAlign == Styles.VerticalAlignment.BOTTOM) {
            y = ry + rh - 1.0 - (double)lm.getDescent();
        } else {
            clipCenter = (float)rh / 2.0f;
            fontCenter = fontHeight / 2.0f;
            y = ry + (double)(clipCenter - fontCenter) + (double)lm.getAscent() - 1.0;
        }
        if (hAlign == Styles.HorizontalAlignment.CENTER) {
            if (textChanged) {
                Rectangle2D fontRect = font.getStringBounds(text, g.getFontRenderContext());
                tWidth = (int)fontRect.getWidth();
            }
            clipCenter = (float)rw / 2.0f;
            fontCenter = tWidth / 2;
            x = rx + (double)(clipCenter - fontCenter);
        } else if (hAlign == Styles.HorizontalAlignment.RIGHT) {
            if (textChanged) {
                Rectangle2D fontRect = font.getStringBounds(text, g.getFontRenderContext());
                tWidth = (int)fontRect.getWidth();
            }
            x = rx + rw - 1.0 - (double)tWidth;
        } else {
            x = rx;
        }
        Shape oldClip = g.getClip();
        g.clip(clip);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String[] arr = text.split("\n");
        double height = y;
        for (String str : arr) {
            g.drawString(str, (float)x, (float)height);
            height = (double)fm.getHeight() + y;
        }
        g.setClip(oldClip);
    }

    private static void drawString(String text, float x, float y, float wordspacing, FontMetrics fm, Graphics2D g) {
        float posX = x;
        int charCount = text.length();
        for (int charIndex = 0; charIndex < charCount; ++charIndex) {
            char aChar = text.charAt(charIndex);
            int charWidth = fm.charWidth(aChar);
            g.drawString(String.valueOf(aChar), posX, y);
            posX = posX + (float)charWidth + wordspacing;
        }
    }

    private static int calculateOffsetX(String text, int startIdx, float wordSpacing, FontMetrics fontMetrics, int width, Styles.HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            return 0;
        }
        float lineWidth = 0.0f;
        int charCount = text.length();
        for (int lineCharIndex = startIdx; lineCharIndex < charCount; ++lineCharIndex) {
            char aChar = text.charAt(lineCharIndex);
            int charWidth = fontMetrics.charWidth(aChar);
            float addWidth = 0.0f;
            if (lineWidth > 0.0f && charWidth > 0) {
                addWidth = wordSpacing;
            }
            if (lineWidth + (addWidth += (float)charWidth) > (float)width || aChar == '\n') break;
            lineWidth += addWidth;
        }
        int offsetX = horizontalAlignment == Styles.HorizontalAlignment.CENTER ? (width - (int)lineWidth) / 2 : width - (int)lineWidth;
        return offsetX;
    }

    private static boolean isTextStyle(Style style) {
        if (style == null) {
            return false;
        }
        String fm = style.getNumberFormat();
        return fm != null && fm.equals("@");
    }

    private static boolean isNumberString(String source) {
        if (StringUtil.isEmptyString(source)) {
            return false;
        }
        String number = source.trim();
        if (StringUtil.isEmptyString(number)) {
            return false;
        }
        if (number.charAt(0) == '(' && number.charAt(number.length() - 1) == ')') {
            if ((number = number.substring(1, number.length() - 1)).length() > 1 && number.charAt(0) != '-') {
                number = "-" + number;
            } else {
                return false;
            }
        }
        if ((number = number.trim()).lastIndexOf(",") == -1) {
            try {
                new BigDecimal(number);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        number = number.replaceAll(",", "");
        try {
            new BigDecimal(number);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int pos0 = number.lastIndexOf(46);
        String sub = number;
        if (pos0 == -1) {
            pos0 = 0;
        } else {
            sub = number.substring(0, pos0);
        }
        char[] chars = sub.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[chars.length - i - 1];
            if (c != ',' || (i + 1) % 4 == 0) continue;
            return false;
        }
        return true;
    }

    private static synchronized void draw(SimpleTextRender render, Graphics g, Shape clip, String text, Style style) {
        render.drawNormal((Graphics2D)g, clip, text, style);
    }
}

