/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.common.util.FontUtil;
import com.kingdee.bos.ctrl.kdf.util.render.view.KDPlainParagraph;
import com.kingdee.bos.ctrl.kdf.util.render.view.TextAreaViewUI;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.View;

public class TextAreaRender {
    private JTextArea area = new JTextArea();
    public static final int UNITSIZE4INDENT = 28;
    protected boolean blackWhite = false;

    public TextAreaRender() {
        this.area.setUI(new TextAreaViewUI());
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
    }

    private Rectangle getPaintBounds(Rectangle rect, Style style, View view) {
        Styles.VerticalAlignment va = style.getVerticalAlign();
        if (va == Styles.VerticalAlignment.TOP) {
            return rect;
        }
        float yspan = view.getPreferredSpan(1);
        if (va == Styles.VerticalAlignment.MIDDLE) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan) / 2.0f);
        } else if (va == Styles.VerticalAlignment.BOTTOM) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan));
        }
        if (Styles.HorizontalAlignment.LEFT.equals(style.getHorizontalAlign())) {
            rect.x += 28 * style.getIndentation();
        }
        return rect;
    }

    private View getView(Rectangle rect, String text, Style style) {
        View view = ((BasicTextAreaUI)this.area.getUI()).getRootView(this.area);
        this.area.setFont(FontUtil.validateFont(text, style.getKDFont().getFont()));
        this.area.setText(text);
        Styles.HorizontalAlignment ha = style.getHorizontalAlign();
        int align = ha == Styles.HorizontalAlignment.CENTER ? 1 : (ha == Styles.HorizontalAlignment.RIGHT ? 2 : 0);
        View boxView = view.getView(0);
        int size = boxView.getViewCount();
        for (int i = 0; i < size; ++i) {
            ((KDPlainParagraph)boxView.getView(i)).setHorizontalAlign(align);
        }
        view.setSize(rect.width, rect.height);
        return view;
    }

    public void draw(Graphics g, Shape clip, String text, Style style) {
        Shape old = g.getClip();
        if (clip != null) {
            Rectangle cr = clip.getBounds();
            g.clipRect(cr.x, cr.y, cr.width, cr.height);
            Rectangle rect = clip.getBounds();
            View view = this.getView(rect, text, style);
            rect = this.getPaintBounds(rect, style, view);
            view.paint(g, rect);
            g.setClip(old);
        }
    }

    public float getPreferredHeight(Graphics g, Shape clip, String text, Style style) {
        return this.getView(clip.getBounds(), text, style).getPreferredSpan(1);
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.blackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.blackWhite;
    }

    public static void main(String[] args) {
    }
}

