/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.formatparser;

import com.kingdee.bos.ctrl.kdf.util.render.formatparser.IParser;
import com.kingdee.bos.ctrl.kdf.util.render.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;

public class HtmlFormatParser
implements IParser {
    private String source;
    private Stack stackTag = new Stack();
    private ArrayList indexStyles;
    private StringBuilder bufSource = new StringBuilder();
    private boolean isTag = false;
    private int pos = 0;
    private int count;
    private Style style;

    public HtmlFormatParser() {
        this.indexStyles = new ArrayList();
    }

    private void prepare() {
        this.source = null;
        this.count = 0;
        this.style = null;
        this.pos = 0;
        this.isTag = false;
        this.stackTag.clear();
        this.bufSource = new StringBuilder();
        this.indexStyles.clear();
    }

    @Override
    public AttributedString parse(String source, Style style) {
        this.prepare();
        this.source = source;
        this.style = style;
        if (null == this.source || this.source.trim().length() == 0) {
            return null;
        }
        return this.buildText();
    }

    private void readTags() {
        Stack<IndexTag> openTags = new Stack<IndexTag>();
        IndexTag tag = null;
        while (this.hasNext()) {
            String sect = this.getNextSect();
            if (this.isTag) {
                tag = new IndexTag(sect, this.count);
                if (tag.isEndTag()) {
                    IndexTag openTag = (IndexTag)openTags.pop();
                    openTag.setEndIndex(tag.getBeginIndex());
                    this.stackTag.push(openTag);
                    continue;
                }
                openTags.push(tag);
                continue;
            }
            this.bufSource.append(sect);
            this.count += sect.length();
        }
        if (!openTags.isEmpty()) {
            throw new HtmlFormatParseException(String.format(ResManager.loadKDString((String)"\u6e90\u6587\u672c\u4e2d\u6709HTML\u8bed\u6cd5\u9519\u8bef\uff0c\u672a\u7ed3\u675f\u6807\u7b7e\u6570\u76ee\uff1a%s\u3002", (String)"HtmlFormatParser_4", (String)"bos-print-engine", (Object[])new Object[0]), openTags.size()));
        }
    }

    private void buildStyles() {
        LinkedList<IndexAttributes> styleList = new LinkedList<IndexAttributes>();
        while (!this.stackTag.isEmpty()) {
            IndexTag tag = (IndexTag)this.stackTag.pop();
            StyleAttributes styleAttris = Styles.getEmptySA();
            if (tag.getTagName().equalsIgnoreCase("font")) {
                String strFace;
                String strColor;
                String strSize = tag.getAttribute("size");
                if (strSize != null && strSize.trim().length() > 0) {
                    try {
                        int iSize = Integer.parseInt(strSize);
                        styleAttris.setFontSize(iSize);
                    }
                    catch (Exception err) {
                        throw new HtmlFormatParseException(ResManager.loadKDString((String)"HTML\u8bed\u6cd5\u9519\u8bef\uff0cFont\u8282\u70b9\u7684size\u5c5e\u6027\u5fc5\u987b\u662f\u6570\u5b57\u3002", (String)"HtmlFormatParser_5", (String)"bos-print-engine", (Object[])new Object[0]), err);
                    }
                }
                if ((strColor = tag.getAttribute("color")) != null && strColor.trim().length() > 0) {
                    styleAttris.setFontColor(this.parseColor(strColor));
                }
                if ((strFace = tag.getAttribute("face")) != null && strFace.trim().length() > 0) {
                    styleAttris.setFontName(strFace.trim());
                }
            } else if (tag.getTagName().equalsIgnoreCase("b")) {
                styleAttris.setBold(true);
            } else if (tag.getTagName().equalsIgnoreCase("i")) {
                styleAttris.setItalic(true);
            } else if (tag.getTagName().equalsIgnoreCase("u")) {
                styleAttris.setUnderline(true);
            } else if (tag.getTagName().equalsIgnoreCase("s")) {
                styleAttris.setStrikeThrough(true);
            } else {
                throw new HtmlFormatParseException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u4e0d\u652f\u6301\u7684\u6807\u7b7e\uff1a%s\u3002", (String)"HtmlFormatParser_6", (String)"bos-print-engine", (Object[])new Object[0]), tag.getTagName()));
            }
            styleList.add(new IndexAttributes(styleAttris, tag.getBeginIndex(), tag.getEndIndex()));
        }
        ArrayList<IndexAttributes> listAttrises = new ArrayList<IndexAttributes>();
        while (!styleList.isEmpty()) {
            IndexAttributes attris = (IndexAttributes)styleList.removeFirst();
            int endIndex = styleList.size();
            int i = 0;
            for (i = 0; i < endIndex; ++i) {
                IndexAttributes tempAttris = (IndexAttributes)styleList.get(i);
                IndexAttributes[] arrayAttris = this.reGroupStyles(attris, tempAttris);
                if (arrayAttris == null) continue;
                for (int j = 0; j < arrayAttris.length; ++j) {
                    if (arrayAttris[j] == null) continue;
                    styleList.addLast(arrayAttris[j]);
                }
                styleList.remove(i);
                break;
            }
            if (i != endIndex) continue;
            listAttrises.add(attris);
        }
        this.addDefaultStyle(listAttrises);
    }

    private void addDefaultStyle(ArrayList listAttrises) {
        Style defStyle = this.style;
        for (int i = 0; i < listAttrises.size(); ++i) {
            IndexAttributes ia = (IndexAttributes)listAttrises.get(i);
            IndexStyle isTemp = new IndexStyle(Styles.getStyle(new ShareStyleAttributes[]{ia.getAttris(), defStyle}), ia.getBeginIndex(), ia.getEndIndex());
            this.indexStyles.add(isTemp);
        }
    }

    private IndexAttributes[] reGroupStyles(IndexAttributes iaMain, IndexAttributes iaNext) {
        IndexAttributes ia;
        if (iaMain.getBeginIndex() >= iaNext.getEndIndex() || iaMain.getEndIndex() <= iaNext.getBeginIndex()) {
            return null;
        }
        IndexAttributes[] attris = new IndexAttributes[3];
        if (iaMain.getEndIndex() >= iaNext.getEndIndex() && iaMain.getBeginIndex() <= iaNext.getBeginIndex()) {
            IndexAttributes temp = iaMain;
            iaMain = iaNext;
            iaNext = temp;
        }
        int newBeginIndex = iaMain.getBeginIndex() > iaNext.getBeginIndex() ? iaMain.getBeginIndex() : iaNext.getBeginIndex();
        int newEndIndex = iaMain.getEndIndex() < iaNext.getEndIndex() ? iaMain.getEndIndex() : iaNext.getEndIndex();
        ShareStyleAttributes sa = Styles.mergeSSA(new ShareStyleAttributes[]{iaMain.getAttris(), iaNext.getAttris()});
        attris[1] = ia = new IndexAttributes(sa, newBeginIndex, newEndIndex);
        if (iaMain.getBeginIndex() < iaNext.getBeginIndex()) {
            if (iaMain.getBeginIndex() < newBeginIndex) {
                attris[0] = new IndexAttributes(iaMain.getAttris(), iaMain.getBeginIndex(), newBeginIndex);
            }
        } else if (iaNext.getBeginIndex() < newBeginIndex) {
            attris[0] = new IndexAttributes(iaNext.getAttris(), iaNext.getBeginIndex(), newBeginIndex);
        }
        if (iaMain.getEndIndex() > iaNext.getEndIndex()) {
            if (iaMain.getEndIndex() > newEndIndex) {
                attris[2] = new IndexAttributes(iaMain.getAttris(), newEndIndex, iaMain.getEndIndex());
            }
        } else if (iaNext.getEndIndex() > newEndIndex) {
            attris[2] = new IndexAttributes(iaNext.getAttris(), newEndIndex, iaNext.getEndIndex());
        }
        return attris;
    }

    private AttributedString buildText() {
        this.readTags();
        if (this.bufSource.length() == 0) {
            return null;
        }
        this.buildStyles();
        AttributedString as = new AttributedString(this.bufSource.toString());
        as.addAttribute(TextAttribute.FONT, this.style.getKDFont());
        if (this.style.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (this.style.isStrikeThrough()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (this.style.getFontColor() != null) {
            as.addAttribute(TextAttribute.FOREGROUND, this.style.getFontColor());
        }
        for (int i = 0; i < this.indexStyles.size(); ++i) {
            IndexStyle is = (IndexStyle)this.indexStyles.get(i);
            if (is.getStyle().isUnderline()) {
                as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, is.getBeginIndex(), is.getEndIndex());
            }
            if (is.getStyle().isStrikeThrough()) {
                as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, is.getBeginIndex(), is.getEndIndex());
            }
            if (is.getStyle().getFontColor() != null) {
                as.addAttribute(TextAttribute.FOREGROUND, is.getStyle().getFontColor(), is.getBeginIndex(), is.getEndIndex());
            }
            as.addAttribute(TextAttribute.FONT, is.getStyle().getKDFont(), is.getBeginIndex(), is.getEndIndex());
        }
        return as;
    }

    private String getNextSect() {
        String strResult;
        this.source = Tools.htmlCode(this.source);
        if (this.source.startsWith("<", this.pos)) {
            this.isTag = true;
            int tagEndIndex = this.source.indexOf(62, this.pos);
            if (tagEndIndex < 0) {
                throw new HtmlFormatParseException(String.format(ResManager.loadKDString((String)"\u53d1\u73b0\u672a\u7ed3\u675f\u7684HTML\u6807\u7b7e\uff0c\u6bb5\u8d77\u59cb\u4f4d\u7f6e\uff1a%s\u3002", (String)"HtmlFormatParser_7", (String)"bos-print-engine", (Object[])new Object[0]), this.pos));
            }
            int tagIndex = this.source.indexOf(60, this.pos + 1);
            if (tagIndex > 0 && tagEndIndex >= tagIndex) {
                throw new HtmlFormatParseException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6e90\u5b57\u7b26\u4e32\u4e2d\u6709HTML\u8bed\u6cd5\u9519\u8bef\uff0c\u6bb5\u8d77\u59cb\u4f4d\u7f6e\u4e3a\uff1a%s\u3002", (String)"HtmlFormatParser_8", (String)"bos-print-engine", (Object[])new Object[0]), this.pos));
            }
            strResult = this.source.substring(this.pos + 1, tagEndIndex);
            this.pos = tagEndIndex + 1;
        } else {
            int endTagIndex;
            this.isTag = false;
            int endIndex = this.source.indexOf(60, this.pos);
            if (endIndex < 0) {
                endIndex = this.source.length();
            }
            if ((endTagIndex = this.source.indexOf(62, this.pos)) >= 0 && endTagIndex <= endIndex) {
                throw new HtmlFormatParseException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6e90\u5b57\u7b26\u4e32\u4e2d\u6709HTML\u8bed\u6cd5\u9519\u8bef\uff0c\u6bb5\u8d77\u59cb\u4f4d\u7f6e\u4e3a\uff1a%s\u3002", (String)"HtmlFormatParser_8", (String)"bos-print-engine", (Object[])new Object[0]), this.pos));
            }
            strResult = this.source.substring(this.pos, endIndex);
            strResult = Tools.htmlDecode(strResult);
            this.pos = endIndex;
        }
        return strResult;
    }

    private boolean hasNext() {
        return this.pos < this.source.length();
    }

    private Color parseColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
        }
        catch (Exception err) {
            throw new HtmlFormatParseException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99", (String)"HtmlFormatParser_9", (String)"bos-print-engine", (Object[])new Object[0]), err);
        }
        return color;
    }

    public static final class HtmlFormatParseException
    extends RuntimeException {
        private static final long serialVersionUID = -906990374015580427L;

        public HtmlFormatParseException() {
        }

        public HtmlFormatParseException(String message) {
            super(message);
        }

        public HtmlFormatParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public HtmlFormatParseException(Throwable cause) {
            super(cause);
        }
    }

    static final class IndexAttributes {
        private ShareStyleAttributes attris;
        private int beginIndex;
        private int endIndex;

        public IndexAttributes(ShareStyleAttributes attris, int iBegin, int iEnd) {
            this.attris = attris;
            this.beginIndex = iBegin;
            this.endIndex = iEnd;
        }

        public ShareStyleAttributes getAttris() {
            return this.attris;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setBeginIndex(int i) {
            this.beginIndex = i;
        }

        public void setEndIndex(int i) {
            this.endIndex = i;
        }

        public void setAttris(ShareStyleAttributes attributes) {
            this.attris = attributes;
        }
    }

    static final class IndexStyle {
        private Style style;
        private int beginIndex;
        private int endIndex;

        public IndexStyle(Style style, int iBegin, int iEnd) {
            this.style = style;
            this.beginIndex = iBegin;
            this.endIndex = iEnd;
        }

        public IndexStyle(IndexAttributes ia) {
            this.beginIndex = ia.getBeginIndex();
            this.endIndex = ia.getEndIndex();
            this.style = Styles.getStyle(new ShareStyleAttributes[]{ia.getAttris()});
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public Style getStyle() {
            return this.style;
        }
    }

    static final class IndexTag {
        private String strTag;
        private int beginIndex = -1;
        private int endIndex = -1;

        public IndexTag(String tag, int iPos) {
            this.strTag = tag.trim();
            this.beginIndex = iPos;
        }

        public String getTagName() {
            if (this.isEndTag()) {
                return this.strTag.substring(1).toLowerCase(Locale.getDefault());
            }
            int nameEnd = this.strTag.indexOf(" ");
            if (nameEnd < 0) {
                nameEnd = this.strTag.length();
            }
            return this.strTag.substring(0, nameEnd).toLowerCase(Locale.getDefault());
        }

        public String getAttribute(String item) {
            String strResult = null;
            int itemPos = this.strTag.indexOf(item + "=");
            if (itemPos > 0) {
                int beginIndex = this.strTag.indexOf("=", itemPos) + 1;
                int endIndex = this.strTag.indexOf(" ", beginIndex + 1);
                if (endIndex < 0) {
                    endIndex = this.strTag.length();
                }
                if ((strResult = this.strTag.substring(beginIndex, endIndex)).startsWith("\"") || strResult.startsWith("'")) {
                    strResult = strResult.substring(1, strResult.length() - 1);
                }
            }
            return strResult;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        public String getStrTag() {
            return this.strTag;
        }

        public boolean isEndTag() {
            return this.strTag.startsWith("/");
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public void setEndIndex(int i) {
            this.endIndex = i;
        }

        public void setBeginIndex(int i) {
            this.beginIndex = i;
        }
    }
}

