/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.layout;

import com.kingdee.bos.ctrl.kdf.util.render.TextDetail;
import com.kingdee.bos.ctrl.kdf.util.render.exception.LayoutException;
import com.kingdee.bos.ctrl.kdf.util.render.layout.AbstractCellLayout;
import com.kingdee.bos.ctrl.kdf.util.render.layout.CellTextArea;
import com.kingdee.bos.ctrl.kdf.util.render.layout.IRowBreaker;
import com.kingdee.bos.ctrl.kdf.util.render.layout.ISureRow;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureRow;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureTextLayout;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureTextLine;
import com.kingdee.bos.ctrl.kdf.util.render.layout.TextLayoutBreaker;
import com.kingdee.bos.ctrl.kdf.util.render.layout.TextLineBreaker;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

public final class CommonLayout
extends AbstractCellLayout {
    private CellTextArea textArea;
    private IRowBreaker lbm;
    private double clipWidth;
    private double clipHeight;
    private double clipX;
    private double clipY;

    @Override
    public void draw(Graphics2D g2d, Shape clip, TextDetail cell) throws LayoutException, NullPointerException {
        if (null == clip) {
            throw new NullPointerException("Undefined clip area");
        }
        if (!(clip instanceof Rectangle2D)) {
            throw new LayoutException("Only rectangle clip area is supported");
        }
        if (null == cell) {
            throw new NullPointerException("Undefined CellDetail object");
        }
        this.clip = clip;
        this.acell = cell;
        this.g2d = g2d;
        FontRenderContext frc = g2d.getFontRenderContext();
        this.clipWidth = clip.getBounds2D().getWidth();
        this.clipHeight = clip.getBounds2D().getHeight();
        this.clipX = clip.getBounds2D().getMinX();
        this.clipY = clip.getBounds2D().getMinY();
        this.textArea = new CellTextArea(this.clip, cell.getCellStyle());
        if (cell.getText() != null) {
            this.lbm = new TextLayoutBreaker(this.acell.getText(), frc);
        } else if (cell.getSource() != null) {
            Font font = this.acell.getCellStyle().getFont();
            this.lbm = new TextLineBreaker(this.acell.getSource(), font, frc);
            g2d.setFont(font);
            g2d.setPaint(this.acell.getCellStyle().getFontColor());
        } else {
            throw new LayoutException("No content to show");
        }
        this.textArea.setRotate(this.acell.getRotate());
        this.buildTextArea(frc);
        this.textArea.draw(g2d);
    }

    public void buildTextArea(FontRenderContext frc) {
        if (this.acell.isAutoShrink()) {
            this.drawShrink(frc);
        } else {
            this.drawNoShrink(frc);
        }
        this.applyAlign();
    }

    private double getBaseLineLength(FontRenderContext frc) {
        SureRow sr;
        if (this.acell.getText() != null) {
            sr = new SureTextLayout(null, new TextLayout(this.acell.getText().getIterator(), frc));
        } else if (this.acell.getSource() != null) {
            Font font = this.acell.getCellStyle().getFont();
            sr = new SureTextLine(this.acell.getSource(), font, frc);
        } else {
            throw new LayoutException("No content to show");
        }
        if (!this.acell.isAutoWrap() && !this.acell.isAutoShrink()) {
            return sr.getAdvance() + 100.0;
        }
        double length = this.getClipedLineLength();
        double angel = Math.abs(this.acell.getRotate());
        double rectAngel = Math.atan(this.clipHeight / this.clipWidth);
        length = (angel = Math.PI * angel / 180.0) > rectAngel ? (length -= (sr.getAscent() + sr.getDescent()) / Math.tan(angel)) : (length -= (sr.getAscent() + sr.getDescent()) * Math.tan(angel));
        if (length <= 0.0) {
            length = this.getClipedLineLength();
        }
        return length;
    }

    private double getClipedLineLength() {
        double length = 0.0;
        double angel = Math.abs(this.acell.getRotate());
        length = Math.tan(angel = Math.PI * angel / 180.0) < this.clipHeight / this.clipWidth ? this.clipWidth / Math.cos(angel) : this.clipHeight / Math.sin(angel);
        return length;
    }

    private void drawNoShrink(FontRenderContext frc) {
        double lineLong = this.getClipedLineLength();
        double baseLength = this.getBaseLineLength(frc);
        double angel = Math.abs(this.acell.getRotate());
        angel = Math.PI * angel / 180.0;
        SureRow tl = null;
        ISureRow tlast = null;
        double bx = -1.0;
        double by = -1.0;
        double lx = -1.0;
        double ly = -1.0;
        if (this.acell.getRotate() >= 0) {
            if (angel > Math.atan(this.clipHeight / this.clipWidth)) {
                bx = this.clipX + this.clipWidth - Math.sqrt(lineLong * lineLong - this.clipHeight * this.clipHeight);
                by = this.clipY;
                while (this.lbm.hasNext()) {
                    tl = this.lbm.nextRow((int)baseLength);
                    if (tl == null) continue;
                    if (tlast != null) {
                        bx = lx - (tlast.getDescent() + tl.getAscent() + (double)this.acell.getLineSpace()) / Math.sin(angel);
                        by = ly;
                    } else {
                        if ((bx -= tl.getAscent() * Math.sin(angel)) < this.clipX + tl.getDescent() * Math.sin(angel)) {
                            bx = this.clipX + tl.getDescent() * Math.sin(angel);
                        }
                        by += tl.getAscent() * Math.cos(angel);
                    }
                    tl.setX(bx);
                    tl.setY(by);
                    this.textArea.addRow(tl);
                    lx = bx;
                    ly = by;
                    tlast = tl;
                }
            } else {
                bx = this.clipX;
                by = this.clipY;
                while (this.lbm.hasNext()) {
                    tl = this.lbm.nextRow((int)baseLength);
                    if (tlast != null) {
                        bx = lx;
                        by = ly + (tl.getAscent() + tlast.getDescent() + (double)this.acell.getLineSpace()) * Math.cos(angel);
                    } else {
                        bx += tl.getDescent() * Math.sin(angel);
                        by += tl.getAscent() * Math.cos(angel);
                    }
                    tl.setX(bx);
                    tl.setY(by);
                    this.textArea.addRow(tl);
                    lx = bx;
                    ly = by;
                    tlast = tl;
                    tl = null;
                }
            }
        } else if (angel >= Math.atan(this.clipHeight / this.clipWidth)) {
            bx = this.clipX;
            by = this.clipY + this.clipHeight;
            while (this.lbm.hasNext()) {
                tl = this.lbm.nextRow((int)baseLength);
                if (tlast != null) {
                    bx = lx + (tl.getAscent() + tlast.getDescent() + (double)this.acell.getLineSpace()) / Math.sin(angel);
                    by = ly;
                } else {
                    bx += tl.getAscent() * Math.sin(angel);
                    by -= tl.getDescent() * Math.cos(angel);
                }
                tl.setX(bx);
                tl.setY(by);
                this.textArea.addRow(tl);
                lx = bx;
                ly = by;
                tlast = tl;
                tl = null;
            }
        } else {
            bx = this.clipX;
            by = this.clipY + Math.sqrt(lineLong * lineLong - this.clipWidth * this.clipWidth);
            while (this.lbm.hasNext()) {
                tl = this.lbm.nextRow((int)baseLength);
                if (tlast != null) {
                    by = ly + (tl.getAscent() + tlast.getDescent() + (double)this.acell.getLineSpace()) / Math.cos(angel);
                } else {
                    bx += tl.getAscent() * Math.sin(angel);
                    if ((by += tl.getAscent() * Math.cos(angel)) > this.clipY + this.clipHeight - tl.getDescent() * Math.cos(angel)) {
                        by = this.clipY + this.clipHeight - tl.getDescent() * Math.cos(angel);
                    }
                }
                tl.setX(bx);
                tl.setY(by);
                this.textArea.addRow(tl);
                lx = bx;
                ly = by;
                tlast = tl;
                tl = null;
            }
        }
    }

    private void drawShrink(FontRenderContext frc) {
        SureRow tl;
        double angel = Math.abs(this.acell.getRotate());
        angel = Math.PI * angel / 180.0;
        if (this.acell.getText() != null) {
            tl = new SureTextLayout(this.acell.getText(), new TextLayout(this.acell.getText().getIterator(), frc));
        } else if (this.acell.getSource() != null) {
            tl = new SureTextLine(this.acell.getSource(), this.acell.getCellStyle().getFont(), frc);
        } else {
            throw new LayoutException("No content found");
        }
        double fLong = tl.getAdvance();
        double fAimLong = this.getBaseLineLength(frc);
        double rate = 0.0;
        rate = fAimLong >= fLong ? 1.0 : fAimLong / fLong;
        double bx = this.clipX;
        double by = this.clipY;
        if (this.acell.getRotate() < 0) {
            by += this.clipHeight;
            by -= tl.getDescent() * Math.cos(angel);
            bx += tl.getAscent() * Math.sin(angel);
        } else {
            bx += tl.getDescent() * Math.sin(angel);
            by += tl.getAscent() * Math.cos(angel);
        }
        tl.setX((float)bx);
        tl.setY((float)by);
        this.textArea.addRow(tl);
        this.textArea.setShrinkRate(rate);
    }

    private void applyAlign() {
        if (this.textArea.getRows().size() == 0) {
            return;
        }
        double angel = Math.PI * (double)this.acell.getRotate() / 180.0;
        double rectAngel = Math.atan(this.clipHeight / this.clipWidth);
        this.applyHAlign(angel, rectAngel);
        this.applyVAlign(angel, rectAngel);
    }

    private void applyVAlign(double angel, double rectAngel) {
        block6: {
            block7: {
                block5: {
                    if (this.acell.getVAlign() != Styles.VerticalAlignment.TOP) break block5;
                    double minY = this.textArea.getMinY();
                    this.textArea.moveAllY(this.clipY - minY);
                    if (!(Math.abs(angel) > rectAngel)) break block6;
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double minLineY = this.textArea.getLineMinY(i);
                        this.textArea.moveLineY(i, this.clipY - minLineY);
                    }
                    break block6;
                }
                if (this.acell.getVAlign() != Styles.VerticalAlignment.MIDDLE) break block7;
                double minY = this.textArea.getMinY();
                double maxY = this.textArea.getMaxY();
                this.textArea.moveAllY((this.clipY + this.clipHeight - maxY - minY + this.clipY) / 2.0);
                if (!(Math.abs(angel) > rectAngel)) break block6;
                for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                    double maxLineY = this.textArea.getLineMaxY(i);
                    double minLineY = this.textArea.getLineMinY(i);
                    this.textArea.moveLineY(i, (this.clipY + this.clipHeight - maxLineY - minLineY + this.clipY) / 2.0);
                }
                break block6;
            }
            if (this.acell.getVAlign() == Styles.VerticalAlignment.BOTTOM) {
                double maxY = this.textArea.getMaxY();
                this.textArea.moveAllY(this.clipY + this.clipHeight - maxY);
                if (Math.abs(angel) > rectAngel) {
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double maxLineY = this.textArea.getLineMaxY(i);
                        this.textArea.moveLineY(i, this.clipY + this.clipHeight - maxLineY);
                    }
                }
            }
        }
    }

    private void applyHAlign(double angel, double rectAngel) {
        block5: {
            block4: {
                if (this.acell.getHAlign() != Styles.HorizontalAlignment.CENTER) break block4;
                double minX = this.textArea.getMinX();
                double maxX = this.textArea.getMaxX();
                this.textArea.moveAllX((this.clipX + this.clipWidth - maxX - minX + this.clipX) / 2.0);
                if (!(Math.abs(angel) < rectAngel)) break block5;
                for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                    double maxLineX = this.textArea.getLineMaxX(i);
                    double minLineX = this.textArea.getLineMinX(i);
                    this.textArea.moveLineX(i, (this.clipX + this.clipWidth - maxLineX - minLineX + this.clipX) / 2.0);
                }
                break block5;
            }
            if (this.acell.getHAlign() == Styles.HorizontalAlignment.RIGHT) {
                double maxX = this.textArea.getMaxX();
                this.textArea.moveAllX(this.clipX + this.clipWidth - maxX);
                if (Math.abs(angel) < rectAngel) {
                    for (int i = this.textArea.getRows().size() - 1; i >= 0; --i) {
                        double maxLineX = this.textArea.getLineMaxX(i);
                        this.textArea.moveLineX(i, this.clipX + this.clipWidth - maxLineX);
                    }
                }
            }
        }
    }
}

