/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.layout;

import com.kingdee.bos.ctrl.kdf.util.render.layout.StandardUnderline;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureRow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.SwingUtilities;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

public final class SureTextLayout
extends SureRow {
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private TextLayout text;
    private AttributedString attributedString;

    public SureTextLayout(AttributedString as, TextLayout text, Point2D.Double point) {
        this.attributedString = as;
        this.text = text;
        this.point = point;
    }

    public SureTextLayout(AttributedString as, TextLayout text, int x, int y) {
        this.attributedString = as;
        this.text = text;
        this.point = new Point2D.Double(x, y);
    }

    public SureTextLayout(AttributedString as, TextLayout text) {
        this(as, text, 0, 0);
    }

    public TextLayout getText() {
        return this.text;
    }

    @Override
    public double getAdvance() {
        return this.getText().getAdvance();
    }

    @Override
    public double getDescent() {
        return this.getText().getDescent();
    }

    @Override
    public double getAscent() {
        return this.getText().getAscent();
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (this.attributedString == null) {
            this.getText().draw(g2d, (float)this.getPoint().x, (float)this.getPoint().y);
        } else {
            StringBuilder sb = new StringBuilder();
            AttributedCharacterIterator aci = this.attributedString.getIterator();
            Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
            Color pt = (Color)aci.getAttribute(TextAttribute.FOREGROUND);
            boolean strikethrough = aci.getAttribute(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON;
            boolean underLine = aci.getAttribute(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
            for (int i = 0; i < aci.getEndIndex(); ++i) {
                sb.append(aci.current());
                aci.next();
            }
            String str = sb.toString();
            Font ftOld = g2d.getFont();
            Paint ptOld = g2d.getPaint();
            if (ft != null) {
                g2d.setFont(ft);
            }
            if (pt != null) {
                g2d.setColor(pt);
            }
            float x = (float)this.getPoint().x;
            float y = (float)this.getPoint().y;
            g2d.drawString(str, x, y);
            if (strikethrough || underLine) {
                int tWidth = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), str);
                float x1 = x;
                float x2 = x1 + (float)tWidth;
                if (ft == null) {
                    throw new KDException(new ErrorCode("print-exception", ResManager.loadKDString((String)"\u5b57\u4f53\u4e3a\u7a7a\u3002", (String)"SureTextLayout_0", (String)BOS_PRINT_ENGINE, (Object[])new Object[0])), new Object[0]);
                }
                LineMetrics lineMetrics = ft.getLineMetrics(str, g2d.getFontRenderContext());
                if (strikethrough) {
                    Stroke saveStroke = g2d.getStroke();
                    float strikeY = y + lineMetrics.getStrikethroughOffset();
                    g2d.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                    g2d.draw(new Line2D.Float(x1, strikeY, x2, strikeY));
                    g2d.setStroke(saveStroke);
                }
                if (underLine) {
                    float ulOffset = lineMetrics.getUnderlineOffset();
                    float ulThickness = lineMetrics.getUnderlineThickness();
                    StandardUnderline.DefaultUnderline.drawUnderline(g2d, ulThickness, x1, x2, y + ulOffset);
                }
            }
            g2d.setFont(ftOld);
            g2d.setPaint(ptOld);
        }
    }
}

