/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.layout;

import com.kingdee.bos.ctrl.kdf.util.render.exception.LayoutException;
import com.kingdee.bos.ctrl.kdf.util.render.layout.IRowBreaker;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureRow;
import com.kingdee.bos.ctrl.kdf.util.render.layout.SureTextLayout;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextLayoutBreaker
implements IRowBreaker {
    private String source;
    private char[] chars;
    private TextMeasurer measurer;
    private AttributedString text;
    private int pos;
    private float lineLength;
    private FontRenderContext frc;

    public TextLayoutBreaker(AttributedString text, FontRenderContext frc) {
        this(text, frc, 100);
    }

    public TextLayoutBreaker(AttributedString text, FontRenderContext frc, int lineLength) {
        this.frc = frc;
        this.text = text;
        this.measurer = new TextMeasurer(this.text.getIterator(), this.frc);
        this.setPos(0);
        this.setLineLength(lineLength);
        StringBuilder sb = new StringBuilder();
        AttributedCharacterIterator aci = this.text.getIterator();
        for (int i = 0; i < aci.getEndIndex(); ++i) {
            sb.append(aci.current());
            aci.next();
        }
        this.source = sb.toString();
        this.chars = this.source.toCharArray();
    }

    public AttributedString getText() {
        return this.text;
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos < 0 || pos > this.text.getIterator().getEndIndex()) {
            throw new IllegalArgumentException("Position is out of range.");
        }
        this.pos = pos;
    }

    public float getLineLength() {
        return this.lineLength;
    }

    @Override
    public void setLineLength(float length) {
        this.lineLength = length;
    }

    @Override
    public SureRow nextRow(float length) {
        AttributedString as;
        TextLayout result = null;
        int endIndex = 0;
        try {
            endIndex = this.measurer.getLineBreakIndex(this.pos, length);
            if (endIndex <= this.pos) {
                endIndex = this.pos + 1;
            }
            if (this.isInWord(endIndex)) {
                endIndex = this.getPreWordBreak(endIndex);
            }
            endIndex = this.checkForWrap(endIndex);
            result = this.measurer.getLayout(this.pos, endIndex);
            as = new AttributedString(this.text.getIterator(), this.pos, endIndex);
        }
        catch (Exception err) {
            throw new LayoutException("Line wrap error:baseline is too short", err);
        }
        this.pos = endIndex;
        return new SureTextLayout(as, result);
    }

    private int checkForWrap(int endIndex) {
        for (int i = this.pos; i < endIndex; ++i) {
            if (this.chars[i] != '\n') continue;
            return i + 1;
        }
        return endIndex;
    }

    private int getPreWordBreak(int fromIndex) {
        int i = fromIndex - 1;
        while ((long)i > this.getPos()) {
            if (!this.isInWord(i)) {
                return i;
            }
            --i;
        }
        return fromIndex;
    }

    private boolean isInWord(int index) {
        if (index <= 0 || index >= this.source.length()) {
            return false;
        }
        char c = this.chars[index];
        if (c < '0' || c > '9' && c < '@' || c > 'z') {
            return false;
        }
        c = this.chars[index - 1];
        return c >= '0' && (c <= '9' || c >= '@') && c <= 'z';
    }

    @Override
    public SureRow nextRow() {
        return this.nextRow(this.lineLength);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.text.getIterator().getEndIndex();
    }
}

