/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.r1print;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.NoteTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.layout.StandardUnderline;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ComplexTextRenderer {
    private static final Log log = LogFactory.getLog(ComplexTextRenderer.class);
    private NoteTextRender _noteTextRender;

    public ComplexTextRenderer() {
    }

    public ComplexTextRenderer(NoteTextRender noteTextRender) {
        this._noteTextRender = noteTextRender;
    }

    private NoteTextRender getNoteTextRender() {
        if (this._noteTextRender == null) {
            this._noteTextRender = NoteTextRender.shareInstance();
        }
        NoteTextRender noteTextRender = new NoteTextRender();
        return noteTextRender;
    }

    private static boolean isShrinkWrap(Style style) {
        return style.isWrapText() && style.isShrinkText();
    }

    public void draw(Graphics g, Shape clip, Object object, Style style) {
        String text = this.object2String(object);
        if (StringUtil.isEmptyString(text)) {
            return;
        }
        if (ComplexTextRenderer.isShrinkWrap(style)) {
            Rectangle rect = clip.getBounds();
            if (rect.width <= 0 || rect.height <= 0) {
                return;
            }
            DrawingInfo info = this.thickAdjust((Graphics2D)g, text, rect.width, rect.height, style);
            int yOffset = this.thinAdjust((Graphics2D)g, rect, info, style);
            this.drawing((Graphics2D)g, rect, info, style, yOffset);
        } else {
            this.getNoteTextRender().draw(g, clip, object, style);
        }
    }

    private String object2String(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static float estimateAvgCharWidth(String text, Font font, float wordSpacing) {
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        float width = fm.stringWidth(text);
        return width / (float)text.length() + wordSpacing;
    }

    private static float calculateLineHeight(String text, Font font, float lineSpacing, Graphics2D g2d) {
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        return lm.getHeight() + lineSpacing;
    }

    private static Font createFont(Style style, int fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return KDFont.loadFontFromJAR(style.getFontName(), boldAndItalic += style.isItalic() ? 2 : 0, fontSize);
    }

    private static int getOriSize(Style style) {
        return style.getKDFont().getSize();
    }

    private DrawingInfo thickAdjust(Graphics2D g2d, String text, int width, int height, Style style) {
        float lineHeight;
        float wordSpacing = style.getWordspacing();
        float lineSpacing = style.getLinespacing();
        int fontSize = ComplexTextRenderer.getOriSize(style);
        while (true) {
            float rate;
            if (fontSize <= 0) {
                return DrawingInfo.create(text, 0, 0.0f, 0.0f, 0.0f);
            }
            Font font = ComplexTextRenderer.createFont(style, fontSize);
            float avgCharWidth = ComplexTextRenderer.estimateAvgCharWidth(text, font, wordSpacing);
            if ((float)width < avgCharWidth) {
                rate = (float)width / avgCharWidth;
                fontSize = (int)((float)fontSize * rate);
                log.debug("\u5bbd\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize);
                continue;
            }
            lineHeight = ComplexTextRenderer.calculateLineHeight(text, font, lineSpacing, g2d);
            if ((float)height < lineHeight) {
                rate = (float)height / lineHeight;
                fontSize = (int)((float)fontSize * rate);
                log.debug("\u9ad8\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize);
                continue;
            }
            float lineCount = (float)height / lineHeight;
            int acceptedCharCount = (int)((float)width / avgCharWidth * lineCount);
            if (acceptedCharCount >= text.length()) break;
            fontSize = (int)((double)fontSize * Math.sqrt((float)acceptedCharCount / (float)text.length()));
            log.debug("\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize);
        }
        return DrawingInfo.create(text, fontSize, lineHeight, wordSpacing, lineSpacing);
    }

    private int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style) {
        String text = info.getText();
        CalculateExtend ce = new CalculateExtend(g2d);
        int testTimes = 0;
        boolean toTry = true;
        while (toTry) {
            log.debug("\u8bd5\u63a2\u7b2c" + ++testTimes + "\u6b21\uff0c\u5b57\u53f7\uff1a" + info.getFontSize());
            Font font = ComplexTextRenderer.createFont(style, info.getFontSize());
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
            ce.setOnceMore(false);
            ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ce);
            toTry = ce.isOnceMore();
        }
        int offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0 : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (rect.height - ce.getUsedHeight()) / 2 - 1 : rect.height - ce.getUsedHeight() - 2);
        return offsetY;
    }

    private void drawing(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, int yOffset) {
        String text = info.getText();
        Graphics2D newGraphics = (Graphics2D)g2d.create(rect.x, rect.y + yOffset, rect.width, rect.height - yOffset);
        newGraphics.setFont(ComplexTextRenderer.createFont(style, info.getFontSize()));
        newGraphics.setColor(style.getFontColor());
        DrawingExtend ext = new DrawingExtend(newGraphics);
        Font font = ComplexTextRenderer.createFont(style, info.getFontSize());
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        try {
            ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ext);
        }
        catch (Exception e) {
            log.warn("\u5728ComplexTextRender\u4e2d\u7ed8\u5236\u5b57\u7b26" + text + "   " + e);
        }
    }

    private static void throughStringAtRect(String text, DrawingInfo info, Style style, int width, int height, FontMetrics fontMetrics, LineMetrics lineMetrics, IThroughStringAtRect ext) {
        int offsetX = ComplexTextRenderer.calculateOffsetX(text, 0, info, fontMetrics, width, style.getHorizontalAlign());
        float x = 0.0f;
        float y = lineMetrics.getAscent();
        StringBuilder sb = new StringBuilder();
        int sumChar = 0;
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int ii = 0; ii < text.length() - 1; ++ii) {
            char aChar = text.charAt(ii);
            sb.append(aChar);
            int p = 0;
            if ((sumChar += fontMetrics.charWidth(aChar)) <= width) continue;
            if (String.valueOf(text.charAt(ii)).matches("[a-zA-Z]") && String.valueOf(text.charAt(ii + 1)).matches("[a-zA-Z]")) {
                p = sb.toString().lastIndexOf(" ");
                if (p == -1) {
                    sumChar = 12;
                    continue;
                }
                for (int jjj = 0; jjj < sb.toString().substring(p).length(); ++jjj) {
                    if (!String.valueOf(sb.toString().substring(p).charAt(jjj)).matches("[\\u4e00-\\u9fa5]")) continue;
                    p = ii;
                    break;
                }
                int offset = 0;
                for (int iii = 0; iii < sb.toString().substring(p).length(); ++iii) {
                    offset += fontMetrics.charWidth(sb.toString().substring(p).charAt(iii));
                }
                if (!Character.isWhitespace(text.charAt(p))) continue;
                map.put(p, sumChar);
                sumChar = 12;
                continue;
            }
            sumChar = 12;
        }
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char aChar = text.charAt(i);
            float tempX = 0.0f;
            int nextRowStart = i;
            int charWidth = fontMetrics.charWidth(aChar);
            if (charWidth == 0) {
                tempX = aChar == '\n' ? (float)(width + 1) : x;
                ++nextRowStart;
            } else if (map.get(i) != null) {
                tempX = width + 1;
                ++nextRowStart;
                charWidth = 0;
            } else {
                tempX = x + (float)charWidth;
            }
            if (tempX > (float)width) {
                offsetX = ComplexTextRenderer.calculateOffsetX(text, nextRowStart, info, fontMetrics, width, style.getHorizontalAlign());
                x = 0.0f;
                tempX = charWidth;
                if ((y += info.getLineHeight()) + lineMetrics.getDescent() > (float)height || tempX > (float)width) {
                    ext.dealOutSideRect(text, info, style, height, i);
                    return;
                }
            }
            ext.dealAChar(x + (float)offsetX, y, aChar, charWidth);
            if (ext instanceof DrawingExtend && style.isUnderline()) {
                float ulOffset = lineMetrics.getUnderlineOffset();
                float ulThickness = lineMetrics.getUnderlineThickness();
                StandardUnderline.DefaultUnderline.drawUnderline(ext.getGraphics2D(), ulThickness, x + (float)offsetX, x + (float)offsetX + (float)charWidth, y + ulOffset);
            }
            if (charWidth <= 0) continue;
            x = tempX + info.getWordSpacing();
        }
        ext.dealThroughEnd(text, info, style, height, y, lineMetrics);
    }

    private static int calculateOffsetX(String text, int startIdx, DrawingInfo info, FontMetrics fontMetrics, int width, Styles.HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            return 0;
        }
        float lineWidth = 0.0f;
        int charCount = text.length();
        for (int lineCharIndex = startIdx; lineCharIndex < charCount; ++lineCharIndex) {
            char aChar = text.charAt(lineCharIndex);
            int charWidth = fontMetrics.charWidth(aChar);
            float addWidth = 0.0f;
            if (lineWidth > 0.0f && charWidth > 0) {
                addWidth = info.getWordSpacing();
            }
            if (lineWidth + (addWidth += (float)charWidth) > (float)width || aChar == '\n') break;
            lineWidth += addWidth;
        }
        int offsetX = horizontalAlignment == Styles.HorizontalAlignment.CENTER ? (width - (int)lineWidth) / 2 : width - (int)lineWidth;
        return offsetX;
    }

    static class DrawingExtend
    implements IThroughStringAtRect {
        private Graphics2D g2d;

        public DrawingExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
            if (charWidth > 0) {
                this.g2d.drawString(String.valueOf(aChar), x, y);
            }
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
        }
    }

    static class CalculateExtend
    implements IThroughStringAtRect {
        private boolean onceMore;
        private Graphics2D g2d;
        private int cacheFitSize = -1;
        private int cacheMinTooBigSize = Integer.MAX_VALUE;
        private int cacheFitYEnd = 0;

        public CalculateExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public Graphics2D getGraphics2D() {
            return this.g2d;
        }

        public void setOnceMore(boolean is) {
            this.onceMore = is;
        }

        public boolean isOnceMore() {
            return this.onceMore;
        }

        public int getUsedHeight() {
            return this.cacheFitYEnd;
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
            if (info.getFontSize() < this.cacheMinTooBigSize) {
                this.cacheMinTooBigSize = info.getFontSize();
            }
            int newSize = (int)((double)info.getFontSize() * Math.sqrt((float)throughingTextIdx / (float)text.length()));
            info.updateFontSize(newSize, style, height, this.g2d);
            if (newSize > this.cacheFitSize && newSize < this.cacheMinTooBigSize) {
                this.onceMore = true;
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u5c0f\u5c0f\u5c0f\u5230" + newSize);
            } else {
                log.debug("\u7a7a\u95f4\u4e0d\u591f\uff0c\u4f46\u6ca1\u5fc5\u8981\u518d\u5c0f\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
            }
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
            float y = yEnd + lm.getDescent();
            if (info.getFontSize() > this.cacheFitSize) {
                log.debug("\u7f13\u5b58\u5408\u9002\u5b57\u53f7\u53ca\u7ed8\u5236\u72b6\u6001: " + this.cacheFitSize + " => " + info.getFontSize());
                this.cacheFitSize = info.getFontSize();
                this.cacheFitYEnd = (int)y + 1;
            }
            if (info.getFontSize() > 0 && info.getFontSize() < ComplexTextRenderer.getOriSize(style)) {
                float spaceUsedRate = y / (float)height;
                log.debug("\u7a7a\u95f4\u5360\u7528\u7387\uff1a" + spaceUsedRate);
                if ((double)spaceUsedRate < 0.9) {
                    int newSize = (int)((double)info.getFontSize() * Math.sqrt(1.0f / spaceUsedRate) + 0.5);
                    if (newSize <= this.cacheFitSize) {
                        log.debug("\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                    } else if (newSize <= ComplexTextRenderer.getOriSize(style)) {
                        if (newSize >= this.cacheMinTooBigSize) {
                            log.debug("\u5df2\u77e5\u6700\u5c0f\u7684\u592a\u5927\u5b57\u53f7" + this.cacheMinTooBigSize + "\u3002\u6ca1\u5fc5\u8981\u518d\u5927\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize);
                        } else {
                            info.updateFontSize(newSize, style, height, this.g2d);
                            this.onceMore = true;
                            log.debug("\u5927\u5927\u5927\u5230" + newSize);
                        }
                    } else {
                        log.debug("\u65b0\u5b57\u53f7" + newSize + "\u4e0d\u80fd\u5927\u4e8e\u539f\u59cb\u5b57\u53f7" + ComplexTextRenderer.getOriSize(style));
                    }
                }
            }
        }
    }

    static interface IThroughStringAtRect {
        public void dealAChar(float var1, float var2, char var3, int var4);

        public void dealOutSideRect(String var1, DrawingInfo var2, Style var3, int var4, int var5);

        public void dealThroughEnd(String var1, DrawingInfo var2, Style var3, int var4, float var5, LineMetrics var6);

        public Graphics2D getGraphics2D();
    }

    private static class DrawingInfo {
        private String text;
        private int fontSize;
        private float lineHeight;
        private float wordSpacing;
        private float lineSpacing;

        private DrawingInfo(String text) {
            this.text = text;
        }

        public static DrawingInfo create(String text, int fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            DrawingInfo info = new DrawingInfo(text);
            info.fontSize = fontSize;
            info.lineHeight = lineHeight;
            info.wordSpacing = wordSpacing;
            info.lineSpacing = lineSpacing;
            return info;
        }

        public final String getText() {
            return this.text;
        }

        public final float getLineHeight() {
            return this.lineHeight;
        }

        public final int getFontSize() {
            return this.fontSize;
        }

        public final float getWordSpacing() {
            return this.wordSpacing;
        }

        public final float getLineSpacing() {
            return this.lineSpacing;
        }

        public final void updateFontSize(int fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.fontSize = fontSize;
            this.lineHeight = ComplexTextRenderer.calculateLineHeight(this.text, ComplexTextRenderer.createFont(style, fontSize), this.lineSpacing, g2d);
        }
    }
}

