/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.SplitRectInfo;
import java.util.Arrays;

public abstract class AbstractTableSplitRectInfo
extends SplitRectInfo {
    protected int _row;
    protected int _col;
    protected int _row2;
    protected int _col2;
    protected int[] _rowOffs;
    protected int[] _colOffs;
    protected double[] _xOffs;
    protected double[] _yOffs;

    public int getRow() {
        return this._row;
    }

    public int getCol() {
        return this._col;
    }

    public int getRow2() {
        return this._row2;
    }

    public int getCol2() {
        return this._col2;
    }

    public int[] getRowOffs() {
        return this._rowOffs;
    }

    public int[] getColOffs() {
        return this._colOffs;
    }

    public AbstractTableSplitRectInfo() {
    }

    public AbstractTableSplitRectInfo(int row, int col, int row2, int col2) {
        this.setRowCol(row, col, row2, col2);
        this.setSplitInfo(null, null, null);
    }

    public AbstractTableSplitRectInfo(int row, int col, int row2, int col2, Integer relatePos, int[] rowOffs, int[] colOffs) {
        this.setRowCol(row, col, row2, col2);
        this.setSplitInfo(relatePos, rowOffs, colOffs);
    }

    public void setSplitInfo(Integer relatePos, int[] rowOffs, int[] colOffs) {
        int ySplitNum = 0;
        if (rowOffs != null) {
            ySplitNum = rowOffs.length;
            this._rowOffs = rowOffs;
        } else {
            this._rowOffs = new int[0];
        }
        int xSplitNum = 0;
        if (colOffs != null) {
            xSplitNum = colOffs.length;
            this._colOffs = colOffs;
        } else {
            this._colOffs = new int[0];
        }
        if (relatePos == null) {
            relatePos = ISplitRectInfo.RELATE_TO_UPLEFT;
        }
        this.reset(relatePos, xSplitNum, ySplitNum);
    }

    public void genDefaultOffs() {
        int rows = this._row2 - this._row;
        int cols = this._col2 - this._col;
        int[] rowOffs = new int[rows];
        int[] colOffs = new int[cols];
        Arrays.fill(rowOffs, 1);
        Arrays.fill(colOffs, 1);
        this.setSplitInfo(RELATE_TO_UPLEFT, rowOffs, colOffs);
    }

    public void copyFrom(AbstractTableSplitRectInfo info, boolean onlyAttris) {
        if (!onlyAttris) {
            Integer pos = info._relatePos;
            int[] rowoffs = new int[info._rowOffs.length];
            int[] coloffs = new int[info._colOffs.length];
            System.arraycopy(info._rowOffs, 0, rowoffs, 0, info._rowOffs.length);
            System.arraycopy(info._colOffs, 0, coloffs, 0, info._colOffs.length);
            this.setRowCol(info._row, info._col, info._row2, info._col2);
            this.setSplitInfo(pos, rowoffs, coloffs);
        }
        int size = this.size();
        int size2 = info.size();
        size = Math.min(size, size2);
        for (int i = 0; i < size; ++i) {
            this.getTriangleInfo(i).setAutoZoom(info.getTriangleInfo(i).isAutoZoom());
            this.getTriangleInfo(i).setStyle(info.getTriangleInfo(i).getStyle());
            this.getTriangleInfo(i).setDrawBackground(info.getTriangleInfo(i).isDrawBackground());
            this.getTriangleInfo(i).setLean(info.getTriangleInfo(i).isLean());
            this.getTriangleInfo(i).setText(info.getTriangleInfo(i).getText());
        }
    }

    public void setRowCol(int row, int col, int row2, int col2) {
        this._row = row;
        this._col = col;
        this._row2 = row2;
        this._col2 = col2;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AbstractTableSplitRectInfo) {
            AbstractTableSplitRectInfo ai = (AbstractTableSplitRectInfo)o;
            boolean b = this._row == ai._row && this._col == ai._col && this._row2 == ai._row2 && this._col2 == ai._col2;
            b = b && Arrays.equals(this._rowOffs, ai._rowOffs);
            b = b && Arrays.equals(this._colOffs, ai._colOffs);
            return b;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this._rowOffs) & Arrays.hashCode(this._colOffs);
    }
}

