/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class TableSplitRectInfoXml {
    public static final String DIAGONALHEADER = "DiagonalHeader";
    static final String DH_COL = "Col";
    static final String DH_ROW2 = "Row2";
    static final String DH_COL2 = "Col2";
    static final String ROWOFFERS = "RowOffers";
    static final String COLOFFERS = "ColOffers";
    static final String XOFFERS = "xOffers";
    static final String YOFFERS = "yOffers";
    static final String TRIANGLE = "Triangle";
    static final String LEAN = "Lean";
    static final String ZOOM = "Zoom";
    static final String DRAWBACK = "DrawBack";
    static final String POSITION = "Position";
    static final String LINESTYLE = "LineStyle";
    static final String WEIGHT = "Weight";
    static final String ROW = "Row";
    static final String STYLEID = "StyleID";
    static final String INDEX = "Index";
    static final String DATA_STRING = "String";
    static final String TRUEVALUE = "True";
    static final String FALSEVALUE = "False";

    public static AbstractTableSplitRectInfo fromXml(Element dhe, Map styles) {
        Integer position = Integer.valueOf(dhe.attributeValue(POSITION));
        int row = Integer.parseInt(dhe.attributeValue(ROW));
        int col = Integer.parseInt(dhe.attributeValue(DH_COL));
        int row2 = Integer.parseInt(dhe.attributeValue(DH_ROW2));
        int col2 = Integer.parseInt(dhe.attributeValue(DH_COL2));
        int[] rowOffers = new int[]{};
        int[] colOffers = new int[]{};
        if (dhe.attributeValue(ROWOFFERS) != null) {
            rowOffers = TableSplitRectInfoXml.arrayToInt(dhe.attributeValue(ROWOFFERS));
        }
        if (dhe.attributeValue(COLOFFERS) != null) {
            colOffers = TableSplitRectInfoXml.arrayToInt(dhe.attributeValue(COLOFFERS));
        }
        TableSplitRectInfo info = new TableSplitRectInfo(row, col, row2, col2, position, rowOffers, colOffers);
        double[] xOffers = new double[]{};
        double[] yOffers = new double[]{};
        if (dhe.attributeValue(XOFFERS) != null) {
            xOffers = TableSplitRectInfoXml.arrayToDouble(dhe.attributeValue(XOFFERS));
        }
        if (dhe.attributeValue(YOFFERS) != null) {
            yOffers = TableSplitRectInfoXml.arrayToDouble(dhe.attributeValue(YOFFERS));
        }
        info.setXSplitOffs(xOffers);
        info.setYSplitOffs(yOffers);
        List children = dhe.elements(TRIANGLE);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element triangle = (Element)children.get(i);
            TableSplitRectInfoXml.fromTriangle(info, triangle, styles);
        }
        return info;
    }

    private static double[] arrayToDouble(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        double[] arrayInts = new double[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Double.parseDouble(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    private static int[] arrayToInt(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        int[] arrayInts = new int[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Integer.parseInt(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    public static Element toXml(AbstractTableSplitRectInfo dh, List styles) {
        double[] yOffs;
        double[] xOffs;
        int[] colOffs;
        DefaultElement dhe = new DefaultElement(DIAGONALHEADER);
        dhe.addAttribute(POSITION, dh.getPosition().toString());
        dhe.addAttribute(ROW, String.valueOf(dh.getRow()));
        dhe.addAttribute(DH_COL, String.valueOf(dh.getCol()));
        dhe.addAttribute(DH_ROW2, String.valueOf(dh.getRow2()));
        dhe.addAttribute(DH_COL2, String.valueOf(dh.getCol2()));
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            dhe.addAttribute(ROWOFFERS, StringUtil.array2String(rowOffs, ","));
        }
        if ((colOffs = dh.getColOffs()) != null && colOffs.length > 0) {
            dhe.addAttribute(COLOFFERS, StringUtil.array2String(colOffs, ","));
        }
        if ((xOffs = dh.getXSplitOffs()) != null && xOffs.length > 0) {
            dhe.addAttribute(XOFFERS, StringUtil.array2String(xOffs, ","));
        }
        if ((yOffs = dh.getYSplitOffs()) != null && yOffs.length > 0) {
            dhe.addAttribute(YOFFERS, StringUtil.array2String(yOffs, ","));
        }
        int size = dh.size();
        for (int i = 0; i < size; ++i) {
            TableSplitRectInfoXml.buildTraingleInfoElement(dh, i, (Element)dhe, styles);
        }
        return dhe;
    }

    private static void fromTriangle(TableSplitRectInfo info, Element triangle, Map styles) {
        int index = Integer.parseInt(triangle.attributeValue(INDEX));
        TriangleInfo tri = info.getTriangleInfo(index);
        String styleID = triangle.attributeValue(STYLEID);
        if (styleID != null) {
            tri.setStyle((Style)styles.get(styleID));
        }
        tri.setText(triangle.attributeValue(DATA_STRING));
        tri.setLean(triangle.attributeValue(LEAN).equals(TRUEVALUE));
        tri.setAutoZoom(triangle.attributeValue(ZOOM).equals(TRUEVALUE));
        tri.setDrawBackground(triangle.attributeValue(DRAWBACK).equals(TRUEVALUE));
    }

    private static void buildTraingleInfoElement(AbstractTableSplitRectInfo dh, int index, Element pElement, List styles) {
        DefaultElement te = new DefaultElement(TRIANGLE, pElement.getNamespace());
        TriangleInfo ti = dh.getTriangleInfo(index);
        Style ssa = ti.getStyle();
        if (ssa != null && !ssa.isEmpty()) {
            te.addAttribute(STYLEID, "" + ssa.getUID());
            styles.add(ssa);
        }
        te.addAttribute(INDEX, String.valueOf(index));
        te.addAttribute(DATA_STRING, ti.getText());
        te.addAttribute(LEAN, ti.isLean() ? TRUEVALUE : FALSEVALUE);
        te.addAttribute(ZOOM, ti.isAutoZoom() ? TRUEVALUE : FALSEVALUE);
        te.addAttribute(DRAWBACK, ti.isDrawBackground() ? TRUEVALUE : FALSEVALUE);
        pElement.add((Element)te);
    }
}

