/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;

class TriangleTextRender
extends AbstractBasicRender {
    private static ArrayList splitTexts = new ArrayList();

    TriangleTextRender() {
    }

    protected void drawBackground(Graphics2D g2d, Shape shape, Style style) {
        if (style != null && style.getPattern() != Pattern.None) {
            Paint paint = style.getFillPaint();
            g2d.setPaint(paint);
            g2d.fill(shape);
        }
    }

    @Override
    public void draw(Graphics g, Shape clip, Object o, Style style) {
        if (o == null || !(o instanceof TriangleInfo)) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"o\u5fc5\u987b\u662fTriangleInfo\u7c7b\u578b\u3002", (String)"TriangleTextRender_0", (String)"bos-print-engine", (Object[])new Object[0]));
        }
        TriangleInfo info = (TriangleInfo)o;
        Shape shape = info.getAwtShape();
        if (info.isDrawBackground()) {
            Style st = info.getStyle();
            this.drawBackground((Graphics2D)g, shape, st);
        }
        if (StringUtil.isEmptyString(info.getText())) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(this.getFont(info));
        g2d.setColor(this.getColor(info));
        g2d.setClip(shape);
        if (info.isLean() || info.isAutoZoom()) {
            Point2D cp = info.getWeightPoint();
            double drgee = 0.0;
            if (info.isLean()) {
                drgee = info.getSuggestLeanDrgee();
                this.splitText(splitTexts, info.getText(), true);
            } else {
                drgee = 0.0;
                splitTexts.clear();
                if (info.getText().length() > 0) {
                    splitTexts.add(info.getText());
                }
            }
            Rectangle2D[] rects = new Rectangle2D[splitTexts.size()];
            double scale = 1.0;
            Shape calcShape = shape;
            while (!this.calcPositions(g2d, calcShape, cp, drgee, info.isAutoZoom(), rects)) {
                if ((scale -= 0.05) < 0.0) {
                    return;
                }
                calcShape = info.getScaledAwtShape(1.0 / scale);
            }
            this.drawImpl(g2d, splitTexts, rects, cp, scale);
        } else {
            FontMetrics fm = g2d.getFontMetrics();
            ArrayList upRects = new ArrayList();
            ArrayList downRects = new ArrayList();
            double ratio = info.calcWrapTextRects(upRects, downRects, g2d.getFontMetrics());
            String text = info.getText();
            int start = 0;
            if (ratio == 0.0) {
                upRects = downRects;
            } else if (ratio != Double.POSITIVE_INFINITY) {
                int upStrNums = (int)(ratio * (double)text.length() / (ratio + 1.0));
                if (upStrNums == 0) {
                    start = upRects.size();
                } else {
                    double upStrWidth = fm.stringWidth(text.substring(0, upStrNums));
                    double temp = 0.0;
                    for (start = upRects.size() - 1; start > 0 && !((temp += ((Rectangle2D)upRects.get(start)).getWidth()) >= upStrWidth); --start) {
                    }
                }
                upRects.addAll(downRects);
            }
            char[] texts = text.toCharArray();
            int textLen = texts.length;
            int lastIndex = 0;
            int curIndex = 0;
            double deltx = 2.0;
            for (int i = start; i < upRects.size() && lastIndex < textLen; ++i) {
                Rectangle2D rect = (Rectangle2D)upRects.get(i);
                double width = rect.getWidth();
                double holdW = 0.0;
                while (curIndex < textLen) {
                    if ((holdW += (double)fm.charWidth(texts[curIndex])) > width) {
                        if (curIndex <= 0) break;
                        g2d.drawChars(texts, lastIndex, curIndex - lastIndex, (int)(rect.getX() + deltx), (int)(rect.getMaxY() + (double)fm.getDescent()));
                        lastIndex = curIndex;
                        break;
                    }
                    ++curIndex;
                }
                if (curIndex != textLen) continue;
                g2d.drawChars(texts, lastIndex, curIndex - lastIndex, (int)(rect.getX() + deltx), (int)(rect.getMaxY() + (double)fm.getDescent()));
                lastIndex = curIndex;
            }
        }
    }

    private void drawImpl(Graphics2D g2d, ArrayList texts, Rectangle2D[] rects, Point2D cp, double scale) {
        double cx = cp.getX();
        double cy = cp.getY();
        g2d.scale(scale, scale);
        for (int i = 0; i < rects.length; ++i) {
            double x = rects[i].getX();
            double y = rects[i].getMaxY();
            x = (cx + (x - cx) * scale) / scale;
            y = (cy + (y - cy) * scale) / scale;
            g2d.drawString((String)splitTexts.get(i), (float)x, (float)y);
        }
    }

    private boolean calcPositions(Graphics2D g2d, Shape shape, Point2D cPoint, double drgee, boolean autoZoom, Rectangle2D[] retRects) {
        double delt;
        boolean yFirst;
        Rectangle2D curBounds;
        int i;
        int size = retRects.length;
        FontMetrics fm = g2d.getFontMetrics();
        int descend = fm.getDescent();
        int cIndex = size / 2 + size % 2 - 1;
        String cStr = (String)splitTexts.get(cIndex);
        Rectangle2D cBounds = fm.getStringBounds(cStr, g2d);
        retRects[cIndex] = this.createDrawRect(cBounds, cPoint, descend);
        if (autoZoom && !shape.contains(retRects[cIndex])) {
            return false;
        }
        Rectangle2D lastBounds = cBounds;
        double curX = cPoint.getX();
        double curY = cPoint.getY();
        for (i = cIndex - 1; i >= 0; --i) {
            curBounds = fm.getStringBounds((String)splitTexts.get(i), g2d);
            boolean bl = yFirst = Math.abs(drgee) > lastBounds.getHeight() / lastBounds.getWidth();
            if (drgee > 0.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY -= delt;
                    curX -= delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX -= delt;
                    curY -= delt * drgee;
                }
            } else if (drgee < -2.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY -= delt;
                    curX -= delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX += delt;
                    curY += delt * drgee;
                }
            } else if (drgee <= 0.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY += delt;
                    curX += delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX -= delt;
                    curY -= delt * drgee;
                }
            }
            retRects[i] = this.createDrawRect(curBounds, curX, curY, descend);
            if (autoZoom && !shape.contains(retRects[i])) {
                return false;
            }
            lastBounds = curBounds;
        }
        curX = cPoint.getX();
        curY = cPoint.getY();
        lastBounds = cBounds;
        for (i = cIndex + 1; i < size; ++i) {
            curBounds = fm.getStringBounds((String)splitTexts.get(i), g2d);
            boolean bl = yFirst = Math.abs(drgee) > lastBounds.getHeight() / lastBounds.getWidth();
            if (drgee > 0.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY += delt;
                    curX += delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX += delt;
                    curY += delt * drgee;
                }
            }
            if (drgee < -2.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY += delt;
                    curX += delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX -= delt;
                    curY -= delt * drgee;
                }
            } else if (drgee <= 0.0) {
                if (yFirst) {
                    delt = curBounds.getHeight() / 2.0 + lastBounds.getHeight() / 2.0;
                    curY -= delt;
                    curX -= delt / drgee;
                } else {
                    delt = curBounds.getWidth() / 2.0 + lastBounds.getWidth() / 2.0;
                    curX += delt;
                    curY += delt * drgee;
                }
            }
            retRects[i] = this.createDrawRect(curBounds, curX, curY, descend);
            if (autoZoom && !shape.contains(retRects[i])) {
                return false;
            }
            lastBounds = curBounds;
        }
        return true;
    }

    private boolean isChnChar(char c) {
        return c > '\u00ff';
    }

    private void splitText(ArrayList splitTexts, String text, boolean bFilterSpace) {
        splitTexts.clear();
        int len = text.length();
        boolean preEng = false;
        boolean preSpace = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (this.isChnChar(c)) {
                if (!(sb.length() <= 0 || preSpace && bFilterSpace)) {
                    splitTexts.add(sb.toString());
                    sb.delete(0, sb.length());
                }
                sb.append(c);
                preEng = false;
                preSpace = false;
                continue;
            }
            if (Character.isSpaceChar(c)) {
                if (!preSpace && sb.length() > 0) {
                    splitTexts.add(sb.toString());
                    sb.delete(0, sb.length());
                }
                sb.append(c);
                preEng = false;
                preSpace = true;
                continue;
            }
            if (!(preEng || sb.length() <= 0 || preSpace && bFilterSpace)) {
                splitTexts.add(sb.toString());
                sb.delete(0, sb.length());
            }
            sb.append(c);
            preEng = true;
            preSpace = false;
        }
        if (!(sb.length() <= 0 || preSpace && bFilterSpace)) {
            splitTexts.add(sb.toString());
        }
    }

    private Color getColor(TriangleInfo info) {
        Style style = info.getStyle();
        if (style == null) {
            return Color.black;
        }
        return style.getFontColor();
    }

    private Font getFont(TriangleInfo info) {
        Style style = info.getStyle();
        if (style == null) {
            return Styles.getDefaultStyle().getFont();
        }
        return style.getFont();
    }

    private Rectangle2D createDrawRect(Rectangle2D strBounds, Point2D cp, int descend) {
        return this.createDrawRect(strBounds, cp.getX(), cp.getY(), descend);
    }

    private Rectangle2D createDrawRect(Rectangle2D strBounds, double cx, double cy, int descend) {
        double w = strBounds.getWidth();
        double h = strBounds.getHeight();
        return new Rectangle2D.Double(cx - w / 2.0, cy - h / 2.0, w - (double)descend, h - (double)descend);
    }
}

