/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Rect;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.print.control.BaseControl;
import org.dom4j.Element;
import org.dom4j.InvalidXPathException;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.xpath.DefaultXPath;

public class StyleParser {
    private static final String COLOR = "color";
    private static final String BORDER = "Border";
    private static final String LINE_STYLE = "lineStyle";
    private static final String PEN_STYLE = "penStyle";
    private static final String BORDERS = "Borders";
    private static final String INTERIOR = "Interior";
    private static final String PATTERN = "pattern";
    private static final String PEN_STYLES = "PenStyles";
    private static final String BOS_PRINT_ENGINE = "bos-print-engine";
    private static final int FILTER_V0 = 0;
    private static final int FILTER_V1 = 1;
    private static final HashMap<Float, Integer> _filters;
    private static final HashMap<String, Color> _colors;
    private static final Log log;

    private StyleParser() {
    }

    public static void writeStyles(Element eleStyles, Namespace ns, Iterator iterStyles) {
        eleStyles.addAttribute("version", "1.0");
        HashMap customPenStyles = new HashMap();
        while (iterStyles.hasNext()) {
            Map.Entry e = (Map.Entry)iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            String id = e.getKey().toString();
            StyleParser.getStyleElement(ssa, id, ns, eleStyles);
            if (!ssa.hasBordersAttributes()) continue;
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.LEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.TOP);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.RIGHT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.BOTTOM);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALLEFT);
            StyleParser.getCustomPenStyle(customPenStyles, ssa, Styles.Position.DIAGONALRIGHT);
        }
        StyleParser.writeCustomPenStyle(eleStyles, ns, customPenStyles);
    }

    private static void getCustomPenStyle(HashMap customPenStyles, ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        if (ps != null && !ps.isSystem()) {
            customPenStyles.put(ps.getName(), ps);
        }
    }

    public static String colorToHex(Color color) {
        StringBuilder sb = new StringBuilder("#");
        String str = Integer.toHexString(color.getRed());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getGreen());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        str = Integer.toHexString(color.getBlue());
        if (str.length() < 2) {
            sb.append("0");
        }
        sb.append(str);
        if (color.getAlpha() != 255) {
            str = Integer.toHexString(color.getAlpha());
            if (str.length() < 2) {
                sb.append("0");
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static void getStyleElement(ShareStyleAttributes ssa, String ssaName, Namespace ns, Element parentElement) {
        String numberFormat;
        Element eleStyle = parentElement.addElement("Style", null == ns ? null : ns.getURI());
        eleStyle.addAttribute("id", ssaName);
        if (ssa.hasFontAttributes()) {
            Element eleFont = eleStyle.addElement("Font", null == ns ? null : ns.getURI());
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_NAME, "fontName", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_SIZE, "size", eleFont);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.FONT_COLOR, COLOR, eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_BOLD, "bold", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_UNDERLINE, "underline", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_ITALIC, "italic", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_STRIKETHROUGH, "strikethrough", eleFont);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.FONT_WEIGHT, "weight", eleFont);
        }
        StyleParser.writeXML_Borders(ssa, eleStyle, ns);
        StyleParser.writeXML_Interior(ssa, eleStyle, ns);
        StyleParser.writeXML_Alignment(ssa, eleStyle, ns);
        StyleParser.writeXML_Protection(ssa, eleStyle, ns);
        if (ssa.hasAttributes(ShareStyleAttributes.NUMBER_FORMAT) && !StringUtil.isEmptyString(numberFormat = ssa.getNumberFormat())) {
            Element eleNF = eleStyle.addElement("NumberFormat", null == ns ? null : (null == ns ? null : ns.getURI()));
            eleNF.setText(numberFormat);
        }
    }

    static void writeXML_Border(ShareStyleAttributes ssa, Styles.Position pos, Element eleBorders, Namespace ns) {
        if (!ssa.hasBorderAttributes(pos)) {
            return;
        }
        Element eleBorder = eleBorders.addElement(BORDER, null == ns ? null : ns.getURI());
        eleBorder.addAttribute("position", pos.getName());
        StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderLineStyleIndex(pos), LINE_STYLE, eleBorder);
        LineStyle ls = ssa.getBorderLineStyle(pos);
        if (ls != LineStyle.NULL_LINE) {
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.getBorderPenStyleIndex(pos), PEN_STYLE, eleBorder);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.getBorderColorIndex(pos), COLOR, eleBorder);
        }
    }

    static void writeXML_Borders(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (!ssa.hasBordersAttributes()) {
            return;
        }
        Element eleBorders = eleStyle.addElement(BORDERS, null == ns ? null : ns.getURI());
        StyleParser.writeXML_Border(ssa, Styles.Position.LEFT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.TOP, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.RIGHT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.BOTTOM, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALLEFT, eleBorders, ns);
        StyleParser.writeXML_Border(ssa, Styles.Position.DIAGONALRIGHT, eleBorders, ns);
    }

    static void writeXML_Interior(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasInteriorAttributes()) {
            Element eleInt = eleStyle.addElement(INTERIOR, null == ns ? null : ns.getURI());
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.BACKGROUND_COLOR, COLOR, eleInt);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PATTERN, PATTERN, eleInt);
            StyleParser.setXMLColorAttribute(ssa, ShareStyleAttributes.PATTERN_COLOR, "patternColor", eleInt);
        }
    }

    static void writeXML_Alignment(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasAlignmentAttributes()) {
            Element eleAlignment = eleStyle.addElement("Alignment", null == ns ? null : ns.getURI());
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.HORIZONTAL_ALIGN, "horizontal", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.VERTICAL_ALIGN, "vertical", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.WRAP_TEXT, "wrapText", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.ROTATION, "rotate", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.SHRINK_TEXT, "shrink", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.LINE_SPACING, "lineSpace", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PADDING, "padding", eleAlignment);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.AUTO_CLIP, "clip", eleAlignment);
        }
    }

    static void writeXML_Protection(ShareStyleAttributes ssa, Element eleStyle, Namespace ns) {
        if (ssa.hasProtectionAttributes()) {
            Element eleProtection = eleStyle.addElement("Protection", null == ns ? null : ns.getURI());
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_HIDDED, "hidden", eleProtection);
            StyleParser.setXMLAttribute(ssa, ShareStyleAttributes.PROTECTION_LOCKED, "locked", eleProtection);
        }
    }

    static void setXMLAttribute(ShareStyleAttributes ssa, int index, String key, Element ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.addAttribute(key, obj.toString());
        }
    }

    static void setXMLColorAttribute(ShareStyleAttributes ssa, int index, String key, Element ele) {
        if (ssa.hasAttributes(index)) {
            Object obj = ssa.get(index);
            ele.addAttribute(key, StyleParser.colorToHex((Color)obj));
        }
    }

    public static void writeCustomPenStyle(Element eleStyles, Namespace ns, HashMap customPenStyles) {
        Iterator i = customPenStyles.entrySet().iterator();
        if (!i.hasNext()) {
            return;
        }
        Element penStyles = eleStyles.addElement(PEN_STYLES, null == ns ? null : ns.getURI());
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PenStyle ps = (PenStyle)e.getValue();
            Element penStyle = penStyles.addElement("PenStyle", null == ns ? null : ns.getURI());
            penStyle.addAttribute("name", ps.getName());
            penStyle.addAttribute("dash", ps.getDashString());
        }
    }

    public static StyleAttributes parseSA(Element eleStyle) {
        StyleAttributes sa = Styles.getEmptySA();
        Namespace ns = eleStyle.getNamespace();
        try {
            String str;
            Element eleChild = eleStyle.element(new QName(BORDERS, ns));
            if (eleChild != null) {
                Iterator i = eleChild.elements(new QName(BORDER, ns)).iterator();
                while (i.hasNext()) {
                    StyleParser.parseBorder((Element)i.next(), sa, ns);
                }
            }
            if ((eleChild = eleStyle.element(new QName("Font", ns))) != null) {
                StyleParser.parseFont(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.element(new QName("Protection", ns))) != null) {
                StyleParser.parseProtection(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.element(new QName(INTERIOR, ns))) != null) {
                StyleParser.parseInterior(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.element(new QName("Alignment", ns))) != null) {
                StyleParser.parseAlignment(eleChild, sa, ns);
            }
            if ((eleChild = eleStyle.element(new QName("NumberFormat", ns))) != null && (str = eleChild.getText()) != null) {
                sa.setNumberFormat(str);
            }
        }
        catch (Exception err) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u89e3\u6790Style\u9519\u8bef\uff1a", (String)"StyleParser_0", (String)"bos-print-core", (Object[])new Object[0]), err);
        }
        return sa;
    }

    private static int parseInt(String value) {
        if (StringUtils.isEmpty((CharSequence)value) || "0".equals(value)) {
            return 0;
        }
        String cutValue = value.substring(0, value.length() - 2);
        return Integer.parseInt(cutValue);
    }

    public static StyleAttributes parseSA(BaseControl<?> ctrl) {
        StyleAttributes sa = Styles.getEmptySA();
        if (ctrl.getStyle() != null) {
            StyleParser.parseBorder("left", sa, ctrl);
            StyleParser.parseBorder("right", sa, ctrl);
            StyleParser.parseBorder("top", sa, ctrl);
            StyleParser.parseBorder("bottom", sa, ctrl);
            if (ctrl.getStyle().getPadding() != null) {
                int t = StyleParser.parseInt(ctrl.getStyle().getPadding().getTop());
                int l = StyleParser.parseInt(ctrl.getStyle().getPadding().getLeft());
                int b = StyleParser.parseInt(ctrl.getStyle().getPadding().getBottom());
                int r = StyleParser.parseInt(ctrl.getStyle().getPadding().getRight());
                Rect rc = new Rect(l, t, r, b);
                sa.setPadding(rc);
            }
        }
        sa.setWordspacing(ctrl.getWordSpacing());
        sa.setFontSize(ctrl.getFontSize());
        if (ctrl.getFontName() == null) {
            sa.setFontName(null);
        } else {
            sa.setFontName(ctrl.getFontName().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)ctrl.getForeColor())) {
            sa.setFontColor(StyleParser.stringToColor(ctrl.getForeColor()));
        }
        if (StringUtils.isNotBlank((CharSequence)ctrl.getBackColor())) {
            sa.setBackground(StyleParser.stringToColor(ctrl.getBackColor()));
        }
        if (ctrl.isWrapText()) {
            sa.setWrapText(ctrl.isWrapText());
        }
        if (ctrl.isShrink()) {
            sa.setShrinkText(ctrl.isShrink());
        }
        sa.setBold(ctrl.isBold());
        sa.setItalic(ctrl.isItalic());
        sa.setUnderline(ctrl.isUnderLine());
        String format = ctrl.getFormat();
        if (!StringUtils.isEmpty((CharSequence)format)) {
            sa.setNumberFormat(format);
        }
        String verAlignment = ctrl.getVerAlignment();
        sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment(verAlignment));
        String horAlignment = ctrl.getHorAlignment();
        sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment(horAlignment));
        return sa;
    }

    static void parseBorder(String position, StyleAttributes sa, BaseControl<?> ctrl) {
        Styles.Position pos = Styles.Position.parse(position);
        String border = "";
        if (ctrl.getStyle().getBorder() != null) {
            if (position.equals("top")) {
                border = ctrl.getStyle().getBorder().getTop();
            } else if (position.equals("bottom")) {
                border = ctrl.getStyle().getBorder().getBottom();
            } else if (position.equals("left")) {
                border = ctrl.getStyle().getBorder().getLeft();
            } else if (position.equals("right")) {
                border = ctrl.getStyle().getBorder().getRight();
            }
            if (StringUtils.isNotBlank((CharSequence)border)) {
                String[] borderArr = border.split("_");
                String lineStyle = borderArr[0];
                String penStyle = borderArr[1];
                String color = borderArr[2];
                sa.setBorderColor(pos, StyleParser.stringToColor(color));
                sa.setBorderPenStyle(pos, PenStyle.getPenStyle(penStyle));
                try {
                    if (!StringUtil.isEmptyString(lineStyle)) {
                        if ("0.5px".equals(lineStyle)) {
                            sa.setBorderLineStyle(pos, LineStyle.getLineStyle("CustomLine"));
                        } else {
                            int px = Integer.parseInt(java.util.regex.Pattern.compile("[^0-9]").matcher(lineStyle).replaceAll("").trim());
                            switch (px) {
                                case 1: {
                                    sa.setBorderLineStyle(pos, LineStyle.getLineStyle("Single"));
                                    break;
                                }
                                case 2: {
                                    sa.setBorderLineStyle(pos, LineStyle.getLineStyle("DoubleB"));
                                    break;
                                }
                                case 3: {
                                    sa.setBorderLineStyle(pos, LineStyle.getLineStyle("TrigramSolid"));
                                    break;
                                }
                                default: {
                                    if (px < 10) {
                                        sa.setBorderLineStyle(pos, LineStyle.getLineStyle("Width" + px));
                                        break;
                                    }
                                    sa.setBorderLineStyle(pos, LineStyle.getLineStyle("Width9"));
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new KDException((Throwable)e, new ErrorCode("StyleParser:error", e.getMessage()), new Object[]{String.format("Error:%s.", e.getMessage())});
                }
            }
        }
    }

    static void parseBorder(Element eleBorder, StyleAttributes sa, Namespace ns) {
        Styles.Position pos = Styles.Position.parse(eleBorder.attributeValue("position"));
        String value = eleBorder.attributeValue(COLOR);
        if (value != null) {
            sa.setBorderColor(pos, StyleParser.stringToColor(value));
        }
        if ((value = eleBorder.attributeValue(PEN_STYLE)) != null) {
            sa.setBorderPenStyle(pos, PenStyle.getPenStyle(value));
        }
        if ((value = eleBorder.attributeValue(LINE_STYLE)) != null) {
            sa.setBorderLineStyle(pos, LineStyle.getLineStyle(value));
        }
    }

    static void parseFont(Element eleFont, StyleAttributes sa, Namespace ns) {
        String value = eleFont.attributeValue("fontName");
        if (value != null) {
            sa.setFontName(value);
        }
        if ((value = eleFont.attributeValue("size")) != null) {
            sa.setFontSize(Integer.parseInt(value));
        }
        if ((value = eleFont.attributeValue(COLOR)) != null) {
            sa.setFontColor(StyleParser.stringToColor(value));
        }
        if ((value = eleFont.attributeValue("bold")) != null) {
            sa.setBold(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.attributeValue("italic")) != null) {
            sa.setItalic(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.attributeValue("strikethrough")) != null) {
            sa.setStrikeThrough(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.attributeValue("underline")) != null) {
            sa.setUnderline(Boolean.parseBoolean(value));
        }
        if ((value = eleFont.attributeValue("weight")) != null) {
            sa.setWeight(Float.parseFloat(value));
        }
    }

    static void parseProtection(Element eleProtection, StyleAttributes sa, Namespace ns) {
        String value = eleProtection.attributeValue("locked");
        if (value != null) {
            sa.setLocked(Boolean.parseBoolean(value));
        }
        if ((value = eleProtection.attributeValue("hidden")) != null) {
            sa.setHided(Boolean.parseBoolean(value));
        }
    }

    static void parseInterior(Element eleInterior, StyleAttributes sa, Namespace ns) {
        String value = eleInterior.attributeValue(COLOR);
        if (value != null) {
            sa.setBackground(StyleParser.stringToColor(value));
        }
        if ((value = eleInterior.attributeValue(PATTERN)) != null) {
            sa.setPattern(Pattern.getPattern(value));
        }
        if ((value = eleInterior.attributeValue("patternColor")) != null) {
            sa.setPatternColor(StyleParser.stringToColor(value));
        }
    }

    static void parseAlignment(Element eleAlign, StyleAttributes sa, Namespace ns) {
        String value = eleAlign.attributeValue("rotate");
        if (value != null) {
            sa.setRotation(Integer.parseInt(value));
        }
        if ((value = eleAlign.attributeValue("horizontal")) != null) {
            sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.attributeValue("vertical")) != null) {
            sa.setVerticalAlign(Styles.VerticalAlignment.getAlignment(value));
        }
        if ((value = eleAlign.attributeValue("lineSpace")) != null) {
            sa.setLinespacing(Float.parseFloat(value));
        }
        if ((value = eleAlign.attributeValue("wrapText")) != null) {
            sa.setWrapText(Boolean.parseBoolean(value));
        }
        if ((value = eleAlign.attributeValue("shrink")) != null) {
            sa.setShrinkText(Boolean.parseBoolean(value));
        }
        if ((value = eleAlign.attributeValue("padding")) != null) {
            sa.setPadding(Rect.valueOf(value));
        }
        if ((value = eleAlign.attributeValue("clip")) != null) {
            sa.setClip(Boolean.parseBoolean(value));
        }
    }

    public static Color stringToColor(String str) {
        Color obj;
        Color color = null;
        color = str.length() == 0 ? Color.black : (str.startsWith("rgb(") ? StyleParser.parseRGB(str) : (str.charAt(0) == '#' ? StyleParser.hexToColor(str) : ((obj = _colors.get(str.toLowerCase())) != null ? obj : StyleParser.hexToColor(str))));
        return color;
    }

    public static final Color hexToColor(String strColor) {
        Color color = null;
        try {
            String strR = strColor.substring(1, 3);
            String strG = strColor.substring(3, 5);
            String strB = strColor.substring(5, 7);
            if (strColor.length() > 7) {
                String strA = strColor.substring(7, 9);
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA, 16));
            } else {
                color = new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16));
            }
        }
        catch (Exception err) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99", (String)"StyleParser_1", (String)BOS_PRINT_ENGINE, (Object[])new Object[0]), err);
        }
        return color;
    }

    public static Color parseRGB(String string) {
        int[] index = new int[]{4};
        int red = StyleParser.getColorComponent(string, index);
        int green = StyleParser.getColorComponent(string, index);
        int blue = StyleParser.getColorComponent(string, index);
        return new Color(red, green, blue);
    }

    private static int getColorComponent(String string, int[] index) {
        char aChar;
        int length = string.length();
        while (index[0] < length && (aChar = string.charAt(index[0])) != '-' && !Character.isDigit(aChar) && aChar != '.') {
            index[0] = index[0] + 1;
        }
        int start = index[0];
        if (start < length && string.charAt(index[0]) == '-') {
            index[0] = index[0] + 1;
        }
        while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
            index[0] = index[0] + 1;
        }
        if (index[0] < length && string.charAt(index[0]) == '.') {
            index[0] = index[0] + 1;
            while (index[0] < length && Character.isDigit(string.charAt(index[0]))) {
                index[0] = index[0] + 1;
            }
        }
        if (start != index[0]) {
            try {
                float value = Float.parseFloat(string.substring(start, index[0]));
                if (index[0] < length && string.charAt(index[0]) == '%') {
                    index[0] = index[0] + 1;
                    value = value * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)value));
            }
            catch (NumberFormatException nfe) {
                log.error((Throwable)nfe);
            }
        }
        return 0;
    }

    public static void upgrade(Element eleStyles) {
        if (eleStyles == null) {
            return;
        }
        String version = eleStyles.attributeValue("version");
        Integer obj = version == null ? null : _filters.get(Float.valueOf(version));
        int upgradeFrom = obj == null ? 0 : obj;
        switch (upgradeFrom) {
            case 0: {
                new StyleFilterV0().upgrade(eleStyles);
                break;
            }
        }
    }

    static {
        log = LogFactory.getLog(StyleParser.class);
        _filters = new HashMap();
        _filters.put(Float.valueOf(1.0f), 1);
        _colors = new HashMap();
        _colors.put("black", Color.BLACK);
        _colors.put("silver", new Color(192, 192, 192));
        _colors.put("gray", Color.GRAY);
        _colors.put("white", Color.WHITE);
        _colors.put("maroon", new Color(128, 0, 0));
        _colors.put("red", Color.RED);
        _colors.put("purple", new Color(128, 0, 128));
        _colors.put("fuchsia", new Color(255, 0, 255));
        _colors.put("green", Color.GREEN);
        _colors.put("lime", new Color(0, 255, 0));
        _colors.put("olive", new Color(128, 128, 0));
        _colors.put("yellow", Color.YELLOW);
        _colors.put("navy", new Color(0, 0, 128));
        _colors.put("blue", Color.BLUE);
        _colors.put("teal", new Color(0, 128, 128));
        _colors.put("aqua", new Color(0, 255, 255));
    }

    static class StyleFilterV0 {
        StyleFilterV0() {
        }

        public void upgrade(Element eleStyles) {
            List styles = eleStyles.elements();
            int size = styles.size();
            for (int i = 0; i < size; ++i) {
                String value;
                Element eleInterior;
                Namespace ns;
                Element eleStyle = (Element)styles.get(i);
                Element eleBorders = eleStyle.element(new QName(StyleParser.BORDERS, ns = eleStyle.getNamespace()));
                if (eleBorders != null) {
                    List borders = eleBorders.elements(new QName(StyleParser.BORDER, ns));
                    for (Element eleBorder : borders) {
                        this.upgradeBorder(eleStyles, eleBorder, ns);
                    }
                }
                if ((eleInterior = eleStyle.element(new QName(StyleParser.INTERIOR, ns))) == null || StringUtil.isEmptyString(value = eleInterior.attributeValue(StyleParser.PATTERN))) continue;
                Pattern ptn = Pattern.getPattern(Integer.parseInt(value));
                eleInterior.addAttribute(StyleParser.PATTERN, ptn.getName());
            }
        }

        private void upgradeBorder(Element eleStyles, Element eleBorder, Namespace ns) {
            LineStyle ls = null;
            String value = eleBorder.attributeValue(StyleParser.LINE_STYLE);
            if (value != null) {
                PenStyle ps = null;
                int lineStyle = Integer.parseInt(value);
                if (lineStyle == -1) {
                    String pattern = eleBorder.elementText(new QName("LinePattern", ns));
                    if (pattern != null) {
                        String[] strArray = pattern.split(" ");
                        float[] floatArray = new float[strArray.length];
                        for (int i = 0; i < strArray.length; ++i) {
                            floatArray[i] = Float.parseFloat(strArray[i]);
                        }
                        ps = PenStyle.createPenStyle(null, floatArray, false);
                        if (!ps.isSystem()) {
                            this.addToPenStyles(eleStyles, ps, ns);
                        }
                    }
                } else {
                    switch (lineStyle) {
                        case 0: {
                            ls = LineStyle.NULL_LINE;
                            break;
                        }
                        case 1: {
                            ps = PenStyle.PS_SOLID;
                            break;
                        }
                        case 2: {
                            ps = PenStyle.PS_CONTINUOUS;
                            break;
                        }
                        case 3: {
                            ps = PenStyle.PS_DOT;
                            break;
                        }
                        case 4: {
                            ps = PenStyle.PS_DASHDOTDOT;
                            break;
                        }
                        case 5: {
                            ps = PenStyle.PS_DASHDOT;
                            break;
                        }
                        default: {
                            ls = LineStyle.NULL_LINE;
                        }
                    }
                }
                eleBorder.remove(eleBorder.attribute(StyleParser.LINE_STYLE));
                if (ps != null) {
                    eleBorder.addAttribute(StyleParser.PEN_STYLE, ps.getName());
                }
            }
            if (ls == null && (value = eleBorder.attributeValue("width")) != null) {
                int width = Integer.parseInt(value);
                ls = LineStyle.getLineStyle(width);
                eleBorder.remove(eleBorder.attribute("width"));
            }
            if (ls != null) {
                eleBorder.addAttribute(StyleParser.LINE_STYLE, ls.getName());
            }
        }

        private void addToPenStyles(Element eleStyles, PenStyle ps, Namespace ns) {
            Element elePenStyles = eleStyles.element(StyleParser.PEN_STYLES);
            if (elePenStyles == null) {
                elePenStyles = eleStyles.addElement(StyleParser.PEN_STYLES);
            }
            Element elePenStyle = null;
            try {
                String xpath = "//PenStyle[@id=\"" + ps.getName() + "\"]";
                DefaultXPath formPath = new DefaultXPath(xpath);
                elePenStyle = (Element)formPath.selectSingleNode((Object)elePenStyles);
            }
            catch (InvalidXPathException err) {
                log.error((Throwable)err);
            }
            if (elePenStyle == null) {
                elePenStyle = elePenStyles.addElement("PenStyle", null == ns ? null : ns.getURI());
                elePenStyle.addAttribute("Name", ps.getName());
                float[] aDash = ps.getDash();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < aDash.length; ++i) {
                    sb.append(aDash[i]);
                    sb.append(' ');
                }
                elePenStyle.addAttribute("Dash", sb.toString());
            }
        }
    }
}

