/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.style;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;

public class StyleUtil {
    static float LOMETRIC_PER_INCH = 254.3f;
    private static float _pixelsPerInch = -1.0f;

    static float getPixelsPerInch() {
        if (_pixelsPerInch == -1.0f) {
            _pixelsPerInch = KDToolkit.getCurrentDpi();
        }
        return _pixelsPerInch;
    }

    public static long pixelToTwips(long x) {
        return (long)((double)x * 1440.0 / (double)StyleUtil.getPixelsPerInch());
    }

    public static long twipsToPixel(long x) {
        return (long)((double)x * (double)StyleUtil.getPixelsPerInch() / 1440.0);
    }

    public static long pixelToLom(long x) {
        return Math.round((double)x * (double)LOMETRIC_PER_INCH / (double)StyleUtil.getPixelsPerInch());
    }

    public static long lomToPixel(long x) {
        return Math.round((double)x * (double)StyleUtil.getPixelsPerInch() / (double)LOMETRIC_PER_INCH);
    }

    public static double pixelToPt(long x) {
        return (double)x * 72.0 / (double)StyleUtil.getPixelsPerInch();
    }

    public static long ptToPixel(double x) {
        return (long)(x * (double)StyleUtil.getPixelsPerInch() / 72.0);
    }

    public static double lomToPt(double dfLom) {
        return dfLom / (double)LOMETRIC_PER_INCH * 72.0;
    }

    public static double ptToLom(double dfPt) {
        return dfPt / 72.0 * (double)LOMETRIC_PER_INCH;
    }

    public static String styleToHtmlStyle(Style style) {
        Color clr;
        StringBuilder sb = new StringBuilder();
        if (style == null || style.isEmpty()) {
            return "";
        }
        String m_cs = StyleUtil.get_Html_Align(style);
        if (m_cs.length() > 0) {
            sb.append(m_cs);
        }
        if (style.hasBordersAttributes()) {
            if (style.hasBorderAttributes(Styles.Position.LEFT)) {
                m_cs = StyleUtil.get_Html_Line(Styles.Position.LEFT, style);
                sb.append(m_cs);
            }
            if (style.hasBorderAttributes(Styles.Position.TOP)) {
                m_cs = StyleUtil.get_Html_Line(Styles.Position.TOP, style);
                sb.append(m_cs);
            }
            if (style.hasBorderAttributes(Styles.Position.RIGHT)) {
                m_cs = StyleUtil.get_Html_Line(Styles.Position.RIGHT, style);
                sb.append(m_cs);
            }
            if (style.hasBorderAttributes(Styles.Position.BOTTOM)) {
                m_cs = StyleUtil.get_Html_Line(Styles.Position.BOTTOM, style);
                sb.append(m_cs);
            }
        }
        if (style.hasFontAttributes()) {
            m_cs = StyleUtil.get_Html_Font(style);
            sb.append(m_cs);
        }
        if ((clr = style.getBackground()) != null) {
            m_cs = "background:" + StyleParser.colorToHex(clr) + ";";
            sb.append(m_cs);
        }
        return sb.toString();
    }

    static String get_Html_Align(ShareStyleAttributes ssa) {
        String csProp = "";
        StringBuilder sbtemp = new StringBuilder();
        Object obvalue = ssa.get(ShareStyleAttributes.HORIZONTAL_ALIGN);
        if (obvalue != null) {
            csProp = ((Styles.HorizontalAlignment)obvalue).toString();
            sbtemp.append(" text-align:");
            sbtemp.append(csProp);
            sbtemp.append(";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.VERTICAL_ALIGN)) != null) {
            csProp = ((Styles.VerticalAlignment)obvalue).toString();
            sbtemp.append(" vertical-align:");
            sbtemp.append(csProp);
            sbtemp.append(";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.WRAP_TEXT)) != null && ((Boolean)obvalue).booleanValue()) {
            sbtemp.append("word-break:normal;word-wrap:break-word;");
        } else {
            sbtemp.append(" word-break:keep-all;word-wrap:normal;");
        }
        return sbtemp.toString();
    }

    static String get_Html_Line(Styles.Position pos, Style stl) {
        StringBuilder sbtemp = new StringBuilder();
        LineStyle ls = stl.getBorderLineStyle(pos);
        if (!LineStyle.isNull(ls)) {
            if (pos == Styles.Position.LEFT) {
                sbtemp.append("border-left:");
            } else if (pos == Styles.Position.TOP) {
                sbtemp.append("border-top:");
            } else if (pos == Styles.Position.RIGHT) {
                sbtemp.append("border-right:");
            } else if (pos == Styles.Position.BOTTOM) {
                sbtemp.append("border-bottom:");
            }
            sbtemp.append(stl.getBorderLineStyle(pos).getWidth());
            sbtemp.append(" ");
            sbtemp.append(StyleUtil.get_Html_Style(stl.getBorderPenStyle(pos)));
            sbtemp.append(" ");
            sbtemp.append(StyleParser.colorToHex(stl.getBorderColor(pos)));
            sbtemp.append(";");
        }
        return sbtemp.toString();
    }

    static String get_Html_Style(PenStyle ps) {
        String ret = ps == PenStyle.PS_SOLID ? "solid" : (ps == PenStyle.PS_DOT ? "dashed" : (ps == PenStyle.PS_CONTINUOUS ? "dotted" : "none"));
        return ret;
    }

    static String get_Html_Font(ShareStyleAttributes ssa) {
        boolean bvalue;
        StringBuilder sbtemp = new StringBuilder();
        Object obvalue = ssa.get(ShareStyleAttributes.FONT_NAME);
        if (obvalue != null) {
            String strName = (String)obvalue;
            sbtemp.append(" font-family:");
            sbtemp.append(strName);
            sbtemp.append(";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_SIZE)) != null) {
            int intvalue = (Integer)obvalue;
            sbtemp.append(" font-size:");
            sbtemp.append(intvalue);
            sbtemp.append("pt;");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_WEIGHT)) != null) {
            float fvalue = ((Float)obvalue).floatValue();
            sbtemp.append(" font-weight:");
            sbtemp.append(fvalue);
            sbtemp.append(";");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_ITALIC)) != null && (bvalue = ((Boolean)obvalue).booleanValue())) {
            sbtemp.append(" font-style:italic;");
        }
        if ((obvalue = ssa.get(ShareStyleAttributes.FONT_COLOR)) != null) {
            sbtemp.append(" color:");
            sbtemp.append(StyleParser.colorToHex((Color)obvalue));
            sbtemp.append(";");
        }
        return sbtemp.toString();
    }
}

