/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print;

import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import java.util.Calendar;

public class DefaultVariantParser
implements IVariantParser {
    public static final String TIME = "Time";
    public static final String DATE = "Date";
    public static final String PAGE_CURRENT = "Page";
    public static final String PAGE_TOTAL = "PageCount";
    Calendar cal;
    String dateStr;
    String timeStr;

    @Override
    public String parse(String name, PainterInfo info) {
        if (PAGE_CURRENT.equalsIgnoreCase(name)) {
            if (info != null) {
                return String.valueOf(info.getPaperIndex() + 1);
            }
            return "";
        }
        if (PAGE_TOTAL.equalsIgnoreCase(name)) {
            if (info != null) {
                int number = info.getNumberOfPages();
                if (number <= 0) {
                    return "?";
                }
                return String.valueOf(number);
            }
            return "";
        }
        if (DATE.equalsIgnoreCase(name)) {
            return this.getDateStr();
        }
        if (TIME.equalsIgnoreCase(name)) {
            return this.getTimeStr(info);
        }
        return null;
    }

    private String getTimeStr(PainterInfo info) {
        if (info == null || info.getPaperIndex() == 0) {
            this.cal = this.getCalendar();
            this.timeStr = CtrlFormatUtilities.getTimeFormat().format(this.cal.getTime());
        }
        return this.timeStr;
    }

    private String getDateStr() {
        if (this.dateStr == null) {
            this.cal = this.getCalendar();
            this.dateStr = CtrlFormatUtilities.getDateFormat().format(this.cal.getTime());
        }
        return this.dateStr;
    }

    private Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = Calendar.getInstance();
        }
        return this.cal;
    }

    public static String getVariantMark(String text) {
        String mark = null;
        if (PAGE_CURRENT.equalsIgnoreCase(text)) {
            mark = "123450";
        } else if (PAGE_TOTAL.equalsIgnoreCase(text)) {
            mark = "12345";
        } else if (DATE.equalsIgnoreCase(text)) {
            mark = "2005-02-0200";
        } else if (TIME.equalsIgnoreCase(text)) {
            mark = "23:1900";
        }
        return mark;
    }
}

