/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print;

import com.kingdee.bos.ctrl.print.ConfigManager;
import com.kingdee.bos.ctrl.print.DefaultVariantParser;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.KDPConstant;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.io.IOManager;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.printjob.MultiBufferPrintJobs;
import com.kingdee.bos.ctrl.print.ui.IPaintFilter;
import com.kingdee.bos.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import java.awt.Component;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.print.PrintService;
import javax.swing.event.EventListenerList;
import kd.bos.form.watermark.WaterMark;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KDPrinter
implements KDPConstant {
    private static final Log log = LogFactory.getLog(KDPrinter.class);
    private IPrintJob printJob;
    private static Map painterXmlTranslateMap;
    private static volatile boolean FIRST_LOAD;
    private Component parentWindow;
    private ControlPrint controlPrint;
    private ConfigManager config;
    private IVariantParser defaultVariantParser;
    private IVariantParser variantParser;
    protected EventListenerList listenerList = new EventListenerList();
    private boolean isStopPaginationField = false;
    private boolean isDividePageField = false;
    private IPaintFilter paintFilter;
    private IOManager ioManager;
    private boolean isExportImportButtonVisibleField = false;
    private boolean isEditButtonVisibleField = false;
    private static String[] headFootPreList;
    private WaterMark waterMark;

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
    }

    public KDPrinter() {
        this.controlPrint = new ControlPrint(this);
        this.config = new ConfigManager(this);
        this.printJob = new MultiBufferPrintJobs();
        this.printJob.setPrinter(this);
    }

    public void setPrintConfig(ConfigManager config) {
        this.config = config;
    }

    public ConfigManager getPrintConfig() {
        return this.config;
    }

    public ControlPrint getControlPrint() {
        return this.controlPrint;
    }

    public IPrintJob getPrintJob() {
        return this.printJob;
    }

    public PrintService getPrintService() {
        return this.config.getPrintService();
    }

    public void print() {
    }

    public int print2() {
        this.printDirect();
        return 1;
    }

    public void setParentWindow(Component parent) {
        this.parentWindow = parent;
    }

    public Component getParentWindow() {
        return this.parentWindow;
    }

    public void printDirect() {
        if (this.preParePrint()) {
            this.controlPrint.print(this.getPrintJob());
        } else {
            this.config.getModel().reset();
        }
    }

    public boolean preParePrint() {
        this.firePrintPaginationListener();
        boolean hasContent = this.hasPrintContent();
        if (hasContent) {
            this.verifyEditionType(this.getModel());
            this.getPrintJob().preparePagination();
        }
        return hasContent;
    }

    public void printDirectNoPagination() {
        if (this.hasPrintContent()) {
            this.controlPrint.print(this.getPrintJob());
        }
    }

    private boolean isPrintDirect() {
        return true;
    }

    private boolean hasPrintContent() {
        boolean hasContent = false;
        IPrintJob job = this.getPrintJob();
        if (job != null) {
            hasContent = !job.isEmpty();
        }
        return hasContent;
    }

    private IConfigModel getModel() {
        PrintJobConfig printJobConfig = this.getPrintJob().getConfig();
        if (printJobConfig == null) {
            printJobConfig = this.config.getJobsConfigs()[0];
        }
        return null;
    }

    public void verifyEditionType(IConfigModel model) {
    }

    private void setWaterMark(String mark, IConfigModel model) {
        if (model instanceof PageSetupModel) {
            MixVariantLabelCell waterMark = null;
            waterMark = ((PageSetupModel)model).getWaterMark() != null ? ((PageSetupModel)model).getWaterMark() : new MixVariantLabelCell();
            waterMark.setText(mark + "     ");
            waterMark.setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            ((PageSetupModel)model).setWaterMark(waterMark);
            if (this.getPrintJob() != null && this.getPrintJob().getConfig() != null) {
                this.getPrintJob().getConfig().setChange(true);
            }
        }
    }

    public void clear() {
        this.getPrintConfig().clear();
        this.printJob.clear();
        if (FIRST_LOAD) {
            TempFileUtil.deleteTempFile();
            FIRST_LOAD = false;
        }
    }

    public void removeAllPrintActionListeners() {
        this.listenerList = new EventListenerList();
    }

    public void prompt(String string) {
    }

    public void prompt(String string, Throwable th) {
    }

    public void addPrintJob(IPrintJob job) {
        this.printJob.addPrintJob(job);
    }

    public void setPrintJob(IPrintJob job) {
        this.clear();
        job.setPrinter(this);
        this.printJob = job;
    }

    public IPrintJob getPrintJobByPaperIndex(int paperIndex) {
        return this.printJob.getPrintJobByPaperIndex(paperIndex);
    }

    public IVariantParser getVariantParser() {
        return this.variantParser;
    }

    public void setVariantParser(IVariantParser variantParser) {
        this.variantParser = variantParser;
    }

    public IVariantParser getDefaultVariantParser() {
        if (this.defaultVariantParser == null) {
            this.defaultVariantParser = new DefaultVariantParser();
        }
        return this.defaultVariantParser;
    }

    public void setDefaultVariantParser(IVariantParser defaultVariantParser) {
        this.defaultVariantParser = defaultVariantParser;
    }

    public String getID() {
        return null;
    }

    public void registerConfigUI(String name, Class class1, int position) {
        this.config.registerConfigUI(name, class1, position);
    }

    public void unRegisterConfigUI(String name) {
        this.config.unRegisterConfigUI(name);
    }

    public static IXmlTranslate getPainterXmlTranslate(String name) {
        if (painterXmlTranslateMap != null) {
            return (IXmlTranslate)painterXmlTranslateMap.get(name);
        }
        return null;
    }

    public static synchronized void registerPainterXmlTranslate(String name, IXmlTranslate trans) {
        if (painterXmlTranslateMap == null) {
            painterXmlTranslateMap = new HashMap(1);
        }
        painterXmlTranslateMap.put(name, trans);
    }

    public void removePrintActionListener(IPrintActionListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IPrintActionListener.class, l);
    }

    public void addPreviewActionListener(IPrintActionListener lisener) {
        this.addListener(IPrintActionListener.class, lisener);
    }

    public void addPrintActionListener(IPrintActionListener lisener) {
        this.addListener(IPrintActionListener.class, lisener);
    }

    public void addConfigChangeListener(IConfigChangeListener lisener) {
        this.addListener(IConfigChangeListener.class, lisener);
    }

    private void addListener(Class listenerClass, EventListener lisener) {
        if (lisener == null) {
            return;
        }
        this.listenerList.add(listenerClass, lisener);
    }

    public void removeConfigChangeListener(IConfigChangeListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IConfigChangeListener.class, l);
    }

    public void removePreviewActionListener(IPrintActionListener l) {
        if (l == null) {
            return;
        }
        this.listenerList.remove(IPrintActionListener.class, l);
    }

    protected void firePrintPaginationListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePrintOrPreview();
        }
    }

    public void firePrintListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePrint();
        }
    }

    protected void firePreviewActionListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).beforePreview();
        }
    }

    protected void fireClosePreviewActionListener() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IPrintActionListener.class) continue;
            ((IPrintActionListener)listeners[i + 1]).closePreview();
        }
    }

    public boolean isStopPagination() {
        return this.isStopPaginationField;
    }

    public boolean isDynamicPaper() {
        return this.config.getModel().isDynamicPaper();
    }

    public void setDynamicPaper(boolean isDynamicpaper) {
        this.config.getModel().setDynamicPaper(isDynamicpaper);
    }

    public String[] getHeadFootPreList() {
        return headFootPreList;
    }

    public IPaintFilter getPaintFilter() {
        return this.paintFilter;
    }

    public void setPaintFilter(IPaintFilter paintFilter) {
        this.paintFilter = paintFilter;
    }

    public IOManager getIOManager() {
        if (this.ioManager == null) {
            this.ioManager = new IOManager(this);
        }
        return this.ioManager;
    }

    public void firePageCountChange() {
    }

    public boolean isDividePage() {
        return this.isDividePageField;
    }

    public void setDividePage(boolean isReFetchPage) {
        if (this.isDividePageField != isReFetchPage) {
            this.isDividePageField = isReFetchPage;
            ((MultiBufferPrintJobs)this.getPrintJob()).changeReFecthPage(this.isDividePageField);
        }
    }

    public void setPreviewWindowType(int type) {
    }

    public boolean isExportImportButtonVisible() {
        return this.isExportImportButtonVisibleField;
    }

    public void setExportImportButtonVisible(boolean isExportImportButtonVisible) {
        this.isExportImportButtonVisibleField = isExportImportButtonVisible;
    }

    public void setMaxCopies(int max) {
        this.config.getModel().setMaxCopies(max);
    }

    public int getMaxCopies() {
        return this.config.getModel().getMaxCopies();
    }

    public boolean isEditButtonVisible() {
        return this.isEditButtonVisibleField;
    }

    public void setEditButtonVisible(boolean isEditButtonVisible) {
        this.isEditButtonVisibleField = isEditButtonVisible;
    }

    public void fireConfigWillChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configWillChange();
        }
    }

    public void fireConfigChange() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configChanged();
        }
    }

    public void fireConfigOver() {
        Object[] listeners = this.listenerList.getListenerList();
        int len = listeners.length;
        for (int i = len - 2; i >= 0; i -= 2) {
            if (listeners[i] != IConfigChangeListener.class) continue;
            ((IConfigChangeListener)listeners[i + 1]).configOver();
        }
    }

    static {
        FIRST_LOAD = true;
        headFootPreList = null;
        headFootPreList = new String[2];
        KDPrinter.headFootPreList[0] = "";
        KDPrinter.headFootPreList[1] = "&[Date] &[Time]";
    }
}

