/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.attribute;

import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import javax.print.attribute.PrintRequestAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public class HeadFootIntervalInfo
implements PrintRequestAttribute,
IXmlTranslate {
    private static final long serialVersionUID = 2350907739470641017L;
    public static final String NAME = "headerfootermargin";
    private float headTop = 0.0f;
    private float footBottom = 0.0f;
    public static final int INCH = 25400;
    public static final int MM = 1000;
    public static final HeadFootIntervalInfo DEFAULT = new HeadFootIntervalInfo(13.0f, 13.0f, 1000);
    private static final Log log = LogFactory.getLog(HeadFootIntervalInfo.class);

    public HeadFootIntervalInfo() {
        this(0.0f, 0.0f, 0);
    }

    public HeadFootIntervalInfo(float top, float bottom, int units) {
        this.headTop = top * (float)units;
        this.footBottom = bottom * (float)units;
    }

    public float getHeadTop(int units) {
        return HeadFootIntervalInfo.convertFromMicrometers(this.headTop, units);
    }

    public void setHeadTop(float top, int units) {
        this.headTop = top * (float)units;
    }

    public float getFootBottom(int units) {
        return HeadFootIntervalInfo.convertFromMicrometers(this.footBottom, units);
    }

    public void setFootBottom(float bottom, int units) {
        this.footBottom = bottom * (float)units;
    }

    public boolean equals(Object obj) {
        boolean b = false;
        if (obj instanceof HeadFootIntervalInfo) {
            b = this.headTop == ((HeadFootIntervalInfo)obj).headTop && this.footBottom == ((HeadFootIntervalInfo)obj).footBottom;
        }
        return b;
    }

    public int hashCode() {
        return (int)(this.headTop * 13.0f + this.footBottom * 37.0f);
    }

    private static float convertFromMicrometers(float v, int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units is < 1");
        }
        return v / (float)units;
    }

    public Class getCategory() {
        return HeadFootIntervalInfo.class;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Element toXmlElement() {
        Element e = AbstractXmlTranslate.createElement(this.getName());
        HeadFootIntervalInfo.setAttribute(e, "header", "" + this.headTop);
        HeadFootIntervalInfo.setAttribute(e, "footer", "" + this.footBottom);
        return e;
    }

    @Override
    public Object fromXmlElement(Element e) {
        if (e == null) {
            return null;
        }
        if (e.getName().equals(this.getName())) {
            try {
                this.headTop = Float.parseFloat(HeadFootIntervalInfo.getAttributeValue(e, "header"));
                this.footBottom = Float.parseFloat(HeadFootIntervalInfo.getAttributeValue(e, "footer"));
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
        }
        return this;
    }

    private static void setAttribute(Element e, String name, String value) {
        AbstractXmlTranslate.setAttribute(e, name, value);
    }

    private static String getAttributeValue(Element e, String name) {
        return AbstractXmlTranslate.getAttributeValue(e, name);
    }
}

