/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.attribute;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import javax.print.attribute.PrintRequestAttribute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public class ZoomScaleInfo
implements PrintRequestAttribute,
IXmlTranslate {
    private static final Log log = LogFactory.getLog(ZoomScaleInfo.class);
    private static final long serialVersionUID = -7921828338506740126L;
    public static final String NAME = "Zoomscaleinfo";
    private double scale = 1.0;
    private boolean autoFit = false;
    private int autoFitHeight = 1;
    private int autoFitWidth = 1;

    public ZoomScaleInfo() {
    }

    public ZoomScaleInfo(double pScale) {
        this.scale = ZoomScaleInfo.valideScale(pScale);
    }

    public ZoomScaleInfo(int width, int height) {
        this.autoFit = true;
        this.autoFitHeight = height;
        this.autoFitWidth = width;
    }

    public ZoomScaleInfo(int width, int height, double scale) {
        this.autoFit = true;
        this.autoFitHeight = height;
        this.autoFitWidth = width;
        this.scale = ZoomScaleInfo.valideScale(scale);
    }

    public Class getCategory() {
        return ZoomScaleInfo.class;
    }

    public void setScale(float pScale) {
        this.scale = ZoomScaleInfo.valideScale(pScale);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public static double valideScale(double pScale) {
        if (pScale <= 0.0) {
            pScale = 1.0;
        }
        return pScale;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean equals(Object obj) {
        boolean b = false;
        if (obj instanceof ZoomScaleInfo) {
            ZoomScaleInfo info = (ZoomScaleInfo)obj;
            b = this.scale == info.scale && this.autoFit == info.autoFit && this.autoFitWidth == info.autoFitWidth && this.autoFitHeight == info.autoFitHeight;
        }
        return b;
    }

    @Override
    public Element toXmlElement() {
        Element e = AbstractXmlTranslate.createElement(this.getName());
        if (this.isAutoFit()) {
            e.addAttribute("autoFit", "true");
            e.addAttribute("fitHeight", String.valueOf(this.autoFitHeight));
            e.addAttribute("fitWidth", String.valueOf(this.autoFitWidth));
        }
        e.setText("" + this.scale);
        return e;
    }

    @Override
    public Object fromXmlElement(Element e) {
        if (e == null) {
            return null;
        }
        if (e.getName().equals(this.getName())) {
            try {
                this.scale = Double.parseDouble(e.getText());
            }
            catch (Exception ex) {
                log.error((Throwable)ex);
            }
            if ("true".equals(e.attributeValue("autoFit"))) {
                String width;
                this.autoFit = true;
                String height = e.attributeValue("fitHeight");
                if (!StringUtil.isEmptyString(height)) {
                    try {
                        this.autoFitHeight = Integer.parseInt(height);
                    }
                    catch (Exception ex) {
                        log.error((Throwable)ex);
                    }
                }
                if (!StringUtil.isEmptyString(width = e.attributeValue("fitWidth"))) {
                    try {
                        this.autoFitWidth = Integer.parseInt(width);
                    }
                    catch (Exception ex) {
                        log.error((Throwable)ex);
                    }
                }
            }
        }
        return this;
    }

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean autoFit) {
        this.autoFit = autoFit;
    }

    public int getAutoFitHeight() {
        return this.autoFitHeight;
    }

    public void setAutoFitHeight(int autoFitHeight) {
        this.autoFitHeight = autoFitHeight;
    }

    public int getAutoFitWidth() {
        return this.autoFitWidth;
    }

    public void setAutoFitWidth(int autoFitWidth) {
        this.autoFitWidth = autoFitWidth;
    }
}

