/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.ui;

import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.config.ui.AbstractConfigModel;
import com.kingdee.bos.ctrl.print.config.xml.PageSetupTranslate;
import com.kingdee.bos.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import javax.print.PrintService;
import javax.print.attribute.DocAttributeSet;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;

public class PageSetupModel
extends AbstractConfigModel {
    public static final int FIX = 0;
    public static final int FLOAT = 1;
    private PrintRequestAttributeSet printRequestAttrSet;
    private DocAttributeSet docAttrSet;
    private boolean isFrugalPrintField = false;
    private int footerAlign = 0;
    private int headerAlign = 0;
    private MixVariantLabelCell waterMark = new MixVariantLabelCell();
    private boolean waterMark_onlyFirstPage = false;
    private Color backGroundColor;
    private Image backGround;
    private String imagePath;
    private String backGroundUrl;
    private byte backGroundFillMode = 0;
    private float pageAdjustX = 0.0f;
    private float pageAdjustY = 0.0f;
    private String printService;
    private PageIntervalInfo unPrintableArea;
    public static final int CENTERALIGN_DEFAULT = 0;
    public static final int CENTERALIGN_HORIZONTAL = 1;
    public static final int CENTERALIGN_VERTICAL = 2;
    public static final int CENTERALIGN_CENTER = 3;
    private int centerAlign = 0;
    public static final Style WATERMARK_DEFAULTSTYLE;

    public PageSetupModel() {
        this.waterMark.setStyle(WATERMARK_DEFAULTSTYLE);
        this.waterMark.setLayer(99);
    }

    public PageIntervalInfo getUnPrintableArea(PrintService service) {
        if (this.printService == null && service == null) {
            this.unPrintableArea = null;
            return new PageIntervalInfo();
        }
        String thename = service.getName();
        if (this.printService == null || !thename.endsWith(this.printService)) {
            this.unPrintableArea = KDPrinterUtils.countUnPrintableArea(service, (Media)this.getPrintRequestAttributeSet().get(Media.class));
        }
        return this.unPrintableArea;
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        if (this.printRequestAttrSet == null) {
            this.printRequestAttrSet = new HashPrintRequestAttributeSet();
        }
        return this.printRequestAttrSet;
    }

    public DocAttributeSet getDocAttributeSet() {
        if (this.docAttrSet == null) {
            this.docAttrSet = new HashDocAttributeSet();
        }
        return this.docAttrSet;
    }

    public void setFrugalPrint(boolean b) {
        this.isFrugalPrintField = b;
    }

    public boolean isFrugalPrint() {
        return this.isFrugalPrintField;
    }

    public int getFooterAlign() {
        return this.footerAlign;
    }

    public void setFooterAlign(int align) {
        this.footerAlign = align;
    }

    @Override
    public void setDefault() {
        this.clear();
        this.isFrugalPrintField = false;
        this.footerAlign = 0;
        this.headerAlign = 0;
    }

    public void clear() {
        if (this.printRequestAttrSet != null) {
            this.printRequestAttrSet.clear();
        }
        if (this.docAttrSet != null) {
            this.docAttrSet.clear();
        }
    }

    @Override
    public IXmlTranslate createXmlTrans() {
        return new PageSetupTranslate(this);
    }

    @Override
    public void set(IConfigModel from) {
        PageSetupModel model = (PageSetupModel)from;
        this.getPrintRequestAttributeSet().clear();
        this.getPrintRequestAttributeSet().addAll(model.printRequestAttrSet);
        this.isFrugalPrintField = model.isFrugalPrintField;
        this.waterMark = model.getWaterMark();
        this.imagePath = model.imagePath;
        this.backGround = model.backGround;
        this.backGroundUrl = model.backGroundUrl;
        this.backGroundColor = model.backGroundColor;
        this.backGroundFillMode = model.backGroundFillMode;
        this.footerAlign = model.footerAlign;
        this.headerAlign = model.headerAlign;
    }

    @Override
    public Object copy() {
        PageSetupModel newModel = new PageSetupModel();
        newModel.set(this);
        return newModel;
    }

    public MixVariantLabelCell getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(MixVariantLabelCell waterMark2) {
        this.waterMark = waterMark2;
    }

    public boolean isWaterMark_onlyFirstPage() {
        return this.waterMark_onlyFirstPage;
    }

    public void setWaterMark_onlyFirstPage(boolean isOnlyFirstPage) {
        this.waterMark_onlyFirstPage = isOnlyFirstPage;
    }

    public Image getBackGround() {
        if (this.backGround == null && this.imagePath != null) {
            File image = new File(this.imagePath);
            if (image.exists()) {
                this.backGround = Toolkit.getDefaultToolkit().createImage(this.imagePath);
                KDPrinterUtils.waitForImage(this.backGround, new Component(){});
            } else {
                this.imagePath = null;
            }
        }
        return this.backGround;
    }

    public void setBackGround(Image backGround) {
        this.backGround = backGround;
    }

    public String getBackGroundUrl() {
        return this.backGroundUrl;
    }

    public void setBackGroundUrl(String backGroundUrl) {
        this.backGroundUrl = backGroundUrl;
    }

    public Color getBackGroundColor() {
        return this.backGroundColor;
    }

    public void setBackGroundColor(Color backGroundColor) {
        this.backGroundColor = backGroundColor;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String path) {
        this.imagePath = path;
    }

    public byte getBackGroundFillMode() {
        return this.backGroundFillMode;
    }

    public void setBackGroundFillMode(byte backGroundFillMode) {
        this.backGroundFillMode = backGroundFillMode;
    }

    public int getCenterAlign() {
        return this.centerAlign;
    }

    public void setCenterAlign(int centerAlign) {
        this.centerAlign = centerAlign;
    }

    @Deprecated
    public float getPageAdjustX() {
        return this.pageAdjustX;
    }

    @Deprecated
    public void setPageAdjustX(float pageAdjustX) {
        this.pageAdjustX = pageAdjustX;
    }

    @Deprecated
    public float getPageAdjustY() {
        return this.pageAdjustY;
    }

    @Deprecated
    public void setPageAdjustY(float pageAdjustY) {
        this.pageAdjustY = pageAdjustY;
    }

    public int getHeaderAlign() {
        return this.headerAlign;
    }

    public void setHeaderAlign(int headerAlign) {
        this.headerAlign = headerAlign;
    }

    static {
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontColor(new Color(173, 173, 173));
        sa.setFontSize(50);
        sa.setRotation(-45);
        WATERMARK_DEFAULTSTYLE = Styles.getStyle(sa);
    }
}

