/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.xml;

import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.IXmlTranslate;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.HeadFootIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeInfo;
import com.kingdee.bos.ctrl.print.config.attribute.ValidateAreaInfo;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Element;

public abstract class AbstractPrintAttributeTranslate
extends AbstractXmlTranslate {
    public static final String CHILD_SERVICENAME = "printerName";
    public static final String CHILD_ATTRIBUTES = "attributeSet";
    public static final String CHILD_FRUGAL = "frugal";
    public static final String CHILD_CENTER_ALIGN = "center_align";
    public static final String CHILD_STYLE = "style";
    public static final String CHILD_WATERMARK = "watermark";
    public static final String CHILD_WATERMARK_ISFIRSTPAGE = "firstPage";
    public static final String CHILD_BACKGROUNDCOLOR = "backgroundcolor";
    public static final String CHILD_BACKGROUNDINFO = "backgroundinfo";
    public static final String CHILD_FOOT_ALIGN = "foot_align";
    public static final String CHILD_HEAD_ALIGN = "head_align";
    private static final Log log = LogFactory.getLog(AbstractPrintAttributeTranslate.class);
    protected static final Object[] extendAttributes = new Object[]{"headerfootermargin", HeadFootIntervalInfo.class, "custom", MediaSizeNameExtend.class, "papermargin", PageIntervalInfo.class, "PageRangeInfo", PageRangeInfo.class, "ValideAreaInfo", ValidateAreaInfo.class, "Zoomscaleinfo", ZoomScaleInfo.class};
    private static final MediaSizeName[] mediaSizeNameValueTable = new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10};

    public AbstractPrintAttributeTranslate(IConfigModel model) {
        super(model);
    }

    protected static Attribute fromPrintAttribute(Element childElement) {
        String name = childElement.getName();
        Attribute attri = null;
        if (new Copies(1).getName().equals(name)) {
            String text = childElement.getText();
            attri = new Copies(Integer.parseInt(text));
        } else if (new JobName("", null).getName().equals(name)) {
            attri = new JobName(childElement.getText(), null);
        } else if (new PageRanges(1).getName().equals(name)) {
            String str = childElement.getText();
            attri = new PageRanges(str);
        } else if (OrientationRequested.PORTRAIT.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = OrientationRequested.PORTRAIT.getValue() == value ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE;
        } else if (Chromaticity.COLOR.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = Chromaticity.COLOR.getValue() == value ? Chromaticity.COLOR : Chromaticity.MONOCHROME;
        } else if (MediaSizeName.ISO_A4.getName().equals(name)) {
            attri = AbstractPrintAttributeTranslate.getMediaSizeNameByValue(childElement);
        } else if (Sides.DUPLEX.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = AbstractPrintAttributeTranslate.getSidesByValue(value);
        } else if (new RequestingUserName("", null).getName().equals(name)) {
            attri = new RequestingUserName(childElement.getText(), null);
        } else if (SheetCollate.COLLATED.getName().equals(name)) {
            int value = Integer.parseInt(childElement.getText());
            attri = SheetCollate.COLLATED.getValue() == value ? SheetCollate.COLLATED : SheetCollate.UNCOLLATED;
        } else {
            for (int i = 0; i < extendAttributes.length; ++i) {
                String iname = (String)extendAttributes[i];
                if (iname.equals(name)) {
                    Class aclass = (Class)extendAttributes[i + 1];
                    try {
                        attri = (Attribute)aclass.newInstance();
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                    }
                    if (attri != null) {
                        attri = (Attribute)((IXmlTranslate)((Object)attri)).fromXmlElement(childElement);
                    }
                }
                ++i;
            }
        }
        return attri;
    }

    protected void toPrintAttributes(AttributeSet aset) {
        if (aset == null) {
            return;
        }
        Element nodeAttributeSet = this.rootElement.addElement(CHILD_ATTRIBUTES);
        Attribute[] attriArray = aset.toArray();
        for (int i = 0; i < attriArray.length; ++i) {
            Attribute attri = attriArray[i];
            Element printAttributeNode = AbstractPrintAttributeTranslate.toPrintAttribute(attri);
            if (printAttributeNode == null) continue;
            nodeAttributeSet.add(printAttributeNode);
        }
    }

    public static Attribute getMediaSizeNameByValue(Element element) {
        String text = element.getText();
        int value = 0;
        try {
            value = Integer.parseInt(text);
            if (value < mediaSizeNameValueTable.length) {
                return mediaSizeNameValueTable[value];
            }
            return null;
        }
        catch (Exception e) {
            float x = Float.parseFloat(AbstractPrintAttributeTranslate.getAttributeValue(element, "x"));
            float y = Float.parseFloat(AbstractPrintAttributeTranslate.getAttributeValue(element, "y"));
            int unit = 1000;
            try {
                unit = Integer.parseInt(AbstractPrintAttributeTranslate.getAttributeValue(element, "unit"));
            }
            catch (Exception ee) {
                log.error((Throwable)ee);
            }
            MediaSizeNameExtend mse = null;
            mse = "custom".equals(text) ? MediaSizeNameExtend.CUSTOM : MediaSizeNameExtend.create(text);
            MediaSize ms = MediaSize.getMediaSizeForName(mse);
            if (ms instanceof FreeMediaSize) {
                ((FreeMediaSize)ms).setXY(x, y, unit);
            } else if (ms == null) {
                new FreeMediaSize(x, y, unit, (MediaSizeName)mse);
            }
            return mse;
        }
    }

    private static Attribute getSidesByValue(int value) {
        if (Sides.DUPLEX.getValue() == value) {
            return Sides.DUPLEX;
        }
        if (Sides.ONE_SIDED.getValue() == value) {
            return Sides.ONE_SIDED;
        }
        if (Sides.TUMBLE.getValue() == value) {
            return Sides.TUMBLE;
        }
        if (Sides.TWO_SIDED_LONG_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_LONG_EDGE;
        }
        if (Sides.TWO_SIDED_SHORT_EDGE.getValue() == value) {
            return Sides.TWO_SIDED_SHORT_EDGE;
        }
        return null;
    }

    protected static Element toPrintAttribute(Attribute attri) {
        if (attri instanceof IXmlTranslate) {
            Element e = ((IXmlTranslate)((Object)attri)).toXmlElement();
            return e;
        }
        Class<? extends Attribute> category = attri.getCategory();
        Element nodeAttribute = AbstractPrintAttributeTranslate.createElement(attri.getName());
        if (category == Copies.class) {
            nodeAttribute.setText("" + ((Copies)attri).getValue());
        } else if (category == JobName.class) {
            nodeAttribute.setText(((JobName)attri).getValue());
        } else if (category == PageRanges.class) {
            String members = ((PageRanges)attri).toString();
            nodeAttribute.setText(members);
        } else if (category == OrientationRequested.class) {
            nodeAttribute.setText("" + ((OrientationRequested)attri).getValue());
        } else if (category == Chromaticity.class) {
            nodeAttribute.setText("" + ((Chromaticity)attri).getValue());
        } else if (category == Media.class) {
            int value = ((Media)attri).getValue();
            if (value >= mediaSizeNameValueTable.length) {
                nodeAttribute.setText("" + ((Media)attri).toString());
            } else {
                nodeAttribute.setText("" + ((Media)attri).getValue());
            }
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)attri);
            nodeAttribute.addAttribute("unit", "1000");
            nodeAttribute.addAttribute("x", String.valueOf(ms.getX(1000)));
            nodeAttribute.addAttribute("y", String.valueOf(ms.getY(1000)));
        } else if (category == Sides.class) {
            nodeAttribute.setText("" + ((Sides)attri).getValue());
        } else if (category == RequestingUserName.class) {
            nodeAttribute.setText("" + ((RequestingUserName)attri).getValue());
        } else if (category == SheetCollate.class) {
            nodeAttribute.setText("" + ((SheetCollate)attri).getValue());
        } else {
            nodeAttribute = null;
        }
        return nodeAttribute;
    }
}

