/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.xml;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.AbstractXmlTranslate;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.ui.HeaderFooterModel;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.bos.ctrl.print.ui.io.Painter2Xml;
import com.kingdee.bos.ctrl.print.ui.io.Xml2Painter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.dom4j.Element;

public class HeaderFooterConfigTranslate
extends AbstractXmlTranslate {
    public static final String NAME = "headerfooter";
    public static final String E_header = "header";
    public static final String E_footer = "footer";
    public static final String A_TYPE = "type";
    public static final String TYPE_THREE = "three";
    public static final String TYPE_CANVAS = "canvas";

    public HeaderFooterConfigTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(Element element) {
        super.fromXmlElement(element);
        Element headerElement = HeaderFooterConfigTranslate.getChild(element, E_header);
        Element footerElement = HeaderFooterConfigTranslate.getChild(element, E_footer);
        this.fromHeaderFooter(headerElement, E_header);
        this.fromHeaderFooter(footerElement, E_footer);
        return this;
    }

    private void fromHeaderFooter(Element element, String name) {
        if (element != null) {
            String type;
            HeaderFooterModel headerModel = (HeaderFooterModel)this.model;
            HeadFootModel header = null;
            if (name.equals(E_header)) {
                header = headerModel.getHeaderModel();
                if (header == null) {
                    header = new HeadFootModel();
                    headerModel.setHeaderModel(header);
                }
            } else {
                header = headerModel.getFooterModel();
                if (header == null) {
                    header = new HeadFootModel();
                    headerModel.setFooterModel(header);
                }
            }
            if ((type = element.attributeValue(A_TYPE)) == null || type.equals(TYPE_THREE)) {
                element.setName("HeadFootModel");
                header.readFromXmlNode(element);
            } else {
                HashMap styles = new HashMap();
                this.loadStyles(element.element("Styles"), styles);
                Xml2Painter x2p = new Xml2Painter(styles);
                Canvas canvas = (Canvas)x2p.parsePainter((Element)element.elements().get(0));
                if (name.equals(E_header)) {
                    headerModel.setHeader(canvas);
                } else {
                    headerModel.setFooter(canvas);
                }
            }
        }
    }

    private void loadStyles(Element element, Map styles) {
        if (element == null) {
            return;
        }
        List sList = element.elements("Style");
        int length = sList.size();
        for (int i = 0; i < length; ++i) {
            Element s = (Element)sList.get(i);
            StyleAttributes sa = StyleParser.parseSA(s);
            Style style = Styles.getStyle(sa);
            styles.put(s.attributeValue("id"), style);
        }
    }

    @Override
    public Element toXmlElement() {
        if (this.model != null) {
            Canvas headerCanvas = ((HeaderFooterModel)this.model).getHeader();
            this.createHeaderFooter(headerCanvas, E_header);
            Canvas footerCanvas = ((HeaderFooterModel)this.model).getFooter();
            this.createHeaderFooter(footerCanvas, E_footer);
        }
        return this.rootElement;
    }

    private void createHeaderFooter(Canvas canvas, String name) {
        if (canvas != null) {
            if (canvas instanceof HeaderFooter) {
                this.toHeaderFooter(canvas, name);
            } else {
                this.toHeaderFooter2(canvas, name);
            }
        }
    }

    private void toHeaderFooter2(Canvas headerCanvas, String name) {
        Painter2Xml pxml = new Painter2Xml();
        Element canvas = pxml.makePainter(headerCanvas);
        Element header = HeaderFooterConfigTranslate.createElement(name);
        header.add(canvas);
        Element nodeStyles = HeaderFooterConfigTranslate.createElement("Styles");
        Iterator iter = pxml.getStyles().entrySet().iterator();
        StyleParser.writeStyles(nodeStyles, null, iter);
        header.add(nodeStyles);
        header.addAttribute(A_TYPE, TYPE_CANVAS);
        this.rootElement.add(header);
    }

    private void toHeaderFooter(Canvas headerCanvas, String name) {
        HeadFootModel header = ((HeaderFooter)headerCanvas).getModel();
        if (header != null) {
            Element element = this.rootElement.addElement("HeadFootModel");
            element.addAttribute("id", "");
            ListIterator it = header.getRows();
            int i = 0;
            while (it.hasNext()) {
                HeadFootRow row = (HeadFootRow)it.next();
                Element eleRow = element.addElement("HeadFootRow");
                eleRow.addAttribute("id", "row" + ++i);
                StyleParser.getStyleElement(row.getSA(), "row" + i + "_Style", null, eleRow);
                Element eleText = eleRow.addElement("Text");
                eleText.addAttribute("id", "row" + i + "_Text");
                eleText.addElement(row.getOriginText());
            }
            element.remove(element.attribute("id"));
            element.setName(name);
            element.addAttribute(A_TYPE, TYPE_THREE);
        }
    }
}

