/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.xml;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleParser;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.ui.PageSetupModel;
import com.kingdee.bos.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import com.kingdee.bos.ctrl.print.ui.component.LabelCell;
import com.kingdee.bos.ctrl.print.ui.component.MixVariantLabelCell;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import org.dom4j.Element;

public class PageSetupTranslate
extends AbstractPrintAttributeTranslate {
    public static final String NAME = "general";
    private static final String FILLMODE = "fillmode";

    public PageSetupTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(Element element) {
        super.fromXmlElement(element);
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            return null;
        }
        this.fromPrintAttributes(PageSetupTranslate.getChild(element, "attributeSet"));
        this.fromFrugal(PageSetupTranslate.getChild(element, "frugal"));
        this.fromWaterMark(PageSetupTranslate.getChild(element, "watermark"));
        this.fromBackGroundColor(PageSetupTranslate.getChild(element, "backgroundcolor"));
        this.fromBackGroundInfo(PageSetupTranslate.getChild(element, "backgroundinfo"));
        this.fromCenterAlign(PageSetupTranslate.getChild(element, "center_align"));
        this.fromFootAlign(PageSetupTranslate.getChild(element, "foot_align"));
        this.fromHeadAlign(PageSetupTranslate.getChild(element, "head_align"));
        return this;
    }

    private void fromCenterAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = 0;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setCenterAlign(model);
    }

    private void fromFootAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = 0;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setFooterAlign(model);
    }

    private void fromHeadAlign(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        int model = 0;
        if (child != null) {
            model = Integer.parseInt(child.getText());
        }
        configModel.setHeaderAlign(model);
    }

    private void fromFrugal(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setFrugalPrint(false);
        } else {
            String text = child.getText();
            if (text.equals("true")) {
                configModel.setFrugalPrint(true);
            } else {
                configModel.setFrugalPrint(false);
            }
        }
    }

    private void fromPrintAttributes(Element child) {
        List children = child.elements();
        PageSetupModel configModel = (PageSetupModel)this.model;
        PrintRequestAttributeSet set = configModel.getPrintRequestAttributeSet();
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            Element childElement = (Element)children.get(i);
            Attribute attri = PageSetupTranslate.fromPrintAttribute(childElement);
            if (attri == null) continue;
            set.add(attri);
        }
    }

    private void fromWaterMark(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.getWaterMark().setText(null);
            configModel.getWaterMark().setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            configModel.setWaterMark_onlyFirstPage(false);
        } else {
            MixVariantLabelCell waterMark = configModel.getWaterMark();
            ((LabelCell)waterMark).setText(child.attributeValue("text"));
            String isFirstPage = child.attributeValue("firstPage");
            configModel.setWaterMark_onlyFirstPage(isFirstPage.equals("true"));
            Element style = child.element("Style");
            if (style != null) {
                StyleAttributes style1 = StyleParser.parseSA(style);
                waterMark.setStyle(Styles.getStyle(style1));
            } else {
                waterMark.setStyle(PageSetupModel.WATERMARK_DEFAULTSTYLE);
            }
        }
    }

    private void fromBackGroundColor(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setBackGroundColor(null);
        } else {
            configModel.setBackGroundColor(KDPrinterUtils.hexToColor(child.getText()));
        }
    }

    private void fromBackGroundInfo(Element child) {
        PageSetupModel configModel = (PageSetupModel)this.model;
        if (child == null) {
            configModel.setBackGround(null);
        } else {
            configModel.setImagePath(child.attributeValue("path"));
            configModel.setBackGroundFillMode(Byte.parseByte(child.attributeValue(FILLMODE)));
        }
    }

    @Override
    public Element toXmlElement() {
        PageSetupModel configModel = (PageSetupModel)this.model;
        this.toPrintAttributes(configModel.getPrintRequestAttributeSet());
        this.toFrugal(configModel.isFrugalPrint());
        this.toBackGroundColor(configModel.getBackGroundColor());
        this.toBackGroundInfo(configModel.getImagePath(), configModel.getBackGroundFillMode());
        this.toCenterAlign(configModel.getCenterAlign());
        this.toFooterAlign(configModel.getFooterAlign());
        this.toHeaderAlign(configModel.getHeaderAlign());
        return this.rootElement;
    }

    private void toWaterMark(PageSetupModel configModel) {
        MixVariantLabelCell waterMark = configModel.getWaterMark();
        boolean isFirstPage = configModel.isWaterMark_onlyFirstPage();
        if (waterMark != null && waterMark.getText() != null && !waterMark.getText().equals("")) {
            Element e = this.rootElement.addElement("watermark");
            e.addAttribute("text", waterMark.getText());
            e.addAttribute("firstPage", isFirstPage ? "true" : "false");
            if (waterMark.getStyle() != PageSetupModel.WATERMARK_DEFAULTSTYLE) {
                StyleParser.getStyleElement(waterMark.getStyle(), "", null, e);
            }
        }
    }

    private void toBackGroundColor(Color backGroundColor) {
        if (backGroundColor != null) {
            Element e = this.rootElement.addElement("backgroundcolor");
            e.setText(KDPrinterUtils.colorToHex(backGroundColor));
        }
    }

    private void toBackGroundInfo(String imagePath, byte backGroundFillMode) {
        if (imagePath != null) {
            Element e = this.rootElement.addElement("backgroundinfo");
            e.addAttribute("path", imagePath);
            if (backGroundFillMode == 0) {
                e.addAttribute(FILLMODE, String.valueOf(0));
            } else if (backGroundFillMode == 1) {
                e.addAttribute(FILLMODE, String.valueOf(1));
            } else {
                e.addAttribute(FILLMODE, String.valueOf(2));
            }
        }
    }

    private void toFrugal(boolean isFrugal) {
        if (isFrugal) {
            Element e = this.rootElement.addElement("frugal");
            e.setText("true");
        }
    }

    private void toCenterAlign(int centerAlign) {
        if (centerAlign != 0) {
            Element e = this.rootElement.addElement("center_align");
            e.setText(String.valueOf(centerAlign));
        }
    }

    private void toFooterAlign(int footerAlign) {
        if (footerAlign != 0) {
            Element e = this.rootElement.addElement("foot_align");
            e.setText(String.valueOf(footerAlign));
        }
    }

    private void toHeaderAlign(int headerAlign) {
        if (headerAlign != 0) {
            Element e = this.rootElement.addElement("head_align");
            e.setText(String.valueOf(headerAlign));
        }
    }
}

