/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.config.xml;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.print.config.IConfigModel;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.config.xml.AbstractPrintAttributeTranslate;
import javax.print.PrintService;
import org.dom4j.Element;

public class PrintGeneralTranslate
extends AbstractPrintAttributeTranslate {
    public static final String NAME = "printer";
    public static final String CHILD_DynamicPaper = "dynamicpaper";

    public PrintGeneralTranslate(IConfigModel model) {
        super(model);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object fromXmlElement(Element element) {
        super.fromXmlElement(element);
        if (element == null) {
            return null;
        }
        if (!element.getName().equals(NAME)) {
            return null;
        }
        this.fromPrinter(PrintGeneralTranslate.getChild(element, "printerName"));
        this.fromDynamicPaper(PrintGeneralTranslate.getChild(element, CHILD_DynamicPaper));
        return this;
    }

    private void fromDynamicPaper(Element child) {
        PrintConfigModel configModel = (PrintConfigModel)this.model;
        if (child == null) {
            configModel.setDynamicPaper(false);
        } else {
            String text = child.getText();
            if (text != null) {
                configModel.setDynamicPaper(text.equals("true"));
            }
        }
    }

    private void fromPrinter(Element child) {
        if (child != null) {
            String printer = child.getText();
            PrintConfigModel configModel = (PrintConfigModel)this.model;
            configModel.setCurrentServiceByName(printer);
        }
    }

    @Override
    public Element toXmlElement() {
        PrintConfigModel configModel = (PrintConfigModel)this.model;
        this.toPrinter(configModel.getPrintServiceDirect());
        this.toDynamicPaper(configModel.isDynamicPaper());
        return this.rootElement;
    }

    private void toDynamicPaper(boolean isFrugal) {
        Element e = PrintGeneralTranslate.createElement(CHILD_DynamicPaper);
        e.setText(String.valueOf(isFrugal));
        this.rootElement.add(e);
    }

    private void toPrinter(PrintService printer) {
        Element printerElement = null;
        String name = null;
        if (printer != null) {
            name = printer.getName();
        }
        if (!StringUtil.isEmptyString(name)) {
            printerElement = PrintGeneralTranslate.createElement("printerName");
            printerElement.setText(name);
        }
        if (printerElement != null) {
            this.rootElement.add(printerElement);
        }
    }
}

