/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.control;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.PropertyConfig;
import com.kingdee.bos.ctrl.print.config.attribute.PageRangeReverse;
import com.kingdee.bos.ctrl.print.control.CtrlPageable;
import com.kingdee.bos.ctrl.print.control.CtrlPrintable;
import com.kingdee.bos.ctrl.print.control.CtrlTestPrintable;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.bos.ctrl.print.util.MediaUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.PageRanges;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ControlPrint {
    private static final Log log = LogFactory.getLog(ControlPrint.class);
    public static final int NORMAL_PRINT = 0;
    public static final int TEST_SINGLE = 1;
    public static final int TEST_MULTI = 2;
    final KDPrinter printer;
    boolean isCancel = false;
    private int pageCount;
    private PrintRequestAttributeSet attributeSet;

    public ControlPrint(KDPrinter ctrlprint) {
        this.printer = ctrlprint;
    }

    public void print(IPrintJob printJob) {
        if (!this.canPaint(printJob)) {
            return;
        }
        this.isCancel = false;
        this.doPrint(printJob, 0, 0);
    }

    public boolean checkPrintService(PrintService printService) {
        if (printService == null) {
            return true;
        }
        return PropertyConfig.isUseOpenPrinterDll() && !MediaUtil.isPrinterCanUse(printService.getName());
    }

    private DocPrintJob getKDPrintJob(PrintService service) {
        Class<?> cls = null;
        try {
            cls = Class.forName("com.kingdee.bos.ctrl.print.win32.PrintJobFactory");
        }
        catch (ClassNotFoundException e) {
            cls = null;
        }
        if (cls == null) {
            return null;
        }
        Method mtd = null;
        try {
            mtd = cls.getMethod("createPrintJob", PrintService.class);
        }
        catch (SecurityException e) {
            mtd = null;
        }
        catch (NoSuchMethodException e) {
            mtd = null;
        }
        if (mtd != null) {
            try {
                return (DocPrintJob)mtd.invoke(null, service);
            }
            catch (IllegalArgumentException e) {
                log.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    protected void doPrint(IPrintJob mulContent, int isTestPrint, int copies) {
        PrintRequestAttributeSet praset;
        PrintService printService = this.printer.getPrintService();
        if (this.checkPrintService(printService)) {
            return;
        }
        if (isTestPrint == 0) {
            this.printer.firePrintListener();
        }
        if (this.isCancel()) {
            this.updatePrintingPrompt(1, -1);
            return;
        }
        DocPrintJob docPrintJob = this.getDocPrintJob(printService);
        CtrlPrintable defPrintable = this.configDefaultPrintable(isTestPrint, copies);
        CtrlPageable pageable = new CtrlPageable(this.printer, mulContent);
        this.pageCount = isTestPrint != 0 ? copies : mulContent.getPageCount();
        pageable.setNumberOfPages(this.pageCount);
        pageable.setDefaultPrintable(defPrintable);
        DocFlavor docFlavor = (DocFlavor)mulContent.getContentType();
        SimpleDoc doc = new SimpleDoc(pageable, docFlavor, null);
        this.attributeSet = praset = this.printer.getPrintConfig().buildPrintRequAttrSet();
        PageRangeReverse prr = (PageRangeReverse)praset.get(PageRangeReverse.class);
        if (prr != null && prr.isReverse()) {
            PageRanges nowRange = (PageRanges)praset.get(PageRanges.class);
            ArrayList printPage = KDPrinterUtils.getPrintPage(this.printer.getPrintJob().getPageCount(), nowRange);
            prr.setPrintPage(printPage);
        }
        this.callPrint(docPrintJob, doc, praset);
    }

    private DocPrintJob getDocPrintJob(PrintService printService) {
        DocPrintJob docPrintJob = null;
        String version = System.getProperty("java.version");
        boolean isNewVersion = false;
        if ("1.5.0".compareTo(version) <= 0) {
            isNewVersion = true;
        }
        String printerName = this.printer.getPrintConfig().getPrintService().getName();
        boolean enableAdjust = this.printer.getPrintConfig().getAdjustor().isEnableAdjust(printerName);
        if (enableAdjust && isNewVersion) {
            docPrintJob = this.getKDPrintJob(printService);
        }
        if (docPrintJob == null) {
            docPrintJob = printService.createPrintJob();
        }
        if (docPrintJob == null) {
            throw new NullPointerException("The Exception is thrown by the Print Framework, please try to print again. If the exceptoin happens a second time, please check if the Printer has been installed on your computer already.");
        }
        return docPrintJob;
    }

    private void callPrint(DocPrintJob docPrintJob, Doc doc, PrintRequestAttributeSet praset) {
        Runnable runnable = () -> {
            try {
                docPrintJob.print(doc, praset);
                this.updatePrintingPrompt(1, -1);
            }
            catch (Throwable e) {
                this.updatePrintingPrompt(1, -1);
                log.error(e);
            }
            finally {
                this.printer.getPrintConfig().getModel().reset();
            }
        };
        new Thread(runnable).start();
    }

    public void doPrintTest() {
        this.isCancel = false;
        this.doPrint(this.printer.getPrintJob(), 1, 1);
    }

    public void doMultiPaperPrintTest(int copies) {
        this.isCancel = false;
        this.doPrint(this.printer.getPrintJob(), 2, copies);
    }

    protected boolean canPaint(IPrintJob printJob) {
        if (printJob == null) {
            return false;
        }
        return printJob.getTaskCount() > 0;
    }

    private CtrlPrintable configDefaultPrintable(int isTestPrint, int copies) {
        if (isTestPrint == 0) {
            return new CtrlPrintable(this, this.printer);
        }
        CtrlTestPrintable printable = new CtrlTestPrintable(this, this.printer);
        if (isTestPrint == 2) {
            printable.setTestType(false);
        }
        printable.setCopies(copies);
        return printable;
    }

    public static final DocPrintJob createPrintJob(PrintService ps) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return ps.createPrintJob();
    }

    public Paper getPaper(int index) {
        Paper paper = this.printer.getPrintJob().getPaper(index);
        if (paper != null && this.printer.isDynamicPaper()) {
            KDPrinterUtils.adjustPaperBounds(paper);
        }
        return paper;
    }

    public KDPrinter getJob() {
        return this.printer;
    }

    public void updatePrintingPrompt(int res, int pageIndex) {
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void cancel() {
        this.isCancel = true;
    }

    public Paper getTestPaper(boolean testType) {
        return this.printer.getPrintJob().getTestPaper(testType);
    }

    public PrintRequestAttributeSet getAttribute() {
        return this.attributeSet;
    }
}

