/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.control;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.ui.PaperAdjustModel;
import com.kingdee.bos.ctrl.print.control.CtrlPrintable;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;

public class CtrlPageable
implements Pageable {
    private CtrlPrintable defaulPrintable = null;
    private IPrintJob printJob;
    private KDPrinter printer;
    private int numberOfPages = -1;

    public CtrlPageable(KDPrinter printer, IPrintJob printJob) {
        this.printer = printer;
        this.printJob = printJob;
    }

    @Override
    public int getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(int pageCount) {
        this.numberOfPages = pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        float offY;
        pageIndex = KDPrinterUtils.setReversePageIndex(this.defaulPrintable.getControlPrint().getAttribute(), pageIndex);
        if (pageIndex + 1 > this.printJob.getPageCount2()) {
            pageIndex = 0;
        }
        PageFormat format = this.printJob.getPageFormat(pageIndex);
        KDPrinterUtils.printOutPageFormat(format, "Origin");
        IPrintJob job = this.printer.getPrintJobByPaperIndex(pageIndex);
        if (this.printer.isDynamicPaper() || job.isDynamicPaper()) {
            Canvas paper1 = this.defaulPrintable.getPaper(pageIndex);
            double pageHeight = (float)KDPrinterUtils.adjustPaperBounds((com.kingdee.bos.ctrl.print.ui.component.Paper)paper1).getPainterSize().getHeight();
            pageHeight = pageHeight * 1.0 / KDPrinterUtils.getScreenMapRate(KDPrinterUtils.SCREEN_RESOLUTION);
            format = this.adjustPageFormat(format, pageHeight);
            KDPrinterUtils.printOutPageFormat(format, "Dynamic");
        }
        if ((offY = this.getOffY(pageIndex)) != 0.0f) {
            Paper paper = format.getPaper();
            double newHeight = paper.getImageableHeight() + (double)offY;
            format = this.adjustPageFormat(format, newHeight);
            KDPrinterUtils.printOutPageFormat(format, "Offset");
        }
        return format;
    }

    private PageFormat adjustPageFormat(PageFormat format, double pageHeight) {
        Paper paper = format.getPaper();
        double iheight = paper.getImageableHeight();
        if (iheight == pageHeight) {
            return format;
        }
        paper.setSize(paper.getWidth(), pageHeight + paper.getImageableY() + (paper.getHeight() - iheight - paper.getImageableY()));
        paper.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getImageableWidth(), pageHeight);
        format.setPaper(paper);
        return format;
    }

    private float getOffY(int pageIndex) {
        PaperAdjustModel adjustor = this.printer.getPrintConfig().getAdjustor();
        String printer = this.printer.getPrintConfig().getPrintService().getName();
        float[] values = adjustor.getAdjustValues(printer);
        int perIndex = (int)values[0];
        float mm = (int)values[1];
        int mod = (pageIndex + 1) % perIndex;
        float offY = 0.0f;
        if (mod == 0) {
            offY = mm;
        }
        if (adjustor != null) {
            offY = offY / 25.43f * 72.0f;
            return offY;
        }
        return 0.0f;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this.defaulPrintable;
    }

    public void setDefaultPrintable(CtrlPrintable defPrintable) {
        if (defPrintable == null) {
            throw new NullPointerException("the Default Printable is null");
        }
        this.defaulPrintable = defPrintable;
    }
}

