/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.io;

import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.Release;
import com.kingdee.bos.ctrl.print.control.ControlPrint;
import com.kingdee.bos.ctrl.print.ui.component.Paper;
import com.kingdee.bos.ctrl.print.util.TempFileUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.browser.R1PrintPageProvider;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AbstractExport
implements Release {
    private static final Log log = LogFactory.getLog(AbstractExport.class);

    public void begin(String fileNamePre, KDPrinter printer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String fileNamePre, KDPrinter printer) {
        try {
            Paper paper;
            this.begin(fileNamePre, printer);
            ControlPrint cPrint = printer.getControlPrint();
            int index = 0;
            while ((paper = cPrint.getPaper(index)) != null) {
                this.exportPaper(paper, fileNamePre, index);
                ++index;
            }
            this.end();
        }
        finally {
            this.release();
            this.clearTempFile(printer);
        }
    }

    public void end() {
    }

    protected abstract void exportPaper(Paper var1, String var2, int var3);

    protected void clearTempFile(KDPrinter printer) {
        try {
            int jobCount = printer.getPrintJob().getTaskCount();
            for (int i = 0; i < jobCount; ++i) {
                ((R1PrintPageProvider)printer.getPrintJob().getPrintJob(i).getPageProvider()).clearTempFile();
                boolean result = TempFileUtil.clearPrintTempFileDir();
                log.debug("\u6e05\u7406\u6253\u5370\u521b\u5efa\u7684\u4e34\u65f6\u6587\u4ef6\uff0c\u6e05\u9664\u7ed3\u679c\u4e3a\uff1a" + result);
            }
        }
        catch (Exception ignore) {
            log.error("\u6e05\u7406\u6253\u5370\u521b\u5efa\u7684\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)ignore);
        }
    }
}

